function Cloud = Cloud_post(Cloud, thresh)
%% 后处理
Cloud_bina = Cloud>0;  % 将灰度或彩色图像转换为二值图像

% 使用 bwlabel 函数标记连通域
L = bwlabel(Cloud_bina, 8);  % 8表示8连通性

% 使用 regionprops 函数计算每个连通域的属性
stats = regionprops(L, 'Area', 'PixelIdxList');

% 筛选出面积大于thresh的连通域
areas = [stats.Area];
idxs = find(areas > thresh);

% 创建一个新的二值矩阵，仅保留面积大于5的连通域
filteredCloud = false(size(Cloud_bina));
for i = 1:length(idxs)
    filteredCloud(stats(idxs(i)).PixelIdxList) = true;
end

Cloud = Cloud .* uint8(filteredCloud);
end