%%
function col = ChooseKtableCol(xmlStruct, WaterVapor)
% 根据场景参数（水汽、月份）选择相应的K值参数，返回列号
if(WaterVapor >= 0 && WaterVapor < 0.3) % 低水汽含量
    Water_ind = 0;
elseif(WaterVapor >= 0.3 && WaterVapor < 0.7) % 中水汽含量
    Water_ind = 1;
elseif(WaterVapor >= 0.7)
    Water_ind = 2;
else
    fprintf("请检查水汽含量是否正确！\n");
end
MON = month(str2date(xmlStruct.StartTime));
if(MON >= 6 && MON <= 8) % MODEL = 2; % 中纬度夏季模型
    col = 3 + Water_ind;
elseif((MON == 1) || (MON >= 11 && MON <= 12)) % MODEL = 3; % 中纬度冬季模型
    col = 6 + Water_ind;
else % MODEL = 6; % 默认1976大气参数
    col = 9 + Water_ind;
end
end