%% Write tape5
% tape5 是modtran 的参数输入文件
function write_tape5(MODEL, CO2MX, H2OVP, ANGLE, WAVNUM1, WAVNUM2, albedo)
%% 删除上次编辑的文件
filename = 'D:\PcModWin5\Bin\tape5';
if(~exist(filename, 'file'))
    filename = 'E:\PcModWin5\Bin\tape5';
    if(~exist(filename, 'file'))
        disp("未找到MODTRAN路径")
    end
end
delete(filename); % 删除上一次的文件
%% 打开文件
fid = fopen(filename,'w'); % 写入文件路径
% 一般而言，浮点数的宽度都是10
% 一般而言，整数的宽度都是5
%% CARD1
% 6： 1976 US Standard
% 3： use slant path to space
% 4： MODTRAN calculates atmospheric radiance with no thermal scatter
% 2： MODTRAN executes with scattering （第4个数字）
fprintf(fid, 'T F %d    3    4    2    0    0    0    0    0    0    0    0    0   0.000%7.5f\r\n', MODEL, albedo);
%% CARD1A
% 调整CO2的混合比，400ppmv->500ppmv ， 输入格式为%10.3f，位宽为10，小数点后3位。
fprintf(fid, 'fFF  2   0%10.3fg%9.6f  0.000000', CO2MX, H2OVP); % 二氧化碳 水汽 臭氧（默认）
fprintf(fid, '0F F F F F               0.000     0.000     0.000     0.000         0\r\n'); % 参数有点多，换行显示
%% CARD2
fprintf(fid, '    1    0    1    0    0    0     0.000     0.000     0.000     0.000     0.000\r\n'); % 23km能见度
%% CARD3 | H1 H2 ANGLE
fprintf(fid, '750.000000  0.000000%10.6f   0.00000  0.000000  0.000000    0       0.000000  0.000000\r\n', ANGLE);
%% CARD3A1
fprintf(fid, '    0    0    1    0\r\n');
%% CARD3A2
fprintf(fid, '     0.000     0.000     0.000     0.000     0.000     0.000     0.000     0.000\r\n'); % 太阳几何参数
%% CARD
% 第三个参数为运行步长
% 第四个参数表示FWHM of slit function
fprintf(fid, '%10.f%10.f   1.00000   1.00000 W         3       0     0.000\r\n', WAVNUM1, WAVNUM2);
%%
fprintf(fid, '    0\r\n');
%% 关闭文件
fclose(fid);
end