function [k, rmv_idx] = Calc_abs(FWHM_SWIR, Gas, xmlStruct, GasType)
%% 参数：波数起止、步长
FWHM = FWHM_SWIR(Gas.bandindex, :); % 提取所选波段
WAVNUM1 = round(1e7 / Gas.Band_wav2 - 100);
WAVNUM2 = round(1e7 / Gas.Band_wav1 + 100);
STEP = 1; % MOTRAN运行步长
SolarAzimuth = str2double(xmlStruct.SolarAzimuth); % 太阳方位角
SolarZenith = str2double(xmlStruct.SolarZenith); % 太阳天顶角
SatelliteZenith = str2double(xmlStruct.SatelliteZenith);
MON = month(str2date(xmlStruct.StartTime));
albedo = 0;
%% 参数文件
if(MON >= 6 && MON <= 8)
    MODEL = 2; % 中纬度夏季模型
elseif((MON == 1) || (MON >= 11 && MON <= 12))
    MODEL = 3; % 中纬度冬季模型
else
    MODEL = 6; % 默认1976大气参数
end
% MODEL = 6; % 无论月份如何，均使用1976美国标准大气参数
%% 单位转换（波长转波数）
FWHM_(:,1) = 1e7 ./ FWHM(:,1);
FWHM_(:,2) = 1e7 ./ (FWHM(:,1) - FWHM(:,2)/2) - 1e7 ./ (FWHM(:,1)+FWHM(:,2)/2);
BandLen = size(FWHM_, 1); % 波段个数
FWHM_wavnum = mean(FWHM_(:,2));
% FWHM_wavnum = 100;
%%
NUM = 10; % NUM 表示执行MODTRAN的次数，也表示不同浓度的个数
radiance_total = cell(NUM, 1);
if(strcmp(GasType, 'CO2')) % 反演二氧化碳
    c_CO2 = linspace(400, 500, NUM); % 单位：ppmv
    delta_c = (c_CO2(2:end) - c_CO2(1))'; % 浓度差
    c_H2O = 0.5;
    for j = 1 : NUM
        %% 输入文件
        CO2MX = c_CO2(j);
        H2OSTR = c_H2O;
        write_tape5(MODEL, CO2MX, H2OSTR, SolarAzimuth, SolarZenith, SatelliteZenith,...
            WAVNUM1, WAVNUM2, STEP, FWHM_wavnum, albedo);
        %% 提取结果
        radiance_total{j} = execute_mod();
    end
elseif(strcmp(GasType, 'H2O')) % 反演水汽
    c_H2O = linspace(0.2, 4, NUM);
    delta_c = (c_H2O(2:end) - c_H2O(1))'; % 浓度差
    c_CO2 = 400; % 单位：ppmv
    for j = 1 : NUM
        %% 输入文件
        CO2MX = c_CO2;
        H2OSTR = c_H2O(j);
        write_tape5(MODEL, CO2MX, H2OSTR, SolarAzimuth, SolarZenith, SatelliteZenith,...
            WAVNUM1, WAVNUM2, STEP, FWHM_wavnum, albedo);
        %% 提取结果
        radiance_total{j} = execute_mod();
    end
end
%% 提取卷积结果
radiance_conv1 = cell(NUM, 1);
for i = 1 : BandLen
    wavenumber = FWHM_(i, 1); % 取指定波数
    [~,index] = min(abs(radiance_total{1}(:, 1) - wavenumber)); % 找相应索引
for j = 1 : NUM
    radiance_conv1{j}(i,:) = radiance_total{j}(index, 2);
end
end

%% 计算k值
y = zeros(BandLen, NUM - 1);
for j = 2 : NUM
    y(:, j - 1) = log(radiance_conv1{j}./radiance_conv1{1}); % 分别除以conv_radiance1
end
x = delta_c;
k = zeros(BandLen, 1); % 单位每ppmv

thresh = 0.99;
rmv_idx = [];
for i = 1 : BandLen
    % 最小二乘拟合结果 斜率即为 k
    p = polyfit(x, y(i, :), 1); % p = [斜率 截距]
    % p = mean(y(i, :));
    k(i) = -1 * p(1);
    R = corrcoef(x,y(i, :));
    R2 = R(1,2)^2;
    if(R2 < thresh) % 如果拟合精度较低，则不采用该波段
        rmv_idx = [rmv_idx,i];
    end
%     f = polyval(p,x);
%     plot(x,y(i,:),'o',x,f,'-')
%     legend('data','linear fit')
end
% fprintf("建议去除波段：")
% disp(rmv_idx);
if(sum(k) == 0)
    disp('k值计算错误，请检查代码！')
    return
end
% plot(FWHM(:,1),k)
end
