% 排放数据库
data_file = 'data/US_electricity.xlsx'; sheetName = '2025.1.12';
T_ori = readtable(data_file, 'Sheet', sheetName, 'VariableNamingRule', 'preserve');
%%
T = T_ori(ismember(T.plume_quality, [0.7 1]));
%% 划分标准： 质量=0.7或1；风速<3或>=3；排放小于1000或大于等于1000
T.group1 = T.plume_quality == 0.7;
T.group2 = T.wind_speed < 3;
T.group3 = T.emission < 1000;

grouped_stats_1 = groupsummary(T, 'group1', {'mean'}, ...
                             {'emission', 'emission_uncertainty', 'uncertainty_ime_part', 'uncertainty_wind_part'});
grouped_stats_2 = groupsummary(T, 'group2', {'mean'}, ...
                             {'emission', 'emission_uncertainty', 'uncertainty_ime_part', 'uncertainty_wind_part'});
grouped_stats_3 = groupsummary(T, 'group3', {'mean'}, ...
                             {'emission', 'emission_uncertainty', 'uncertainty_ime_part', 'uncertainty_wind_part'});

grouped_stats = [grouped_stats_1(:, 2:6); grouped_stats_2(:, 2:6); grouped_stats_3(:, 2:6)];
% 添加类别标签
categories = categorical({'High Confidence Plume'; 'Medium Confidence Plume'; ...
                          'Low Wind Speed (U<3m/s)'; 'High Wind Speed (U≥3m/s)'; ...
                          'Weak Emission (Q<1kt/h)'; 'Strong Emission (Q≥1kt/h)'});

% 合并统计信息，并添加分类标签
% grouped_stats = [grouped_stats_1; grouped_stats_2; grouped_stats_3];
grouped_stats.Categories = categories;
% 使用movevars函数将'Categories'移到最前面
grouped_stats = movevars(grouped_stats, 'Categories', 'Before', 1);

% 计算选定列的平均值
total_count = size(T, 1);
mean_emission = mean(T.emission);
mean_emission_uncertainty = mean(T.emission_uncertainty);
mean_uncertainty_ime_part = mean(T.uncertainty_ime_part);
mean_uncertainty_wind_part = mean(T.uncertainty_wind_part);
% 创建一个新的表格来存储结果
grouped_stats_all = table({'Total'}, total_count, mean_emission, mean_emission_uncertainty, ...
                          mean_uncertainty_ime_part, mean_uncertainty_wind_part, ...
                          'VariableNames', {'Categories', 'GroupCount', 'mean_emission', 'mean_emission_uncertainty', ...
                                           'mean_uncertainty_ime_part', 'mean_uncertainty_wind_part'});

grouped_stats = [grouped_stats; grouped_stats_all];