%% 加载路径
fun_path = genpath('functions'); addpath(fun_path)
%% 数据路径
origin_path = 'E:\2024.9 甲烷赛道数据\US\GF5B_AHSI_W111.9_N32.8_20221218_000500_L1000010000';
%% 读取文件名
flist = ReadFiles(origin_path); % 读取数据
%% 数据读取
FWHM_SWIR = Read_Raw(flist.swir_fwhm, 2); % FWHM 包含central wavelength 中心波长 和 full width at half maxima 半宽
swir = readgeoraster(flist.SWIR);
sw_rad_cal = Read_Raw(flist.swir_rad, 1); % 辐射校正系数 radiance calculation
swir = Rad_Calibration(swir, sw_rad_cal); % 短波红外辐射定标
%% 气体吸收系数
fpath_k = 'data/CH4_k/CH4_k_v3.mat'; % 吸收系数查找表路径
k_filename = 'k_GF5B';
load(fpath_k, k_filename);
k = k_GF5B(:,3);
%% 加载羽流
plumepath = 'E:\Varon\delrio\plume.mat';
load(plumepath)

%% 生成数据集
ftype = {'train', 'val'};
% train
% folder = ftype{1};
% index = 1:200;
% val
folder = ftype{2};
index = 201:240;

for num = index
    fprintf("正在生成第%d组影像\n", num);
    %% 羽流强度
    frame = randi(361);
    fprintf("选取了第%d帧羽流\n", frame);
    plume = scaled_ch4_conc_3h(:, :, frame);
    plume = rot90(plume,randi(4)); % 随机旋转
    if(randi(2)==1)
        plume = fliplr(plume); % 随机翻转
    end
    thresh = 15;
    plumemask1 = plume > 2.5*std(plume(:));
    plumemask1 = NeighMask(plumemask1, thresh);
    plumemask2 = plume > 5*std(plume(:));
    plumemask2 = NeighMask(plumemask2, thresh);
    plumemask = plumemask1 + plumemask2;
    plumemask = imfill(plumemask, 'holes'); % 填孔洞

    %% 裁剪影像
    length = 360;
    [xmax, ymax, ~] = size(swir);
    xmax = xmax - length;
    ymax = ymax - length;
    X = randi(xmax);
    Y = randi(ymax);
    cut_tiff = swir(X : X + length - 1, Y : Y + length - 1, :);

    %% 空间重采样

    %% 比尔朗伯
    plume_ = repmat(plume,[1 1 180]) * 10; % ppb 乘3便于观察
    k_shift = shiftdim(k, -2);
    k_ = repmat(k_shift, [360 360 1]); % /ppm
    scale_factor = exp(-k_.* plume_ * 1e-3);
    final_tiff = cut_tiff.* scale_factor;

    %% 反演验证
    IsAC='false';
    idx=[74:88,135:171];
    result = RMF(final_tiff(:,:,idx), k(idx), IsAC);

    %% 输出影像对
    inputimage = cat(3, final_tiff(:,:,81), final_tiff(:,:,153), result);
    inputimage = ImgStretch(inputimage, 0.5, 99.5);
    % inputimage = im2uint8(inputimage);
    annotation = uint8(plumemask);
    % imshow(inputimage);
    % imshow(annotation);
    inputfilename = fullfile('segmentation/images', folder, [num2str(num),'.jpg']);
    annotationname = fullfile('segmentation/annotations', folder, [num2str(num),'.png']);
    imwrite(inputimage, inputfilename);
    imwrite(annotation, annotationname);

end
%% 输出txt文件
folder = 'val';
fileID = fopen(['segmentation/',folder,'.txt'],'w');
for num = 201:240
    text = ['images/',folder,'/',num2str(num),'.jpg annotations/',folder,'/',num2str(num),'.png\n'];
    fprintf(fileID, text);
end
fclose(fileID);
%
fileID = fopen('seg_data.txt','w');
for num = 201:240
    text = ['/home/aistudio/data/segmentation/images/val/',num2str(num),'.jpg\n'];
    fprintf(fileID, text);
end
fclose(fileID);

%% 成图比较
figure('position', [100 300 1600 300])
subplot(141)
imagesc(cut_tiff(:,:,1))
% caxis([0 0.5])
axis square
colorbar
subplot(142)
imagesc(result)
caxis([0 0.5])
axis square
colorbar
subplot(143)
imagesc(plume)
caxis([0 500])
axis square
colorbar
subplot(144)
imagesc(plumemask)
% caxis([0 500])
axis square
colorbar


