%% 清理变量
clear; close all;
%% 加载路径
fun_path = genpath('functions'); addpath(fun_path)
%%
filename_xlsx = 'H2O_k_v3.xlsx';
fpath_xlsx = fullfile('data', filename_xlsx);
filename_mat = 'H2O_k_v3.mat';
fpath_mat = fullfile('data\H2O_k', filename_mat);
albedo = 0.4;
ANGLE = 180 - [0.36, 0.08, 0.08, 0.08, 0.08]; % 俯仰角
%% ZY1E
tic;
mydisp('开始计算ZY1E卫星的气体吸收系数');
load('data/FWHM_SWIR/ZY1E.mat')
k_ZY1E = Get_data_sheet(FWHM_SWIR, ANGLE(1), albedo, 'ZY1E');
toc;
%% ZY1F
tic;
mydisp('开始计算ZY1F卫星的气体吸收系数');
load('data/FWHM_SWIR/ZY1F.mat')
k_ZY1F = Get_data_sheet(FWHM_SWIR, ANGLE(2), albedo, 'ZY1F');
toc;
%% GF5B
tic;
mydisp('开始计算GF5B卫星的气体吸收系数');
load('data/FWHM_SWIR/GF5B.mat')
k_GF5B = Get_data_sheet(FWHM_SWIR, ANGLE(3), albedo, 'GF5B');
toc;
%% GF5A
tic;
mydisp('开始计算GF5A卫星的气体吸收系数');
load('data/FWHM_SWIR/GF5A.mat')
k_GF5A = Get_data_sheet(FWHM_SWIR, ANGLE(4),albedo, 'GF5A');
toc;
%% GF5
tic;
mydisp('开始计算GF5卫星的气体吸收系数');
load('data/FWHM_SWIR/GF5.mat')
k_GF5 = Get_data_sheet(FWHM_SWIR, ANGLE(5), albedo, 'GF5');
toc;
%% 将数据写入 Excel 文件
mydisp('开始写入 Excel 文件');
sheet_names = {'k_ZY1E', 'k_ZY1F', 'k_GF5B', 'k_GF5A', 'k_GF5'};
data_sheets = {k_ZY1E, k_ZY1F, k_GF5B, k_GF5A, k_GF5};
% 列名
column_names = {'Wavelength', 'FWHM', 'k_Summer_M', 'k_Winter_M', 'k_1976_M'};
for i = 1:length(sheet_names)
    writecell(column_names, fpath_xlsx, 'Sheet', sheet_names{i}, 'Range', 'A1'); % 写入列名
    writematrix(data_sheets{i}, fpath_xlsx, 'Sheet', sheet_names{i}, 'Range', 'A2'); % 写入数据
end
mydisp('数据写入完成');

%% 将数据写入.mat文件
save(fpath_mat, 'k_ZY1E', 'k_ZY1F', 'k_GF5B', 'k_GF5A', 'k_GF5', 'albedo', 'ANGLE');
%% 加载数据
% clear
% filename_mat = 'CO2_k_v1.mat';
% fpath_mat = fullfile('data', filename_mat);
% load(fpath_mat,'k_ZY1E')
%%
function data_sheet = Get_data_sheet(FWHM_SWIR, ANGLE, albedo, satellite)
Gas.Band_wav1 = FWHM_SWIR(1, 1);
Gas.Band_wav2 = FWHM_SWIR(end, 1);
Gas.bandindex = GetWavIndexes(FWHM_SWIR, Gas);
[k_1976_M_H2O, radiance_76M_H2O] = Calculate_k_H2O(FWHM_SWIR, Gas, ANGLE, 6, albedo, satellite);
mydisp('1976大气模型计算完成')
[k_Summer_M_H2O, ~] = Calculate_k_H2O(FWHM_SWIR, Gas, ANGLE, 6, albedo, satellite);
mydisp('中纬度夏季模型计算完成')
[k_Winter_M_H2O, ~] = Calculate_k_H2O(FWHM_SWIR, Gas, ANGLE, 6, albedo, satellite);
mydisp('中纬度冬季模型计算完成')
data_sheet = [FWHM_SWIR, k_Summer_M_H2O, k_Winter_M_H2O, k_1976_M_H2O];
save('radiance_76M_H2O.mat', 'radiance_76M_H2O');
end