library(dplyr)
library(ggplot2)
library(stringr)
filelist <- c("divw.txt",
              "mregger.txt",
              "wme.txt",
              "raps.txt",
              "mrcml.txt",
              "mrapss.txt",
              "mrgmm.txt",
              "mrgmmjack.txt")
Method <- c("DIVW", "MR-Egger", "WME", "APS", "cML-MA-BIC","MR-APSS","MR-GMM","MR-GMM-Jackknife")
res <- NULL
inflation <- NULL

for (i in 1:length(filelist)) {
  res_i <- read.table(filelist[i], sep = "\t", header = T, quote = "", row.names = NULL)[, -1]
  method <- Method[i]
  exp.x <- -log10(rev(ppoints(nrow(res_i))))
  res <- rbind(res, data.frame(`Negative log p` = sort(res_i$log_pval),
                               Theoretical = exp.x,
                               method = method,
                               lower = rev(-log10(qbeta(0.975, seq_len(length(exp.x)), rev(seq_len(length(exp.x)))))),
                               upper = rev(-log10(qbeta(0.025, seq_len(length(exp.x)), rev(seq_len(length(exp.x))))))))
  inflation <- rbind(inflation, data.frame(chisq = (res_i$est/res_i$se)^2,
                                           method = method))
}
res$method <- factor(res$method, levels = unique(res$method))
ggplot(aes(x = Theoretical, y = Negative.log.p, color = method, shape = method), data = res) + 
  geom_point(size = 2) + 
  ylim(0, 4) +
  geom_abline(slope = 1, intercept = 0, color = "red", linetype = "dashed") +
  geom_ribbon(aes(ymin = lower, ymax = upper), alpha = 0.05) +
  theme_minimal()+
  scale_shape_manual(values=seq(12,19))
inflation %>%
  group_by(method) %>%
  summarise(lambda_gc = median(chisq)/qchisq(0.5, 1))
