clear all
load randperm_Kimia.mat
for trial=1:10,
    trial
    for i=1:9,
        trainset{i}=uint8(imread(sprintf('trainimage%d_%d.png',i,FQ{trial}(i,1))));
        
    end;
    TPR_CM{trial}=zeros(9,9);
    TNR_CM{trial}=zeros(9,9);
    PPV_CM{trial}=zeros(9,9);
    NPV_CM{trial}=zeros(9,9);
    
    FPR_CM{trial}=zeros(9,9);
    FNR_CM{trial}=zeros(9,9);
    FDR_CM{trial}=zeros(9,9);
    FOR_CM{trial}=zeros(9,9);
    
     TS_CM{trial}=zeros(9,9);
     ACC_CM{trial}=zeros(9,9);
     BA_CM{trial}=zeros(9,9);
     F1_CM{trial}=zeros(9,9);
            
     MCC_CM{trial}=zeros(9,9);
     FM_CM{trial}=zeros(9,9);
     MK_CM{trial}=zeros(9,9);
     BM_CM{trial}=zeros(9,9);
     VOTE_CM{trial}=zeros(9,9);
    
    
    for i=1:9,
      
       
        for j=1:10,
            testimage=uint8(imread(sprintf('trainimage%d_%d.png',i,FQ{trial}(i,j+1))));
            for k=1:9
                st(k)=confmat.metrics(trainset{k},testimage,1);
            end
            TPRdetect(i,j)=find([st(:).TPR]==max([st(:).TPR]),1);
            vote(1)=TPRdetect(i,j);
            TPR_CM{trial}(i,vote(1))=TPR_CM{trial}(i,vote(1))+1;
            TNRdetect(i,j)=find([st(:).TNR]==max([st(:).TNR]),1);
            vote(2)=TNRdetect(i,j);
            TNR_CM{trial}(i,vote(2))=TNR_CM{trial}(i,vote(2))+1;
            PPVdetect(i,j)=find([st(:).PPV]==max([st(:).PPV]),1);
            vote(3)=PPVdetect(i,j);
            PPV_CM{trial}(i,vote(3))=PPV_CM{trial}(i,vote(3))+1;
            NPVdetect(i,j)=find([st(:).NPV]==max([st(:).NPV]),1);
            vote(4)=NPVdetect(i,j);
            NPV_CM{trial}(i,vote(4))=NPV_CM{trial}(i,vote(4))+1;
            
            FPRdetect(i,j)=find([st(:).FPR]==min([st(:).FPR]),1);
            vote(5)=FPRdetect(i,j);
            FPR_CM{trial}(i,vote(5))=FPR_CM{trial}(i,vote(5))+1;
            FNRdetect(i,j)=find([st(:).FNR]==min([st(:).FNR]),1);
            vote(6)=FNRdetect(i,j);
            FNR_CM{trial}(i,vote(6))=FNR_CM{trial}(i,vote(6))+1;
            FDRdetect(i,j)=find([st(:).FDR]==min([st(:).FDR]),1);
            vote(7)=FDRdetect(i,j);
            FDR_CM{trial}(i,vote(7))=FDR_CM{trial}(i,vote(7))+1;
            FORdetect(i,j)=find([st(:).FOR]==min([st(:).FOR]),1);
            vote(8)=FORdetect(i,j);
            FOR_CM{trial}(i,vote(8))=FOR_CM{trial}(i,vote(8))+1;
            
            TSdetect(i,j)=find([st(:).TS]==max([st(:).TS]),1);
            vote(9)=TSdetect(i,j);
            TS_CM{trial}(i,vote(9))=TS_CM{trial}(i,vote(9))+1;
            ACCdetect(i,j)=find([st(:).ACC]==max([st(:).ACC]),1);
            vote(10)=ACCdetect(i,j);
            ACC_CM{trial}(i,vote(10))=ACC_CM{trial}(i,vote(10))+1;
            BAdetect(i,j)=find([st(:).BA]==max([st(:).BA]),1);
            vote(11)=BAdetect(i,j);
            BA_CM{trial}(i,vote(11))=BA_CM{trial}(i,vote(11))+1;
            F1detect(i,j)=find([st(:).F1]==max([st(:).F1]),1);
            vote(12)=F1detect(i,j);
            F1_CM{trial}(i,vote(12))=F1_CM{trial}(i,vote(12))+1;
            
            MCCdetect(i,j)=find([st(:).MCC]==max([st(:).MCC]),1);
            vote(13)=MCCdetect(i,j);
            MCC_CM{trial}(i,vote(13))=MCC_CM{trial}(i,vote(13))+1;
            FMdetect(i,j)=find([st(:).FM]==max([st(:).FM]),1);
            vote(14)=FMdetect(i,j);
            FM_CM{trial}(i,vote(14))=FM_CM{trial}(i,vote(14))+1;
            MKdetect(i,j)=find([st(:).MK]==max([st(:).MK]),1);
            vote(15)=MKdetect(i,j);
            MK_CM{trial}(i,vote(15))=MK_CM{trial}(i,vote(15))+1;
            BMdetect(i,j)=find([st(:).BM]==max([st(:).BM]),1);
            vote(16)=BMdetect(i,j);
            BM_CM{trial}(i,vote(16))=BM_CM{trial}(i,vote(16))+1;
            VOTEdetect(i,j)=mode(vote);
            VOTE_CM{trial}(i,mode(vote))=VOTE_CM{trial}(i,mode(vote))+1;
        end
         TPR_accuracy(trial,i)=TPR_CM{trial}(i,i)*100/10;
         TNR_accuracy(trial,i)=TNR_CM{trial}(i,i)*100/10;
         PPV_accuracy(trial,i)=PPV_CM{trial}(i,i)*100/10;
         NPV_accuracy(trial,i)=NPV_CM{trial}(i,i)*100/10;
    
         FPR_accuracy(trial,i)=FPR_CM{trial}(i,i)*100/10;
         FNR_accuracy(trial,i)=FNR_CM{trial}(i,i)*100/10;
         FDR_accuracy(trial,i)=FDR_CM{trial}(i,i)*100/10;
         FOR_accuracy(trial,i)=FOR_CM{trial}(i,i)*100/10;
    
         TS_accuracy(trial,i)=TS_CM{trial}(i,i)*100/10;
         ACC_accuracy(trial,i)=ACC_CM{trial}(i,i)*100/10;
         BA_accuracy(trial,i)=BA_CM{trial}(i,i)*100/10;
         F1_accuracy(trial,i)=F1_CM{trial}(i,i)*100/10;
            
         MCC_accuracy(trial,i)=MCC_CM{trial}(i,i)*100/10;
         FM_accuracy(trial,i)=FM_CM{trial}(i,i)*100/10;
         BM_accuracy(trial,i)=BM_CM{trial}(i,i)*100/10;
         MK_accuracy(trial,i)=MK_CM{trial}(i,i)*100/10;
     
         VOTE_accuracy(trial,i)=VOTE_CM{trial}(i,i)*100/10;
    end
end

TABLO(1,:)=round(mean(TPR_accuracy),1)
TABLO(2,:)=round(mean(TNR_accuracy),1)
TABLO(3,:)=round(mean(PPV_accuracy),1)
TABLO(4,:)=round(mean(NPV_accuracy),1)

TABLO(5,:)=round(mean(FPR_accuracy),1)
TABLO(6,:)=round(mean(FNR_accuracy),1)
TABLO(7,:)=round(mean(FDR_accuracy),1)
TABLO(8,:)=round(mean(FOR_accuracy),1)

TABLO(9,:)=round(mean(TS_accuracy),1)
TABLO(10,:)=round(mean(ACC_accuracy),1)
TABLO(11,:)=round(mean(BA_accuracy),1)
TABLO(12,:)=round(mean(F1_accuracy),1)

TABLO(13,:)=round(mean(MCC_accuracy),1)
TABLO(14,:)=round(mean(FM_accuracy),1)
TABLO(15,:)=round(mean(BM_accuracy),1)
TABLO(16,:)=round(mean(MK_accuracy),1)

TABLO(17,:)=round(mean(VOTE_accuracy),1)
TABLO(:,10)=round(mean(TABLO(:,1:9),2),1)
T=array2table(TABLO,...
    'RowNames',{'TPR Accuracy','TNR Accuracy','PPV Accuracy',...
    'NPV Accuracy','FPR Accuracy','FNR Accuracy','FDR Accuracy',...
    'FOR Accuracy','TS Accuracy','ACC Accuracy','BA Accuracy',...
    'F1 Accuracy','MCC Accuracy','FM Accuracy','BM Accuracy',...
    'MK Accuracy','Vote Accuracy'},...
    'VariableNames',{'Class1','Class2','Class3','Class4','Class5',...
    'Class6','Class7','Class8','Class9','Overall'});
writetable(T,'Kimia_10test_1train_Accuracies.xlsx','WriteRowNames',1);

            
            
            
            
            
            
            
            
                
                
            
        