%Date:2020-09-14
%Written-by:Mehmet Fidan(mail-to:mfidan@eskisehir.edu.tr)
%Reference:https://en.wikipedia.org/wiki/Sensitivity_and_specificity
classdef confmat %FOR BINARY CLASSIFICATION
    properties
        %COUNTERS
        P;
        N;
        Ppred;
        Npred;
        PseudoP;
        PseudoN;
        TP;
        FP;
        TN;
        FN;
        
        %METRICS
        TPR; %max "sensitivity(True possitive ratio)"
        TNR; %max "specificity(True negative ratio)"
        PPV; %max "positive predictive value"
        NPV; %max "negative predictive value"
        FNR; %min "False Negative Rate (Miss Rate)"
        FPR; %min "False Positive Rate (Fall Out)"
        FDR; %min "False Discovery Rate"
        FOR; %min "False Omission Rate"
        PT;  %"Prevelance Treshold"
        TS;  %max "Critical Success Index (Threat Score)"
        ACC; %max "Accuracy"
        BA;  %max "Balanced Accuracy"
        F1;  %max "F1 Score"
        MCC; %max "Matthews Correlation Coefficient"
        FM;  %max "Fowlkes-Mallows Index"
        BM;  %max "Bookmaker Informedness"
        MK;  %max "Markedness (deltaP)"
    end
        
    methods (Static)
        function obj=counters(preddata,exactdata,posval)
            obj.P=length(exactdata(exactdata==posval));
            obj.N=length(exactdata(exactdata~=posval));
            obj.Ppred=length(preddata(preddata==posval));
            obj.Npred=length(preddata(preddata~=posval));
            obj.PseudoP=exactdata(preddata==posval);
            obj.PseudoN=exactdata(preddata~=posval);
            obj.TP=length(obj.PseudoP(obj.PseudoP==posval));
            obj.TN=length(obj.PseudoN(obj.PseudoN~=posval));
            obj.FP=obj.Ppred-obj.TP;
            obj.FN=obj.Npred-obj.TN;
        end
        function obj=metrics(preddata,exactdata,posval)
            obj=confmat.counters(preddata,exactdata,posval);
            
            if obj.P==0,
                obj.TPR=1;%These assumptions are done to avoid division-by-zero error!
                obj.FNR=1;
            else
                obj.TPR=obj.TP/obj.P;
                obj.FNR=obj.FN/obj.P;
            end
            
            if obj.N==0,
                obj.TNR=1;%These assumptions are done to avoid division-by-zero error!
                obj.FPR=1;
            else
                obj.TNR=obj.TN/obj.N;
                obj.FPR=obj.FP/obj.N;
            end
            
            if obj.Ppred==0
                obj.PPV=1;%These assumptions are done to avoid division-by-zero error!
                obj.FDR=1;
            else
                obj.PPV=obj.TP/obj.Ppred;
                obj.FDR=obj.FP/obj.Ppred;
            end
            
            if obj.Npred==0
                obj.NPV=1;%These assumptions are done to avoid division-by-zero error!
                obj.FOR=1;
            else
                obj.NPV=obj.TN/obj.Npred;
                obj.FOR=obj.FN/obj.Npred;
            end
            
            obj.PT=(sqrt(obj.TPR*(1-obj.TNR))+obj.TNR-1)/(obj.TPR+obj.TNR-1);
            obj.TS=obj.TP/(obj.TP+obj.FN+obj.FP);
            obj.ACC=(obj.TP+obj.TN)/(obj.P+obj.N);
            obj.BA=(obj.TPR+obj.TNR)/2;
            obj.F1=2*obj.PPV*obj.TPR/(obj.PPV+obj.TPR);
            obj.MCC=(obj.TP*obj.TN-obj.FP*obj.FN)/...
                sqrt((obj.TP+obj.FP)*(obj.TP+obj.FN)*(obj.TN+obj.FP)*(obj.TN+obj.FN));
            obj.FM=sqrt(obj.PPV*obj.TPR);
            obj.BM=obj.TPR+obj.TNR-1;
            obj.MK=obj.PPV+obj.NPV-1;
        end
    end
end
            
                
            
