import requests 
import os

VAE_MODEL_URL = 'http://openproblems-bio.s3.amazonaws.com/public/ZINC/2024-12-20-vae-rnn-pubchem-epoch=81.ckpt'


def download_file(url, dest_folder):
    if not os.path.exists(dest_folder):
        os.makedirs(dest_folder)
    filename = os.path.join(dest_folder, url.split('/')[-1])
    response = requests.get(url, stream=True)
    with open(filename, 'wb') as file:
        for chunk in response.iter_content(chunk_size=8192):
            if chunk:
                file.write(chunk)
    print(f"Downloaded {filename}")

download_file(VAE_MODEL_URL, 'molrl/model_checkpoints')