clear
clear matrix
clear mata
set maxvar 8000
cd ""	// set directory

use "Integrated_values_surveys_1981-2022.dta"
* These data are to be constructed by downloading and appending the WVS and EVS files - see guidelines on the WVS website.

 
 ****** Important child qualities ***********
 
 gen manners = A027
 replace manners = . if A027 <0
 gen independence = A029
 replace independence = . if A029 <0
gen work = A030
 replace work = . if A030 <0
 gen responsibility = A032
 replace responsibility = . if A032 <0
 gen imagination = A034
 replace imagination = . if A034 <0
  gen tolerance = A035
 replace tolerance = . if A035 <0
gen thrift  = A038
 replace thrift = . if A038 <0
gen determination  = A039
 replace determination = . if A039 <0
gen faith  = A040
 replace  faith = . if A040 <0
gen unselfishness  = A041
 replace unselfishness = . if A041 <0
gen obedience  = A042
 replace obedience = . if A042 <0
gen loyalty  = A043
 replace loyalty = . if A043 <0 
 
/*These were not generated in the original dofile*/
gen birthyear=X002
gen cntr_code=S003

/*Cleaning data*/
local vur faith

foreach var in independence faith work determination obedience thrift imagination unselfishness tolerance responsibility{
replace `var'=. if `var'==.a
}

gen sum= independence +faith+ work+ determination +obedience+ thrift+ imagination +unselfishness +tolerance +responsibility


gen birth_decade = 1 if birthyear<1930 
replace birth_decade = 2 if birthyear>=1930
replace birth_decade = 3 if birthyear>=1940
replace birth_decade = 4 if birthyear>=1950
replace birth_decade = 5 if birthyear>=1960
replace birth_decade = 6 if birthyear>=1970
replace birth_decade = 7 if birthyear>=1980
replace birth_decade = 8 if birthyear>=1990 
replace birth_decade = . if birthyear==. | birthyear<1920 /*Latter:very few*/

gen birth_hdecade = 1 if birthyear<1930 
replace birth_hdecade = 2 if birthyear>=1930
replace birth_hdecade = 3 if birthyear>=1935
replace birth_hdecade = 4 if birthyear>=1940
replace birth_hdecade = 5 if birthyear>=1945
replace birth_hdecade = 6 if birthyear>=1950
replace birth_hdecade = 7 if birthyear>=1955
replace birth_hdecade = 8 if birthyear>=1960 
replace birth_hdecade = 9 if birthyear>=1965 
replace birth_hdecade = 10 if birthyear>=1970 
replace birth_hdecade = 11 if birthyear>=1975 
replace birth_hdecade = 12 if birthyear>=1980 
replace birth_hdecade = 13 if birthyear>=1985 
replace birth_hdecade = 14 if birthyear>=1990 
replace birth_hdecade = 15 if birthyear>=1995

replace birth_hdecade = . if birthyear==. | birthyear<1925 | birthyear>=2000

replace cntr_code=372 if cntr_code==909

gen region=X048WVS
replace region=X048_EVS if missing(X048WVS)

by region cntr_code, sort: generate nvals = _n == 1
bys cntr_code: egen num_regions=sum(nvals)

*** Personal values ***

gen mis=1 if missing(A001) | missing(A002) | missing(A003) | missing(A004) | missing(A005) |  missing(A006)
gen Family = 4-A001
gen Friends = 4-A002
gen Leisure = 4-A003
gen Politics = 4-A004
gen Work = 4-A005
gen Religion = 4-A006

foreach var in Family Friends Leisure Politics Work Religion{
	replace `var'=. if mis==1
}
drop mis

*** Child values ***

gen mis=1 if missing(independence) | missing(faith) | missing(work) | missing(determination) | missing(obedience) |  missing(thrift) | missing(imagination) | missing(unselfishness) |  missing(tolerance) |  missing(responsibility)

foreach var in faith independence work obedience determination thrift responsibility imagination tolerance unselfishness{
	replace `var'=. if mis==1
}

drop mis

*********************
/*Membership values*/
*********************

gen mis=1 if missing(A065) | missing(A066) | missing(A067) | missing(A068) | missing(A072) |  missing(A074)

gen Religious =A065
gen Cultural=A066
gen Labour=A067
gen Political=A068
gen Professional=A072
gen Sport=A074

foreach var in Religious Cultural Labour Political Professional Sport{
	replace `var'=. if mis==1
}

drop mis

/*Active Membership values*/

gen mis=1 if missing(A098) | missing(A099) | missing(A100) | missing(A101) | missing(A102) | missing(A103) | missing(A104) | missing(A105)

foreach var in A098 A099 A100 A101 A102 A103 A104 A105{
	replace `var'=. if mis==1
}

drop mis

save global_val2.dta, replace

/*Put additional country info on*/

merge m:1 cntr_code using cntr_id
drop if _merge==2
drop _merge

save global_val2.dta, replace

/* Correct region variable */

clear 
use "global_val2.dta"

gen wave= S002
replace wave = S002EVS if wave==.

bys cntr_code wave: gen num=_N
bys region wave: gen numr=_N

gen diff=0
replace diff=1 if num==numr

replace region=. if diff==1


keep Family Friends Leisure Politics Work Religion cntr_code birth_hdecade S002 S002EVS F025 REGION_UN region INCOME_GRP X025R F025 S001 X001 X003 faith independence work obedience determination thrift responsibility imagination tolerance unselfishness Religious Cultural Labour Political Professional Sport A098 A099 A100 A101 A102 A103 A104 A105 cntr_code region REGION_UN cntr_code X025 X047_WVS X047_EVS S002 S002EVS S020


save global_val2.dta, replace

*********************
/*Time-varying data*/
*********************

clear 
use "global_val2.dta"

************** Personal values ****************

keep Family Friends Leisure Politics Work Religion cntr_code birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur Family
keep if `vur'!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

************** Personal values, denominations ****************

clear 
use "global_val2.dta"

keep Family Friends Leisure Politics Work Religion cntr_code birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur Family
keep if `vur'!=. 
keep if F025!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'_denom", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

************** Child qualities ****************

clear 
use "global_val2.dta"

keep faith independence work obedience determination thrift responsibility imagination tolerance unselfishness cntr_code birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur faith
keep if `vur'!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

************** Child qualities, denominations ****************
clear 
use "global_val2.dta"

keep faith independence work obedience determination thrift responsibility imagination tolerance unselfishness cntr_code birth_hdecade F025 S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur faith
keep if `vur'!=.
keep if F025!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'_denom", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

************** Membership ****************

clear 
use "global_val2.dta"

keep Religious Cultural Labour Political Professional Sport cntr_code birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur Religious
keep if `vur'!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

************** Membership, denomination ****************

clear 
use "global_val2.dta"

keep Religious Cultural Labour Political Professional Sport cntr_code birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur Religious
keep if `vur'!=.
keep if F025!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'_denom", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/



************** Active Membership ****************

clear 
use "global_val2.dta"
keep A098 A099 A100 A101 A102 A103 A104 A105 cntr_code S002 S002EVS birth_hdecade F025 REGION_UN S001 X001 X003

keep if birth_hdecade !=.
keep if birth_hdecade!=15 & birth_hdecade!=1

local vur A098
keep if `vur'!=.

/*keep if country is represented in every half-decade*/
bysort cntr_code birth_hdecade: gen years = _n
bysort cntr_code birth_hdecade: gen totyears = _N if years==1
bysort cntr_code: egen totnryears = count(totyears) 
 keep if totnryears ==13

/*keep if at least 10 persons in each country is represented in every half-decade*/
    bysort cntr_code birth_hdecade: gen above10 = 1 if _N>=10 
bysort cntr_code: egen hdecades = total(above10) if years==1 
sort cntr_code hdecades
bysort cntr_code: replace hdecades = hdecades[1]
  tab cntr_code birth_hdecade 
 keep if hdecades ==13
 
save "hdecade10_`vur'", replace /*this data is restricted, so that each country is represented by at least 10 individuals in each 5-year interval (half-decade)*/

