######################################################################################################
# Code for manuscript: Chia et al. Enclosed bird nests driven by predation and thermoregulation
# 2024 November
# This script samples 1k trees from 10k Hackett backbone trees

## INPUTS
# 10k Heckett backcone trees from BirdTree.org (as 10 separate file)

## OUTPUTS
# 1,000 trees as a list object ("data/tree1k.rds")
######################################################################################################


# Preparation: 
# 1. Download all 10k Hackett backbone trees from BirdTree.org (https://data.vertlife.org/?basetree=birdtree&start_folder=Stage2/)
# 2. Decompress all files and put all 10 .tre files into the same folder. Set that as the working directory.

library(phytools)

# sample 100 trees from every 1k tree file (Warning: long runtime, ~30min)
tree1k <- list()
for (i in 1:10) {
  if (i==1) {
    trees <- read.tree("AllBirdsHackett1.tre")
  } else {
    trees <- read.tree(paste0("BirdzillaHackett",i,".tre"))
  }
  tree1k <- c(tree1k, trees[sample(1000, 100)])
}

saveRDS(tree1k, "data/tree1k.rds")
