(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     78040,       1584]
NotebookOptionsPosition[     76911,       1554]
NotebookOutlinePosition[     77372,       1572]
CellTagsIndexPosition[     77329,       1569]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["ED", "Subsection",
 CellChangeTimes->{{3.929438288465522*^9, 
  3.9294382934274273`*^9}},ExpressionUUID->"bae3c5c2-960d-47fd-8c60-\
3c328491dfc7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Input", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"set", " ", "Length", " ", "of", " ", "chain"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"L", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"set", " ", "boundary", " ", 
      RowBox[{"condition", ":", " ", 
       RowBox[{"0", " ", "for", " ", "periodic"}]}]}], ";", " ", 
     RowBox[{"1", " ", "for", " ", "open", " ", "boundary"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bdry", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"end", " ", "of", " ", "Input"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"construct", " ", "Hamiltonian", " ", "in", " ", 
      SubsuperscriptBox["S", "tot", "z"]}], "=", 
     RowBox[{"0", " ", 
      RowBox[{"(", 
       RowBox[{"even", " ", "chain"}], ")"}], " ", "or", " ", 
      RowBox[{"1", "/", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"odd", " ", "chain"}], ")"}], " ", "subspace"}]}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"state", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"2", "^", "L"}], "-", "1"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "@", 
          RowBox[{"IntegerDigits", "[", 
           RowBox[{"#", ",", "2", ",", "L"}], "]"}]}], "==", 
         RowBox[{"Ceiling", "[", 
          RowBox[{"L", "/", "2"}], "]"}]}], "&"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dim", "=", 
     RowBox[{"Length", "@", "state"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0.", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "dim"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "dim"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"sz", "=", 
       RowBox[{"IntegerDigits", "[", 
        RowBox[{
         RowBox[{"state", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "2", ",", "L"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"fsz", "=", "sz"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"sz", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "+", 
             RowBox[{"sz", "[", 
              RowBox[{"[", 
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "L", ",", "1"}], "]"}], "]"}], 
              "]"}]}], "==", "1"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"fsz", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "=", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"sz", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], "]"}]}], ";", 
            RowBox[{
             RowBox[{"fsz", "[", 
              RowBox[{"[", 
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "L", ",", "1"}], "]"}], "]"}], 
              "]"}], "=", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"sz", "[", 
                RowBox[{"[", 
                 RowBox[{"Mod", "[", 
                  RowBox[{
                   RowBox[{"i", "+", "1"}], ",", "L", ",", "1"}], "]"}], 
                 "]"}], "]"}], "-", "1"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pos", "=", 
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"state", ",", 
                RowBox[{"FromDigits", "[", 
                 RowBox[{"fsz", ",", "2"}], "]"}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"mat", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "pos"}], "]"}], "]"}], "=", "0.5"}], ";"}]}],
           "\[IndentingNewLine]", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"L", "-", "bdry"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ele", "=", "0"}], ";", 
      RowBox[{"sz", "=", 
       RowBox[{"sz", "-", "0.5"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"ele", "+=", 
         RowBox[{
          RowBox[{"sz", "[", 
           RowBox[{"[", "i", "]"}], "]"}], 
          RowBox[{"sz", "[", 
           RowBox[{"[", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "L", ",", "1"}], "]"}], "]"}], 
           "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"L", "-", "bdry"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"mat", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "ele"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "dim"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "diagonalization", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"val", ",", "u"}], "}"}], "=", 
     RowBox[{"Eigensystem", "[", "mat", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gs", "=", 
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{"val", ",", 
        RowBox[{"Min", "[", "val", "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Dimension of H = \>\"", " ", ",", "dim", ",", " ", "\"\<; \>\"", ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"bdry", "==", "0"}], ",", 
       "\"\<Periodic Boundary Condition\>\"", ",", " ", 
       "\"\<Open Boundary Condition\>\""}], "]"}], ",", "\"\<\n\>\"", ",", 
     "\"\<Spin Gap in this sector = \>\"", ",", " ", 
     RowBox[{
      RowBox[{"RankedMin", "[", 
       RowBox[{"val", ",", "2"}], "]"}], "-", 
      RowBox[{"Min", "[", "val", "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9294383598034787`*^9, 3.9294383644733677`*^9}, {
   3.929438520659148*^9, 3.929438527901672*^9}, {3.9294386892153854`*^9, 
   3.9294386898839035`*^9}, {3.9294388756965914`*^9, 3.929438923866*^9}, {
   3.929438967567423*^9, 3.9294390267362146`*^9}, {3.92943906844128*^9, 
   3.9294390859544816`*^9}, {3.9294391347610235`*^9, 3.929439179596202*^9}, {
   3.929440659564146*^9, 3.929440671010519*^9}, {3.9294409371578074`*^9, 
   3.929440958358466*^9}, {3.929441000296822*^9, 3.9294410029938793`*^9}, {
   3.9294410385538425`*^9, 3.929441053937518*^9}, {3.929441093652157*^9, 
   3.929441103213708*^9}, {3.929441214134584*^9, 3.9294412706707883`*^9}, {
   3.9294413635096292`*^9, 3.9294413766956053`*^9}, {3.9294414111903*^9, 
   3.9294414115173206`*^9}, {3.929441653882045*^9, 3.929441742733528*^9}, {
   3.929441795628697*^9, 3.9294417958249683`*^9}, {3.9294418444146996`*^9, 
   3.929441844507625*^9}, {3.929441876070614*^9, 3.929441889985648*^9}, {
   3.92944198317282*^9, 3.929442025491103*^9}, {3.9294422825514975`*^9, 
   3.9294422887668905`*^9}, {3.929445744785984*^9, 3.9294457448756065`*^9}, {
   3.929477138769758*^9, 3.929477139045638*^9}, {3.929489470487051*^9, 
   3.929489514954708*^9}, {3.9294931002865944`*^9, 3.929493102152038*^9}, {
   3.9294945315573335`*^9, 3.9294945343461905`*^9}, {3.9294953744059734`*^9, 
   3.9294953745622416`*^9}, {3.9294954948325105`*^9, 3.929495494916405*^9}, {
   3.929495555687189*^9, 3.929495556585775*^9}, {3.9294957208554916`*^9, 
   3.929495720989015*^9}, {3.9295016895565386`*^9, 3.9295019437931423`*^9}, {
   3.929502084570679*^9, 3.929502119867518*^9}, {3.9295022667141976`*^9, 
   3.9295023012929573`*^9}, {3.929502335424965*^9, 3.929502462994012*^9}, {
   3.9295025025869045`*^9, 3.9295025113316402`*^9}, {3.9295025711421595`*^9, 
   3.9295026577935*^9}, {3.9295027180074744`*^9, 3.929502724795977*^9}, {
   3.9295027588398566`*^9, 3.9295028425546675`*^9}, 3.929502873191601*^9, {
   3.9295029276836815`*^9, 3.9295029411436634`*^9}, {3.929503448526676*^9, 
   3.929503452283879*^9}},
 CellLabel->
  "In[3984]:=",ExpressionUUID->"aa85bfc9-3e3a-4549-b1e2-4bd00fc23a8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dimension of H = \"\>", "\[InvisibleSpace]", "252", 
   "\[InvisibleSpace]", "\<\"; \"\>", 
   "\[InvisibleSpace]", "\<\"Open Boundary Condition\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"Spin Gap in this sector = \"\>", 
   "\[InvisibleSpace]", "0.3273616177813241`"}],
  SequenceForm[
  "Dimension of H = ", 252, "; ", "Open Boundary Condition", "\n", 
   "Spin Gap in this sector = ", 0.3273616177813241],
  Editable->False]], "Print",
 CellChangeTimes->{{3.92950175806507*^9, 3.9295017926380043`*^9}, 
   3.929501939714859*^9, {3.929502110010495*^9, 3.9295021217781878`*^9}, 
   3.9295023893979683`*^9, {3.9295024535921063`*^9, 3.929502464372423*^9}, 
   3.9295025115410843`*^9, 3.9295025753129396`*^9, 3.929502606528137*^9, {
   3.929502642180637*^9, 3.9295026586196394`*^9}, 3.9295027256023364`*^9, 
   3.9295027709771996`*^9, {3.929502812722215*^9, 3.9295028432222915`*^9}, 
   3.9295028751227493`*^9, 3.9295034583631687`*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[3984]:=",ExpressionUUID->"5c9746bc-658d-4bfa-\
a216-807c5b84817b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"calculate", " ", "<", 
     RowBox[{
      SubsuperscriptBox["S", "i", "z"], 
      RowBox[{"(", "t", ")"}], 
      SubsuperscriptBox["S", "j", "z"]}], ">"}], ",", " ", 
    RowBox[{
     RowBox[{
     "j", " ", "is", " ", "the", " ", "reference", " ", "site", " ", "at", 
      " ", "the", " ", "center", " ", "of", " ", "chain"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"I", " ", "set", " ", "\[CapitalDelta]\[Tau]"}], "=", "0.1"}]}],
     ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"total", " ", "Time"}], "=", "50"}], ";"}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"evol", "=", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{"0", "&"}], ",", "L"}], "]"}]}], ";", 
    RowBox[{"szvec", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0.", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "dim"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"sz", "=", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{
          RowBox[{"state", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "2", ",", "L"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"szvec", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"sz", "[", 
          RowBox[{"[", 
           RowBox[{"Ceiling", "[", 
            RowBox[{"L", "/", "2"}], "]"}], "]"}], "]"}], "-", "0.5"}]}], 
       ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "dim"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myvecr", "=", 
     RowBox[{"u", ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "gs", "]"}], "]"}], "*", "szvec"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"szvec", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0.", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "dim"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"sz", "=", 
          RowBox[{"IntegerDigits", "[", 
           RowBox[{
            RowBox[{"state", "[", 
             RowBox[{"[", "j", "]"}], "]"}], ",", "2", ",", "L"}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"szvec", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"sz", "[", 
            RowBox[{"[", "site", "]"}], "]"}], "-", "0.5"}]}], ";"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "dim"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"myvecl", "=", 
       RowBox[{"u", ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "gs", "]"}], "]"}], "*", "szvec"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"evol", "[", 
        RowBox[{"[", "site", "]"}], "]"}], "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"site", ",", "\[Tau]", ",", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"myvecl", "*", 
              RowBox[{"Exp", "[", 
               RowBox[{"\[ImaginaryI]", " ", "val", " ", "\[Tau]"}], "]"}], 
              "*", "myvecr"}], "]"}], "*", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", 
              RowBox[{"val", "[", 
               RowBox[{"[", "gs", "]"}], "]"}], " ", "\[Tau]"}], "]"}]}]}], 
          RowBox[{"(*", 
           RowBox[{"-", 
            RowBox[{"Total", "[", 
             RowBox[{"myvecl", "*", "myvecr"}], "]"}]}], "*)"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Tau]", ",", "0", ",", "500", ",", "0.1"}], "}"}]}], 
        "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"site", ",", "L"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<reference site = \>\"", ",", " ", 
     RowBox[{"Ceiling", "[", 
      RowBox[{"L", "/", "2"}], "]"}], ",", " ", 
     "\"\<, Total evolution Time = 50, Time Interval = 0.1\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9294784252187157`*^9, 3.9294784258842645`*^9}, {
   3.9294788481495557`*^9, 3.9294788630148597`*^9}, {3.9294789741040916`*^9, 
   3.929479096243887*^9}, {3.929479489631951*^9, 3.9294795238063145`*^9}, {
   3.9294796721754904`*^9, 3.92947968781923*^9}, 3.9294799011538825`*^9, {
   3.929480135946746*^9, 3.929480146720634*^9}, {3.929480286705474*^9, 
   3.929480289643545*^9}, {3.929480377361749*^9, 3.929480378584724*^9}, {
   3.9294808682527504`*^9, 3.9294808690894613`*^9}, {3.9294928937240067`*^9, 
   3.9294930123540583`*^9}, {3.9294935365737844`*^9, 3.929493536694661*^9}, {
   3.929494240034069*^9, 3.929494241510917*^9}, {3.9294946979523134`*^9, 
   3.9294946986561317`*^9}, {3.9294952458171234`*^9, 
   3.9294952462596436`*^9}, {3.929495332024225*^9, 3.929495332244035*^9}, {
   3.9294953871554337`*^9, 3.929495392966547*^9}, {3.9295021408444176`*^9, 
   3.9295022614572515`*^9}, {3.9295029540161877`*^9, 3.9295030827898626`*^9}, 
   3.9295031959874535`*^9},
 CellLabel->
  "In[3993]:=",ExpressionUUID->"6d9c8584-a091-4b1d-9604-ac766adc329d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"reference site = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\", Total evolution Time = 50, Time Interval = 0.1\
\"\>"}],
  SequenceForm[
  "reference site = ", 5, ", Total evolution Time = 50, Time Interval = 0.1"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.92950294996624*^9, 3.929502959759696*^9}, 
   3.929503085955639*^9, 3.929503345235228*^9, 3.9295034618936086`*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[3993]:=",ExpressionUUID->"4f00fba8-04d1-4650-\
88a9-2a045d9646fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"calculate", " ", "S", 
     RowBox[{"(", 
      RowBox[{"\[Omega]", ",", "q"}], ")"}], " ", "from"}], " ", "<", 
    RowBox[{
     SubsuperscriptBox["S", "i", "z"], 
     RowBox[{"(", "t", ")"}], 
     SubsuperscriptBox["S", "j", "z"]}], ">"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Integrate", " ", "\[Tau]"}], ",", " ", 
    RowBox[{
     RowBox[{"I", " ", "set", " ", "damping"}], " ", "=", " ", "0.1"}]}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"rdat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"site", ",", "\[Omega]", ",", 
         RowBox[{"Re", "[", 
          RowBox[{"2", 
           RowBox[{"\[Pi]", " ", "/", 
            RowBox[{"Length", "[", 
             RowBox[{"evol", "[", 
              RowBox[{"[", "site", "]"}], "]"}], "]"}]}], "2", 
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "-", "0.1"}], 
               ")"}], "*", 
              RowBox[{"evol", "[", 
               RowBox[{"[", 
                RowBox[{"site", ",", ";;", ",", "2"}], "]"}], "]"}]}], "]"}], 
            ".", 
            RowBox[{"Re", "@", 
             RowBox[{"evol", "[", 
              RowBox[{"[", 
               RowBox[{"site", ",", ";;", ",", "3"}], "]"}], "]"}]}]}]}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"site", ",", "1", ",", "L"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Omega]", ",", "0.0", ",", "3.5", ",", "0.05"}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Fourier", " ", "transformation", " ", "to", " ", "k", " ", "space"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wqdat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"q", ",", 
         RowBox[{"rdat", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "j", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"Abs", "[", " ", 
          RowBox[{"2", 
           RowBox[{"\[Pi]", " ", "/", 
            RowBox[{"Length", "@", 
             RowBox[{"rdat", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "j"}], "]"}], "]"}]}]}], " ", 
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rdat", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "j", ",", "1"}], "]"}], "]"}], "-", 
                RowBox[{"Ceiling", "[", 
                 RowBox[{"L", "/", "2"}], "]"}]}], ")"}]}], "]"}], ".", 
            RowBox[{"rdat", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "j", ",", "3"}], "]"}], "]"}]}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "@", 
          RowBox[{"rdat", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"q", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}], ",", 
         RowBox[{"2", 
          RowBox[{"\[Pi]", "/", "L"}]}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListDensityPlot", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"wqdat", ",", "1"}], "]"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{"All", ",", "All", ",", "All"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", "0.8"}], ",", 
     RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
          RowBox[{"-", "\[Pi]"}], ",", "0", ",", 
          RowBox[{"\[Pi]", "/", "2"}], ",", "\[Pi]", ",", 
          RowBox[{"3", 
           RowBox[{"\[Pi]", "/", "2"}]}], ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"InterpolationOrder", "->", "0"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.929481425367586*^9, 3.929481496287902*^9}, {
   3.9294817748653717`*^9, 3.92948183576938*^9}, {3.9294818938818045`*^9, 
   3.929481900963171*^9}, {3.929482078133813*^9, 3.9294820929291973`*^9}, {
   3.929482450844841*^9, 3.9294825794611235`*^9}, {3.9294826154044743`*^9, 
   3.929482699877872*^9}, {3.9294827608632374`*^9, 3.9294827609584045`*^9}, {
   3.9294829966332493`*^9, 3.929483002753916*^9}, {3.9294832150863333`*^9, 
   3.929483224518114*^9}, 3.9294845083322477`*^9, {3.9294845590077243`*^9, 
   3.929484565134301*^9}, {3.9294846229805574`*^9, 3.9294846693336134`*^9}, 
   3.9294867690935802`*^9, {3.9294891999383388`*^9, 3.9294892498663673`*^9}, {
   3.9294893176621428`*^9, 3.9294893602443686`*^9}, {3.9294930773214817`*^9, 
   3.9294930776139975`*^9}, {3.929493177785512*^9, 3.9294931782640686`*^9}, {
   3.929493212420883*^9, 3.929493225057407*^9}, {3.9294932686520042`*^9, 
   3.9294932695510426`*^9}, {3.9294938055586596`*^9, 
   3.9294938114993353`*^9}, {3.9294942966194897`*^9, 
   3.9294943016905456`*^9}, {3.929494365295188*^9, 3.9294943666165423`*^9}, {
   3.92949450479081*^9, 3.9294945087912164`*^9}, {3.929494948961141*^9, 
   3.9294949567237997`*^9}, {3.929495134899618*^9, 3.9294952175238485`*^9}, {
   3.929495312078412*^9, 3.929495314395355*^9}, {3.9294954224795237`*^9, 
   3.9294954263246927`*^9}, {3.9294955295245748`*^9, 
   3.9294955479896436`*^9}, {3.9294955968406677`*^9, 
   3.9294955972771373`*^9}, {3.929503106742663*^9, 3.929503183472438*^9}, {
   3.9295033072313595`*^9, 3.929503429716519*^9}},
 CellLabel->
  "In[3998]:=",ExpressionUUID->"70e79239-2684-419b-ae69-e7bf104dc1cf"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJyNnV9s3Xd5xh07ieO42sak4XaTEAgkhhBsJWFjmqoajYtdLUlFp61Am4w2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     "], {{{
        EdgeForm[], 
        GrayLevel[0.8], 
        GraphicsGroupBox[{
          PolygonBox[{{4481, 1, 4201, 4521}, {4520, 4200, 4480, 4524}}], 
          PolygonBox[CompressedData["
1:eJwl1geYz3UcB/C/jDIOR/bqKomoVJIKSbKT3eEIIWRnr5CRvY4uIdmzVJLR
TqVSmaFklEolo1QSen2ensfr8Xnf976/8V2/S+nQq0nPKxKJxAKysjw5keic
N5HoQieWyeO5Slt2cjBOHkP0y0wWRstjk/+/Rjau5Gl5BHVcpy71GC5P42rt
BSjIVHkYebUnk4eh8hT8S+QjP5OFZ8ipzkUSE+Qs8XweLjtXklnOxn3qGtxP
VnkSufXJg1skJsoP8LGLbecjasoPJv9/8UxcQS25Hveqq1KNuvJPLvKYF+1E
R36UZ/h5Id0LU4Tp8iq6aSshl2S2vJBWftaaVBbIA/jSw+1kF/3lFpx2vzOc
pbk8iD3a97KbgfIj/KH9HL/TUm7DrV64IrfQWm7GG9o3sZGm8RyU116Bm0mN
uY1xjXEjG5nkIeTyrEnkZrC8mpE0kOuTrl5EmrotbXhBXsyj6va040V5Lg+p
G9GQOfIsihqjYhRnppxBY+1NeJhn5XnxLurmNOU5eT4t1Y/Qguflh2Ntec/h
DKVRrJWYd+9Ui5qxZuK9eEo9ipHklKsxwZp4holUjTXFZPUUJlFdvi3mw6Lc
yz4qyvfzgfZtfEiNWD/xPOrGNOIe+a7YC+oC5KdyzBnPu8585nGLfHeMsfaG
PEQV+Wae1Z7Bc1SQS7LCJl3JKkrI5WItaE+jLWVjvmM+1O1px00x7jyhTw96
UkS+Pta5+gQ/cp18Ld+rj/MDKXJxeqv70Iti8jWsUa9lNaXkHDEfxnc4I2LP
ynew3zMc4CtulwvHz/WpxO0Ukn+NtWSfLWIhv8j/Mt3hNINpXJB/jrnXPp8F
nJAv8bH27XzCxVjDsRc8wyY2kxRnEFvVb7KFPHEW8Jk+O/iUy/reGb9rHpLJ
R6XYp37+jfsd4mtOyWe5Wp8CFOSMXDDm2DtV5DYKxBrgb/c7z1/kl3/zu/td
5wAHOSn/QWHXKUIhfpf/ppm6OU35S/6HyeopTOW8/GfsH3VjmnAu9pT7vGZf
bOB1Gsc6i3WurkF16sc+jXNHPZghNJRfj7F3+M9gJhvk12L/qVNpyavyHu7y
UahCZXbLr8Qza29OC9bLsxnkozKYgcyKM4GX1et5hXR5Jk+q+zOAGXEmxL3V
G3iVufIu7nC/StzJTnkfvdV96Mte+ctYRz5cF7nAFzGPcV/t63mJr2Mu4r7q
/vTjK/lbflKf4GcOyZ/HnLjOef5hh3yQNdrXso4D8hF+VZ/kFw7Ln/GOPu/y
Np/GGHOvd6rKPUyTp8aYqqtwN1PiWx37wwd5ES+yNDLl1RW4iYXyCpZEO4tZ
HudxfMvUnegc15CfZkIm5x/jGSMvNe8d43fpENeRl/j/cX260iWuGWsvPrCe
KxOX9Z0kr4px1X6Ib1kpr4v1bP6LUJS1cU8+0Gcb78e95YkxR+qLXIpnivmh
uD4lKMZL8R2IMXXPk/xGRnxbudH9ylKO+TEXMf7qoxxmdZwZnNbnDKeYF/3i
DHQmleY6ysSZEWvV/dKZxUZ5c8ydegefs0nu7HeP+J4e5Rid5Mfj7FQf5zu6
yI/Fma1eyXI6ynXi+2ufZSUzteVjrnm9c6A0N3BU7hn7zVCn0ooe8g88qr09
HTguDyGXcUsiN4PlbnFu+/uhBCXpKveMvyXUqbSih9w2nttzdaUbafHtiG+F
ugfdaRc5znx9UihFd7lDrA/tS1lGe7kvs7WnM4c+8pPxLVNnMJd+8T2J75Y6
jdb0irM59qvx3ckXbJGHkdc7JZOHofITXGM8UihFd/lDnrKnRjGabfFNiHWu
HssYPoq1Rx11XWrzvvwJW9Vv8hbb5be4Sp2dHNEWezfGWZ1EztjD8ns8oK7F
g7G35RFxD89al3oMl8dFf/W7vMdY+ftYg+awLGX4Ls7IOFO90152MzDOpTgD
1RnMpZ88Ot4trsM4RskDYvy072QX/eW+sZ7V6cyhT4wTDfRpSH1GxrlJG+1p
tKaXfEPMuX2RwrWxT+R88beob9g5/iRZ/g/p3Zzo
           "]], 
          PolygonBox[CompressedData["
1:eJwl2mW4FkUbAGC6u7u7uzulS0BAQLq7u7u7u1u6u0FAQEBaQECkQUpAvnuv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           "]]}]}, {}, {}, {}, {}}}, VertexColors -> CompressedData["
1:eJzt3XlUje3bN/DSQJlKJUqRBglRSUSOUponc7PmSGmiiJBSqWgQUcpYSkSI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      "]], {
    DisplayFunction -> Identity, AspectRatio -> 0.8, 
     AxesOrigin -> {Automatic, Automatic}, DisplayFunction :> Identity, Frame -> 
     True, FrameLabel -> {None, None}, 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[Rational[-1, 2] Pi, -1.5707963267948966`], 
          FormBox[
           RowBox[{"-", 
             FractionBox["\[Pi]", "2"]}], TraditionalForm]}, {
          NCache[-Pi, -3.141592653589793], 
          FormBox[
           RowBox[{"-", "\[Pi]"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {
          NCache[Rational[1, 2] Pi, 1.5707963267948966`], 
          FormBox[
           FractionBox["\[Pi]", "2"], TraditionalForm]}, {
          NCache[Pi, 3.141592653589793], 
          FormBox["\[Pi]", TraditionalForm]}, {
          NCache[Rational[3, 2] Pi, 4.71238898038469], 
          FormBox[
           FractionBox[
            RowBox[{"3", " ", "\[Pi]"}], "2"], TraditionalForm]}, {
          NCache[2 Pi, 6.283185307179586], 
          FormBox[
           RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{
          NCache[Rational[-1, 2] Pi, -1.5707963267948966`], 
          FormBox[
           RowBox[{"-", 
             FractionBox["\[Pi]", "2"]}], TraditionalForm]}, {
          NCache[-Pi, -3.141592653589793], 
          FormBox[
           RowBox[{"-", "\[Pi]"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {
          NCache[Rational[1, 2] Pi, 1.5707963267948966`], 
          FormBox[
           FractionBox["\[Pi]", "2"], TraditionalForm]}, {
          NCache[Pi, 3.141592653589793], 
          FormBox["\[Pi]", TraditionalForm]}, {
          NCache[Rational[3, 2] Pi, 4.71238898038469], 
          FormBox[
           FractionBox[
            RowBox[{"3", " ", "\[Pi]"}], "2"], TraditionalForm]}, {
          NCache[2 Pi, 6.283185307179586], 
          FormBox[
           RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultColorFunction" -> 
       "M10DefaultDensityGradient", 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, 
     PlotRange -> {{0., 6.283185307179586}, {0., 3.5}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJxFlwmcjvUWxyV3YmZsZbtJ9i1q7q2spR9ZrrJUuLYUQiEx1iRRdmNwiySk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              "], {{
                Rational[-225, 2], 
                Rational[-15, 2]}, {
                Rational[225, 2], 
                Rational[15, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[225, 2], 
                  Rational[-15, 2]}, {
                  Rational[-225, 2], 
                  Rational[-15, 2]}, {
                  Rational[-225, 2], 
                  Rational[15, 2]}, {
                  Rational[225, 2], 
                  Rational[15, 2]}, {
                  Rational[225, 2], 
                  Rational[-15, 2]}}, {{112.5, -7.5}, {-112.5, -7.5}, {-112.5,
                 7.5}, {112.5, 7.5}, {112.5, -7.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{-112.5, -7.5}, {112.5, -7.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{-112.5, -7.5}, 
                    
                    Offset[{
                    0, -4.}, {-112.5, -7.5}]}, {{-67.13709677419355, -7.5}, 
                    
                    Offset[{
                    0, -4.}, {-67.13709677419355, -7.5}]}, \
{{-21.774193548387096`, -7.5}, 
                    Offset[{0, -4.}, {-21.774193548387096`, -7.5}]}, {{
                    23.588709677419352`, -7.5}, 
                    Offset[{0, -4.}, {23.588709677419352`, -7.5}]}, {{
                    68.95161290322581, -7.5}, 
                    Offset[{0, -4.}, {68.95161290322581, -7.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{-103.4274193548387, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-103.4274193548387, -7.5}]}, \
{{-94.35483870967741, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-94.35483870967741, -7.5}]}, \
{{-85.28225806451613, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-85.28225806451613, -7.5}]}, \
{{-76.20967741935483, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-76.20967741935483, -7.5}]}, \
{{-58.064516129032256`, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-58.064516129032256`, -7.5}]}, \
{{-48.99193548387097, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-48.99193548387097, -7.5}]}, \
{{-39.91935483870967, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-39.91935483870967, -7.5}]}, \
{{-30.84677419354839, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-30.84677419354839, -7.5}]}, \
{{-12.701612903225822`, -7.5}, 
                    
                    Offset[{
                    0., -2.5}, {-12.701612903225822`, -7.5}]}, \
{{-3.6290322580645102`, -7.5}, 
                    Offset[{0., -2.5}, {-3.6290322580645102`, -7.5}]}, {{
                    5.443548387096765, -7.5}, 
                    Offset[{0., -2.5}, {5.443548387096765, -7.5}]}, {{
                    14.516129032258059`, -7.5}, 
                    Offset[{0., -2.5}, {14.516129032258059`, -7.5}]}, {{
                    32.66129032258065, -7.5}, 
                    Offset[{0., -2.5}, {32.66129032258065, -7.5}]}, {{
                    41.733870967741936`, -7.5}, 
                    Offset[{0., -2.5}, {41.733870967741936`, -7.5}]}, {{
                    50.80645161290322, -7.5}, 
                    Offset[{0., -2.5}, {50.80645161290322, -7.5}]}, {{
                    59.87903225806449, -7.5}, 
                    Offset[{0., -2.5}, {59.87903225806449, -7.5}]}, {{
                    78.02419354838712, -7.5}, 
                    Offset[{0., -2.5}, {78.02419354838712, -7.5}]}, {{
                    87.09677419354836, -7.5}, 
                    Offset[{0., -2.5}, {87.09677419354836, -7.5}]}, {{
                    96.16935483870967, -7.5}, 
                    Offset[{0., -2.5}, {96.16935483870967, -7.5}]}, {{
                    105.24193548387098`, -7.5}, 
                    Offset[{0., -2.5}, {105.24193548387098`, -7.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{0., -7.}, {-112.5, -7.5}], 
                    ImageScaled[{0.5, 1.}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{0., -7.}, {-67.13709677419355, -7.5}], 
                    ImageScaled[{0.5, 1.}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.02\"", ShowStringCharacters -> False], 0.02,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{0., -7.}, {-21.774193548387096`, -7.5}], 
                    ImageScaled[{0.5, 1.}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.03\"", ShowStringCharacters -> False], 0.03,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{0., -7.}, {23.588709677419352`, -7.5}], 
                    ImageScaled[{0.5, 1.}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.04\"", ShowStringCharacters -> False], 0.04,
                     AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{0., -7.}, {68.95161290322581, -7.5}], 
                    ImageScaled[{0.5, 1.}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{True, False}, {False, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {225, Automatic}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"M10DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", "0.0496170145003799`"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9294827621586204`*^9, 3.9294828135086756`*^9, 3.9294830033856516`*^9, 
   3.9294830485648627`*^9, 3.9294830876370797`*^9, {3.929483208026967*^9, 
   3.929483225076776*^9}, 3.929484508969494*^9, {3.9294846242543116`*^9, 
   3.9294846698846636`*^9}, {3.9294848376573544`*^9, 3.92948484059311*^9}, {
   3.929486749498397*^9, 3.929486772567152*^9}, {3.9294891758269243`*^9, 
   3.9294892505788608`*^9}, {3.9294893065462365`*^9, 3.929489385532962*^9}, {
   3.9294930691020393`*^9, 3.929493078452447*^9}, {3.929493141684026*^9, 
   3.929493178552899*^9}, {3.92949321329386*^9, 3.9294932255170755`*^9}, {
   3.9294933115409646`*^9, 3.9294933146022387`*^9}, 3.929493604973383*^9, 
   3.9294936367774916`*^9, {3.9294937631944256`*^9, 3.92949381227614*^9}, {
   3.9294942850470047`*^9, 3.9294943020254297`*^9}, {3.9294943547998977`*^9, 
   3.9294943671824408`*^9}, {3.9294944905114307`*^9, 3.929494509263996*^9}, 
   3.929494579838949*^9, 3.9294946691582775`*^9, 3.9294947447283654`*^9, 
   3.929494960280001*^9, {3.929495141816224*^9, 3.929495222837476*^9}, 
   3.929495263279383*^9, 3.929495315827509*^9, {3.929495417075984*^9, 
   3.9294954272163153`*^9}, {3.929495520384997*^9, 3.9294955490966225`*^9}, {
   3.9294955893064284`*^9, 3.9294955982354393`*^9}, 3.9294957785605206`*^9, 
   3.9295031150480127`*^9, 3.9295033477940226`*^9, 3.9295034648288045`*^9},
 CellLabel->
  "Out[4000]=",ExpressionUUID->"d1cdf9a2-94e7-4730-a00f-4c1bb3f69095"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1080., 652.2857142857142},
WindowMargins->{{
  Automatic, -5.14285714285711}, {-5.14285714285711, Automatic}},
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (2022\:5e746\:670816\
\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b05aef9c-20b0-41fc-b10c-8dd458d61bad"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 152, 3, 54, "Subsection",ExpressionUUID->"bae3c5c2-960d-47fd-8c60-3c328491dfc7"],
Cell[CellGroupData[{
Cell[757, 29, 8667, 207, 562, "Input",ExpressionUUID->"aa85bfc9-3e3a-4549-b1e2-4bd00fc23a8b"],
Cell[9427, 238, 1125, 21, 40, "Print",ExpressionUUID->"5c9746bc-658d-4bfa-a216-807c5b84817b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10589, 264, 5624, 146, 393, "Input",ExpressionUUID->"6d9c8584-a091-4b1d-9604-ac766adc329d"],
Cell[16216, 412, 559, 12, 22, "Print",ExpressionUUID->"4f00fba8-04d1-4650-88a9-2a045d9646fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16812, 429, 5979, 144, 183, "Input",ExpressionUUID->"70e79239-2684-419b-ae69-e7bf104dc1cf"],
Cell[22794, 575, 54089, 975, 434, "Output",ExpressionUUID->"d1cdf9a2-94e7-4730-a00f-4c1bb3f69095"]
}, Open  ]]
}, Open  ]]
}
]
*)

