
from niceview.utils.convert import h5ad_converter
from niceview.utils.dataset import ThorQuery
from niceview.interface.interface import *
import toml
import shutil
import json
from dash import html
from dash import dcc
import dash_uploader as du
import pandas as pd
import os
import time
import dash
from niceview.utils.tools import save_roi_data_img
import plotly.graph_objects as go
import numpy as np
from shapely.geometry import Point, Polygon
import scipy
import anndata as ad

cell_adata, wsi_img = 2, 3
mapper = 1
gene_index = 4
area = 1

# upload HE image
def upload_image(filenames_upload_image, folder_id, work_dir, app_dir):
    """
    Uploads the HE image and copy it to data path, then create client.

    Parameters:
        filenames_upload_image (list): List of uploaded filenames.

    Returns:
        None
    """

    # get thor parameter and all user input info
    data_path, cache_path = get_data_path_cache_path(work_dir)
    thor, args, p_input_json = get_parameter(folder_id, work_dir)

    # get sample id base on uuid from dash-uploader
    sample_id = os.path.split(os.path.split(filenames_upload_image[0])[0])[1]

    # get basename of upload image
    basename = os.path.splitext(os.path.basename(filenames_upload_image[0]))[0]

    # wait and chech if file exist in folder
    while not os.path.exists(filenames_upload_image[0]):
        time.sleep(5)

    # get the height and width of image to calculate max dimension
    height, width = thor.process_data(sample_id, img_path=filenames_upload_image[0])
    max_dim = max(height, width)

    # update it in user argument file
    args["heightWidth"] = [height, width]

    # check if max dimension > 10000, if yes put "temp" in their sample id, then update in arg file
    if max_dim > 10000:
        args['sampleId'] = "temp" + "-" + sample_id
        args['fileName'] = basename
        dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

    # else keep the originale sample id, then update in arg file
    else:
        args['sampleId'] = sample_id
        args['fileName'] = basename
        dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

    # get the name rules for further calculation, then copy it to data path
        files = files_generate(sample_id)
        shutil.copy(filenames_upload_image[0], os.path.join(data_path, files["img"]))
    # remove temp folder that dash-uploader created

    # calculate wsi of image
    get_wsi(folder_id, work_dir)

    # update the scale factor of data
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id_file = args["sampleIdFile"]
    cache = cache_generate(sample_id, sample_id_file=sample_id_file)
    gis_img_path = os.path.join(cache_path, cache["gis-img-file"])
    gis_img_path = os.path.abspath(gis_img_path)
    factor = thor.get_factor(gis_img_path)
    new_factor = f"e*{factor}"
    js_path = app_dir + "/assets/dash_leaflet.js"
    update_javascript(file_path=js_path, new_factor=new_factor)
    return None
# html.H5("Click the home button on the map to see input image", className="text") 


# choose cell or spot data
def show_cell_spot_upload(spot_cell_option, folder_id, work_dir):
    """
    Displays the upload options based on the selected data type.

    Parameters:
        spot_cell_option (str): Selected data type ('Spot data' or 'Cell data').

    Returns:
        html.Div: Div containing upload options.
    """
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id = args["sampleId"]
    global mapper
    sample_id_file = args['sampleIdFile']
    mapper = thor.get_coord_mapping(sample_id_file)
    
    if spot_cell_option == "Spot data":
        # show spot upload box
        return html.Div(className="upload-data", children=[
            html.Br(), html.Br(),
            html.H5("Upload gene expression data(.h5ad file) for spot:", className="text"),
            du.Upload(id='upload-data-addition-spot', max_file_size=20000)
        ])
    elif spot_cell_option == "Cell data":
        
        # show cell upload box
        return html.Div(className="upload-data", children=[
            html.Br(), html.Br(),
            html.H5("Upload mask(.npz file) and gene expression data(.h5ad file) for cell:", className="text"),
            du.Upload(id='upload-data-addition-cell', max_file_size=20000)
        ])
    else:
        # show nothing
        return html.Div(children=[])


# upload aditional data        
def upload_spot_data(filenames_upload_spot_data, folder_id, work_dir):
    """
    Uploads additional spot data and performs necessary operations.

    Parameters:
        filenames_upload_spot_data (list): List of uploaded filenames.

    Returns:
        None
    """
    # get parameter in argument file
    data_path, cache_path = get_data_path_cache_path(work_dir)
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id = args['sampleId']
    height = args["heightWidth"][0]
    width = args["heightWidth"][1]
    height_width = args["heightWidth"]
    max_dim = max(height, width)
    files = files_generate(sample_id)
    # if ".npz" in filenames_upload_spot_data[0]:
    #     while not os.path.exists(filenames_upload_spot_data[0]):
    #         time.sleep(5)
    #     shutil.copy(filenames_upload_spot_data[0], os.path.join(data_path, files["mask"]))
    # # if it not mask file h5ad convert
    # else:

    # h5ad convert
    if max_dim > 10000:
        thor.process_data(sample_id, height_width=height_width, adata_spot_path=filenames_upload_spot_data[0])
        db_info_path = f'{work_dir}/db/db-info.json'
        h5ad_converter(data_path, db_info_path, sample_id, h5ad_spot=os.path.join(data_path, files["spot-temp-h5ad"]))
        shutil.copy2(filenames_upload_spot_data[0], os.path.join(data_path,files["spot-temp-h5ad"]))
    else:
        while not os.path.exists(filenames_upload_spot_data[0]):
            time.sleep(5)
        db_info_path = f'{work_dir}/db/db-info.json'
        h5ad_converter(data_path, db_info_path, sample_id, h5ad_spot=filenames_upload_spot_data[0])

    # remove temp folder that dash-uploader created
    
    return None 


def upload_cell_data(filenames_upload_cell_data, folder_id, work_dir):
    """
    Uploads additional cell data and performs necessary operations.

    Parameters:
        filenames_upload_cell_data (list): List of uploaded filenames.

    Returns:
        None
    """
    # get parameter in argument file, and get max dimension
    data_path, cache_path = get_data_path_cache_path(work_dir)
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id = args['sampleId']
    height = args["heightWidth"][0]
    width = args["heightWidth"][1]
    height_width = args["heightWidth"]
    max_dim = max(height, width)
    files = files_generate(sample_id)

    # check if 'npz' in the file name, if yes copy to data path and rename it
    if ".npz" in filenames_upload_cell_data[0]:
        while not os.path.exists(filenames_upload_cell_data[0]):
            time.sleep(5)
    # check if max dim > 10000 reduce size
        if max_dim > 10000:
            thor.process_data(sample_id, height_width=height_width, mask_path=filenames_upload_cell_data[0])
        else:
            shutil.copy(filenames_upload_cell_data[0], os.path.join(data_path, files["mask"]))
        if os.path.exists(os.path.join(data_path, files["cell-barcode"])):
            cell_number = pd.read_csv(os.path.join(data_path, files["cell-barcode"]),header=None, index_col=0,sep="\t")
            cell_number = len(list(cell_number.index))
            return html.H4(f"Cell number = {cell_number} cells", className="text") 
        else:
            return None
    # same thing with h5ad, then convert
    else:
        while not os.path.exists(filenames_upload_cell_data[0]):
            time.sleep(5)
        if max_dim > 10000:
            thor.process_data(sample_id, height_width=height_width, adata_cell_path=filenames_upload_cell_data[0])
            db_info_path = f'{work_dir}/db/db-info.json'
            h5ad_converter(data_path, db_info_path, sample_id, h5ad_cell=os.path.join(data_path, files["cell-temp-h5ad"]))
            shutil.copy2(filenames_upload_cell_data[0], os.path.join(data_path,files["cell-temp-h5ad"]))
        else:
            db_info_path = f'{work_dir}/db/db-info.json'
            h5ad_converter(data_path, db_info_path, sample_id, h5ad_cell=filenames_upload_cell_data[0])
        cell_number = pd.read_csv(os.path.join(data_path, files["cell-barcode"]),header=None, index_col=0,sep="\t")
        cell_number = len(list(cell_number.index))
        gene = pd.read_csv(os.path.join(data_path, files["cells-gene-names"]),header=None, index_col=0,sep="\t")
        gene_list = list(gene.index)
        gene_dict = {value: index for index, value in enumerate(gene_list)}
        try: 
            os.remove(f"{work_dir}/db/data/{sample_id}-gene-index.json")
        except FileNotFoundError:
            pass
        with open(f"{work_dir}/db/data/{sample_id}-gene-index.json", 'w') as f:
            json.dump(gene_dict, f)
        
        # update global variable
    global cell_adata
    global wsi_img
    global mapper
    global gene_index
    cell_adata, wsi_img = thor.get_cell_adata_and_img(sample_id)
    sample_id_file = args['sampleIdFile']
    mapper = thor.get_coord_mapping(sample_id_file)
    with open(f"{work_dir}/db/data/{sample_id}-gene-index.json", 'r') as f:
        gene_index = json.load(f)

        return html.H4(f"Cell number = {cell_number} cells", className="text") 
    

# choose type of visualization
def update_output_visual(spot_cell_option, visualize_option, folder_id, work_dir):
    """
    Updates the visualization options based on selected data type and visualization type.

    Parameters:
        spot_cell_option (str): Selected data type ('Spot data' or 'Cell data').
        visualize_option (str): Selected visualization type.

    Returns:
        html.Div: Div containing updated visualization options.
    """
    try:
        os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
    except FileNotFoundError:
        pass
    # if choose gene expression
    data_path, cache_path = get_data_path_cache_path(work_dir)
    if visualize_option == "Gene Expression":

        # get parameter
        thor, args, p_input_json = get_parameter(folder_id, work_dir)
        sample_id = args['sampleId']

        if spot_cell_option == "Spot data":
            
            # get name follow the rule
            files = files_generate(sample_id)

            # check if file exist
            while not os.path.exists(os.path.join(data_path, files["spots-gene-names"])):
                time.sleep(5)
                return html.H5("Data has not successfuly uploaded yet", className="text")
            
            # read gene name file and convert to list
            gene_name = pd.read_csv(os.path.join(data_path, files["spots-gene-names"]), header=None, index_col=0)
            gene_list = list(gene_name.index)

                # return the dropdown contain gene list
            return html.Div(children=[
                html.H5("Choose Gene", className="text"),
                dcc.Dropdown(gene_list, id="gene-input-container", className='dropdown-input', placeholder="Input or Select Gene"),
                html.Br(),html.Br(),html.Br(),
                html.H5("Insert vmax vmin", className="text"),
                dcc.Input(id='spot-input-min', type='text', className="input-container",debounce=True, placeholder="vmin"),
                dcc.Input(id='spot-input-max', type='text', className="input-container",debounce=True, placeholder="vmax"),
                html.Button(id='spot-vminmax-button', n_clicks=0, children='Submit', className="button button-input"),
                ]
                )
        # if cell data
        elif spot_cell_option == "Cell data":
                
            # get name follow the rule
            files = files_generate(sample_id)

            # check file exist
            while not os.path.exists(os.path.join(data_path, files["cells-gene-names"])):
                time.sleep(5)
                return html.H5("Data has not successfuly uploaded yet", className="text")
            
            # read gene name file and convert to list 
            gene_name = pd.read_csv(os.path.join(data_path, files["cells-gene-names"]), header=None, index_col=0)
            gene_list = list(gene_name.index)

            # return the dropdown contain gene list
            return html.Div(children=[
                html.H5("Choose Gene", className="text"),
                dcc.Dropdown(gene_list, id="gene-input-container", className='dropdown-input', placeholder="Input or Select Gene"),
                html.Br(),html.Br(),html.Br(),
                html.H5("Insert vmax vmin", className="text"),
                dcc.Input(id='cell-input-min', type='text', className="input-container",debounce=True, placeholder="vmin"),
                dcc.Input(id='cell-input-max', type='text', className="input-container",debounce=True, placeholder="vmax"),
                html.Button(id='cell-vminmax-button', n_clicks=0, children='Submit', className="button button-input"),
                ]
                )
    
    # if chose Pathway
    elif visualize_option == "Pathway Enrichment Analysis":
        # get parameter
        thor, args, p_input_json = get_parameter(folder_id, work_dir)
        sample_id = args['sampleId']


        # if cell data
        if spot_cell_option == "Cell data":
            files = files_generate(sample_id)
            if os.path.exists(os.path.join(data_path, files["cell-pathway-name"])):
                # read pathway file convert to list
                pathway_name = pd.read_csv(os.path.join(data_path, files["cell-pathway-name"]), header=None, index_col=0)
                pathway_list = list(pathway_name.index)
                pathway_drop = html.Div( id="pathway-dropdown", children=[
                        html.H5("Choose Pathway", className="text"),
                        dcc.Dropdown(pathway_list, id="pathway-input-container", className='dropdown-input', placeholder="Select Pathway")
                ])
            else:
                pathway_drop = html.Div(id="pathway-dropdown")
            # return upload container
            return html.Div(children=[
                html.Div(className="upload-data", children=[
                    html.H5("Upload pathway (.h5ad file) with vars are pathways and obs are cells", className="text"),
                    du.Upload(id='upload-data-pathway', max_file_size=20000)
                ]),
                pathway_drop,
                
            ])
        # or show not support
        else:
            return html.H5("Only support Cell data", className="text")
        
    # if chose CNV    
    elif visualize_option == "CNV":

        # if cell data
        if spot_cell_option == "Cell data":

            # return upload container
            return html.Div(children=[
                html.Div(className="upload-data", children=[
                    html.H5("Upload CNV (.csv or .txt file) with first column are cells and second column are CNV label", className="text"),
                    du.Upload(id='upload-data-cnv', max_file_size=20000),
                    html.Br(),
                    html.H5("Click re-visualize button after finish upload to show result", className="text"),
                ])
            ])
        
        # or show not support
        else:
            return html.H5("Only support Cell data", className="text")
    
    elif visualize_option == "Similar Cell Locate":
        if spot_cell_option == "Cell data":
            return html.Div(children=[
                html.Div(className="upload-data", children=[
                        html.Button("Search", className="button", id="btn_find"),
                        html.H5("Select area and click search button to calculate.", className="text"),
                        html.H5("Then click re-visualize button to show result", className="text"),
                        ])
                ])
        
        # or show not support
        else:
            return html.H5("Only support Cell data", className="text")
        
    # if chose cell detection   
    elif visualize_option == 'Cell Detection Check':


        # if cell data
        if spot_cell_option == "Cell data":
            calculation_cell_detection(folder_id, work_dir)
    
            # return button
            return html.H5("Click re-visualize to see result", className="text")
        
        # or show not support
        else:
            return html.H5("Only support Cell data", className="text") 
    

# # cell detection button
# def show_cell_detection(n_clicks, folder_id, work_dir):
#     data_path, cache_path = get_data_path_cache_path(work_dir)
#     # if click
#     if n_clicks:

#         # generate map
#         map_input = visualization_img_cell(folder_id, work_dir, cell_detect=True)

#         # visualize result
#         return html.Div(id="input-image", children=[map_input])
    
#     # if no click keep previous map
#     else:
#         raise dash.exceptions.PreventUpdate


# upload pathway
def upload_pathway(filenames_upload_pathway, folder_id, work_dir):
    """
    Uploads pathway data and performs necessary operations.

    Parameters:
        filenames_upload_pathway (list): List of uploaded filenames.

    Returns:
        None
    """
    # get parameter
    data_path, cache_path = get_data_path_cache_path(work_dir)
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id = args['sampleId']

    # remove previous selected area folder, if not found pass
    try:
        os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
    except FileNotFoundError:
        pass

    # check if file exist
    while not os.path.exists(filenames_upload_pathway[0]):
        time.sleep(5)

    # convert h5ad to processed file
    db_info_path = f'{work_dir}/db/db-info.json'    
    h5ad_converter(data_path, db_info_path, sample_id, h5ad_cell_pathway=filenames_upload_pathway[0])

    # remove temp folder create by dash uploader
    

    # get file name by rules
    files = files_generate(sample_id)

    # read pathway file convert to list
    pathway_name = pd.read_csv(os.path.join(data_path, files["cell-pathway-name"]), header=None, index_col=0)
    pathway_list = list(pathway_name.index)

    # return dropdown with all pathway
    return html.Div(children=[
            html.H5("Choose Pathway", className="text"),
            dcc.Dropdown(pathway_list, id="pathway-input-container", className='dropdown-input', placeholder="Select Pathway")
    ])


# choose pathway
def get_pathway_output(spot_cell_option, pathway_value, folder_id, work_dir):
    """
    Handles the selection of a pathway and performs necessary calculation.

    Parameters:
        spot_cell_option (str): Selected data type ('Spot data' or 'Cell data').
        pathway_value (str): Selected pathway name.

    Returns:
        html.Div: Div containing the updated visualization.
    """
    data_path, cache_path = get_data_path_cache_path(work_dir)
    try:
        os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
    except FileNotFoundError:
        pass
    # if cell data
    if spot_cell_option == "Cell data":

        # if pathway been chosen
        if pathway_value is not None:

            # get parameter
            thor, args, p_input_json = get_parameter(folder_id, work_dir)
            sample_id = args['sampleId']

            # remove previous selected area folder, if not found pass

            # get pathway name from user input and dump it to json file
            args["selectedPathway"] = pathway_value
            dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

            # check if user already chose that pathway, if not calculate and dump it to json file, if yes show previous result
            if pathway_value not in p_input_json['Pathway']:

                calculation_pathway(folder_id, work_dir)

                p_input_json['Pathway'].append(pathway_value)
                dumpjson_parameter_from_user_input(folder_id, work_dir, p_input_json=p_input_json)

                map_input = visualization_img_cell(folder_id, work_dir, pathway=True)

            else:
                sample_id_pathway = sample_id + "-" + pathway_value
                args['sampleIdPathway'] = sample_id_pathway

                dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)
                map_input = visualization_img_cell(folder_id, work_dir, pathway=True)

            # visualize result    
            return html.Div(id="input-image", children=[map_input])
        
        # or keep previous map
        else:
            raise dash.exceptions.PreventUpdate


# upload cnv
def upload_cnv(filenames_upload_cnv, folder_id, work_dir):
    """
    Uploads cnv data and performs necessary operations.

    Parameters:
        filenames_upload_cnv (list): List of uploaded filenames.

    Returns:
        None
    """

    # get parameter
    data_path, cache_path = get_data_path_cache_path(work_dir)
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    sample_id = args['sampleId']

    # remove previous selected area folder, if not found pass
    try:
        os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
    except FileNotFoundError:
        pass

    # get file name by rules
    files = files_generate(sample_id)

    # check if all file needed exist
    while not os.path.exists(os.path.join(data_path, files["cell-barcode"])):
        time.sleep(5)
    while not os.path.exists(os.path.join(data_path, files["cell-info"])):
        time.sleep(5)
    while not os.path.exists(os.path.join(data_path, files["mask"])):
        time.sleep(5)
    cell_order = pd.read_csv(os.path.join(data_path, files["cell-barcode"]), index_col=0, sep="\t", header=None)

    # check extension of cnv file, to get appropriate read
    if ".csv" in filenames_upload_cnv[0]:
        input_cnv = pd.read_csv(filenames_upload_cnv[0], index_col=0)
    else:
        input_cnv = pd.read_csv(filenames_upload_cnv[0], index_col=0, sep="\t")

    # reorder cell order
    input_cnv = input_cnv.reindex(list(cell_order.index))

    # open cell info and put cnv info under label
    cell_info = pd.read_csv(os.path.join(data_path, files["cell-info"]), index_col=0)
    cell_info["label"] = list(input_cnv.iloc[:, 0])
    cell_info.to_csv(os.path.join(data_path, files["cell-info"]))
    # calculate cnv
    calculation_CNV(folder_id, work_dir)
    
    return None


# choose gene
def get_gene(spot_cell_option, gene_chosen, folder_id, work_dir):
    """
    Handles the selection of a gene and performs necessary calculation.

    Parameters:
        spot_cell_option (str): Selected data type ('Spot data' or 'Cell data').
        gene_chosen (str): Selected gene name.

    Returns:
        html.Div: Div containing the updated visualization.
    """
    data_path, cache_path = get_data_path_cache_path(work_dir)
    if spot_cell_option == "Spot data":
        if gene_chosen is not None:

            # Get Thor, arguments, and previous input JSON
            thor, args, p_input_json = get_parameter(folder_id, work_dir)
            sample_id = args['sampleId']

            # remove previous selected area folder, if not found pass
            try:
                os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
            except FileNotFoundError:
                pass
            
            # Set the selected spot gene name and dump to args json
            args['selectedSpotGeneName'] = gene_chosen
            dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

            # If gene not present in previous input JSON
            if gene_chosen not in p_input_json['SpotGene']:

                # Perform calculation for Spot data
                calculation_spot(folder_id, work_dir)

                # Update previous input JSON with new gene
                p_input_json['SpotGene'].append(gene_chosen)
                dumpjson_parameter_from_user_input(folder_id, work_dir, p_input_json=p_input_json)

                # Generate visualization for Spot data
                map_input = visualization_img_spot(folder_id, work_dir)

            # If gene already present in previous input JSON
            else:

                # get file name with gene name in it to prevent dash leaflet cache
                sample_id_gene_spot = sample_id + "-" + gene_chosen
                args['sampleIdSpotGene'] = sample_id_gene_spot
                dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

                # Generate visualization for Spot data
                map_input = visualization_img_spot(folder_id, work_dir)

            # Return updated visualization
            return html.Div(id="input-image", children=[map_input])
        
        # If gene is None, prevent update
        else:
            raise dash.exceptions.PreventUpdate
         
    elif spot_cell_option == "Cell data":
        if gene_chosen is not None:
            # Get Thor, arguments, and previous input JSON
            thor, args, p_input_json = get_parameter(folder_id, work_dir)
            sample_id = args['sampleId']

            global cell_adata
            global wsi_img
            global mapper
            global gene_index
            cell_adata, wsi_img = thor.get_cell_adata_and_img(sample_id)
            sample_id_file = args['sampleIdFile']
            mapper = thor.get_coord_mapping(sample_id_file)
            with open(f"{work_dir}/db/data/{sample_id}-gene-index.json", 'r') as f:
                gene_index = json.load(f)

            # Attempt to remove a file, if it exists
            try:
                os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
            except FileNotFoundError:
                pass
            
            # Set the selected cell gene name and dump to args json
            args['selectedCellGeneName'] = gene_chosen
            dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

            # If gene not present in previous input JSON
            if gene_chosen not in p_input_json['CellGene']:
                # Perform calculation for cell data
                calculation_cell(folder_id, work_dir)

                # dump gene name in previous input json
                p_input_json['CellGene'].append(gene_chosen)
                dumpjson_parameter_from_user_input(folder_id, work_dir, p_input_json=p_input_json)

                # Generate visualization for cell data
                map_input = visualization_img_cell(folder_id, work_dir)
            else:

                # get file name with gene name in it to prevent dash leaflet cache
                sample_id_gene_cell = sample_id + "-" + gene_chosen
                args['sampleIdCellGene'] = sample_id_gene_cell
                dumpjson_parameter_from_user_input(folder_id, work_dir, args=args)

                # Generate visualization for cell data
                map_input = visualization_img_cell(folder_id, work_dir)

            # Return updated visualization
            return html.Div(id="input-image", children=[map_input])
        
        # If gene is None, prevent update
        else:
            raise dash.exceptions.PreventUpdate
        
    # If spot_cell_option is None, prevent update
    else:
        raise dash.exceptions.PreventUpdate
    

# cell vmin vmax
def cell_vmin_vmax(n_clicks, vmin, vmax, folder_id, work_dir):
    if vmin is not None or vmax is not None:

            data_path, cache_path = get_data_path_cache_path(work_dir)
            thor, args, p_input_json = get_parameter(folder_id, work_dir)
            sample_id_gene_cell = args['sampleIdCellGene'] 
            if vmin == "":
                vmin = None
            if vmax == "":
                vmax = None

            if vmin is not None and vmax is not None:
                if 'p' not in vmin:
                    vmin = float(vmin)
                if 'p' not in vmax:
                    vmax = float(vmax)
                args["sampleIdMinMax"] = sample_id_gene_cell + '-' + str(vmin) + '-' + str(vmax)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_cell(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_cell(folder_id, work_dir, min_max=True)
            elif vmin is not None:
                if 'p' not in vmin:
                    vmin = float(vmin)
                args["sampleIdMin"] = sample_id_gene_cell + '-' + str(vmin)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_cell(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_cell(folder_id, work_dir, min=True)
            elif vmax is not None:
                if 'p' not in vmax:
                    vmax = float(vmax)
                args["sampleIdMax"] = sample_id_gene_cell + '-' + str(vmax)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_cell(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_cell(folder_id, work_dir, max=True)
    return html.Div(id="input-image", children=[map_input])


# spot vmin vmax
def spot_vmin_vmax(n_clicks, vmin, vmax, folder_id, work_dir):
    if vmin is not None or vmax is not None:

            data_path, cache_path = get_data_path_cache_path(work_dir)
            thor, args, p_input_json = get_parameter(folder_id, work_dir)
            sample_id_gene_spot = args['sampleIdSpotGene'] 
            if vmin == "":
                vmin = None
            if vmax == "":
                vmax = None
            if vmin is not None and vmax is not None:
                if 'p' not in vmin:
                    vmin = float(vmin)
                if 'p' not in vmax:
                    vmax = float(vmax)
                args["sampleIdMinMax"] = sample_id_gene_spot + '-' + str(vmin) + '-' + str(vmax)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_spot(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_spot(folder_id, work_dir, min_max=True)
            elif vmin is not None:
                if 'p' not in vmin:
                    vmin = float(vmin)
                args["sampleIdMin"] = sample_id_gene_spot + '-' + str(vmin)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_spot(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_spot(folder_id, work_dir, min=True)
            elif vmax is not None:
                if 'p' not in vmax:
                    vmax = float(vmax)
                args["sampleIdMax"] = sample_id_gene_spot + '-' + str(vmax)
                dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
                calculation_spot(folder_id, work_dir, vmin, vmax)
                map_input = visualization_img_spot(folder_id, work_dir, max=True)
    return html.Div(id="input-image", children=[map_input])


def reset(n_clicks, spot_cell_option, visual_type, folder_id, work_dir):
    """
    Reset image to original center

    Parameters:
        spot_cell_option (str): Selected data type ('Spot data' or 'Cell data').
        gene_chosen (str): Selected gene name.
        n_clicks (int): number of clicks

    Returns:
        html.Div: Div containing the updated visualization.
    """
    data_path, cache_path = get_data_path_cache_path(work_dir)
    changed_id = [p['prop_id'] for p in dash.callback_context.triggered][0]

    if 'n_clicks' in changed_id:

        if spot_cell_option == "Spot data":
            if visual_type == "Gene Expression":
                map_input = visualization_img_spot(folder_id, work_dir)
        else:
            if visual_type == "Gene Expression":
                map_input = visualization_img_cell(folder_id, work_dir)
            elif visual_type == "CNV":
                map_input = visualization_img_cell(folder_id, work_dir, cell_type=True)
            elif visual_type == "Pathway Enrichment Analysis":
                map_input = visualization_img_cell(folder_id, work_dir, pathway=True)
            elif visual_type == "Cell Detection Check":
                map_input = visualization_img_cell(folder_id, work_dir, cell_detect=True)
            elif visual_type == "Similar Cell Locate":
                map_input = visualization_img_cell(folder_id, work_dir, cell_select=True)
            else:
                map_input = visualization_img_input(folder_id, work_dir)
        return html.Div(id="input-image", children=[map_input])
    else:
        raise dash.exceptions.PreventUpdate


def copy_and_rename_file(n_clicks, folder_id, work_dir, zip=False):
    """Copy and rename file.
    
    Args:
        n_clicks (int): Number of clicks.
    
    Returns:
        Download zip folder
    """
    if n_clicks:
        thor, args, p_input_json = get_parameter(folder_id, work_dir)
        data_path, cache_path = get_data_path_cache_path(work_dir)
        sample_id = args["sampleId"]
        height = args["heightWidth"][0]
        width = args["heightWidth"][1]
        max_dim = max(height, width)

        try:
            os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")
        except FileNotFoundError:
            pass
        sample_id = args['sampleId']
        dir_path = f'{work_dir}/user{folder_id}/selected_area/'
        os.makedirs(dir_path, exist_ok=True)
        coord_path = os.path.join(dir_path, 'coords.json')
        shutil.copyfile(f'{work_dir}/user{folder_id}/coords.json', coord_path)
        with open(coord_path, 'r') as f:
            coords = json.load(f)
        
        coords_temp = coords
        if max_dim > 10000:
            files =files_generate(sample_id)
            resize_factor = 10000 / max_dim
            new_coords = [[[coord[0] / resize_factor, coord[1] / resize_factor] for coord in inner_list] for inner_list in coords]
            coords = new_coords
            cell_adata_temp = ad.read_h5ad(os.path.join(data_path,files["cell-temp-h5ad"]))
            with open(coord_path, 'w') as f:
                json.dump(coords, f)

            
            save_roi_data_img(coords,cell_adata_temp, wsi_img, dir_path,coords_temp = coords_temp)
        else:
            save_roi_data_img(coords,cell_adata, wsi_img, dir_path,coords_temp = coords_temp)
        

        drawn_geojson = []
        coords = []
        geojson_name = f'{work_dir}/user{folder_id}/roi.json'
        with open(geojson_name, 'w') as f:
            json.dump(drawn_geojson, f)
        coordjson_name = f'{work_dir}/user{folder_id}/coords.json'
        with open(coordjson_name, 'w') as f:
            json.dump(coords, f)
        if zip is True:
            zip_folder(dir_path, f"{work_dir}/user{folder_id}/selected_area.zip")
    try:
        return dcc.send_file(f"{work_dir}/user{folder_id}/selected_area.zip")
    except FileNotFoundError:
        return None


def save_roi(drawn_geojson, folder_id, work_dir):
    """Save coordinates.
    
    Args:
        drawn_geojson (dict): GeoJSON.

    Returns:
        json file.
    """
    if drawn_geojson is not None:

        coords = []
        for region in drawn_geojson['features']:
            temp = region['geometry']['coordinates'][0]
            temp = [mapper(*point) for point in temp]
            temp = [[point[1], point[0]] for point in temp]  # y, x -> x, y
            coords.append(temp)
        
        geojson_name = f'{work_dir}/user{folder_id}/roi.json'
        with open(geojson_name, 'w') as f:
            json.dump(drawn_geojson, f)
        
        coordjson_name = f'{work_dir}/user{folder_id}/coords.json'
        with open(coordjson_name, 'w') as f:
            json.dump(coords, f)
    return None



def plot_stats(drawn_geojson, gene_chosen, folder_id, work_dir):
    """Plot stats.
    
    Args:
        n_clicks (int): number of clicks.
        drawn_geojson (dict): GeoJSON.
        idx (int): index.
    
    Returns:
        fig: Figure.
    """
    if not isinstance(gene_index,int):
        try:
            idx = gene_index[gene_chosen]
        except KeyError:
            gene_chosen = gene_chosen.split('_')
            gene_chosen = gene_chosen[-2]
            idx = gene_index[gene_chosen]

        coords = []
        idx = list(cell_adata.var.index).index(gene_chosen)
        for region in drawn_geojson['features']:
            temp = region['geometry']['coordinates'][0]
            temp = [mapper(*point) for point in temp]
            temp = [[point[1], point[0]] for point in temp]  # y, x -> x, y
            coords.append(temp)
        
        target = np.array([])
        for coord in coords:
            roi = Polygon(coord)
            locs = list(map(lambda x: roi.contains(Point(x)), cell_adata.obsm['spatial']))
            to_keep = cell_adata[locs].copy()
            if scipy.sparse.issparse(to_keep.X):
                array = to_keep.X[:, idx].toarray().ravel()
            else:
                array = to_keep.X[:, idx].ravel()
            target = np.concatenate((target, array))
        hist = go.Figure(
            data=go.Histogram(
                x=target,
            ),
            layout=go.Layout(
                title=f'Histogram: selected region of {gene_chosen}<br>                  for cell data',
                xaxis={'title': 'Gene expression','showline': True},
                yaxis={'title': 'Number of cells', 'showline': True},
                font=dict(color='white'),
                paper_bgcolor='black',
                plot_bgcolor='black'
            ),
        )
        table = go.Figure(
            data=go.Table(
                header={
                    'values': ['Mean', 'Median', 'Std'],
                    'align': 'center',
                    'fill_color': 'black'
                },
                cells={
                    'values': [
                        np.round(np.mean(target), 2),
                        np.round(np.median(target), 2),
                        np.round(np.std(target), 2),
                    ],
                    'align': 'center',
                    'fill_color': 'black'
                },
            ),
            layout=go.Layout(
                title=f'Statistics: selected region of {gene_chosen}<br>               for cell data',
                font=dict(color='white'),
                paper_bgcolor='black',
                plot_bgcolor='black'
            ),
        )

    
        return dcc.Graph(figure=hist, style={"height":"300px","color":"black"}), dcc.Graph(figure=table,style={"height":"300px","color":"black"})
    else:
        raise dash.exceptions.PreventUpdate


def show_mouse_position(clickData, folder_id, work_dir):
    """Show mouse position.
    
    Args:
        clickData (dict): Click data.
    
    Returns:
        str: Mouse position.
    """
    thor, args, p_input_json = get_parameter(folder_id, work_dir)
    data_path, cache_path = get_data_path_cache_path(work_dir)
    sample_id = args["sampleId"]
    height = args["heightWidth"][0]
    width = args["heightWidth"][1]
    max_dim = max(height, width)
    
    if clickData is None:
        return html.Div([
            html.Br(),
            html.H5('Click on the map to get coordinates',className="text")
            ])
    else:
        if max_dim > 10000:
            resize_factor = 10000 / max_dim
        else:
            resize_factor = 1
        lat = clickData['latlng']['lat']
        lon = clickData['latlng']['lng']
        y, x = mapper(lon, lat)
        x = np.ceil(x / resize_factor)
        y = np.ceil(y / resize_factor)
        return html.Div([
            html.Br(), 
            html.H5(f'You clicked on x: {x}, y: {y}',className="text")
         ])


def cell_selection_interface(n_clicks, folder_id, work_dir):
    if n_clicks:
        global area
        thor, args, p_input_json = get_parameter(folder_id, work_dir)
        data_path, cache_path = get_data_path_cache_path(work_dir)
        sample_id = args["sampleId"]
        copy_and_rename_file(n_clicks, folder_id, work_dir)
        ad_ROI = ad.read_h5ad(f'{work_dir}/user{folder_id}/selected_area/roi-0.h5ad')
        adata = cell_adata
        df_sele_mask = cell_selection_main(adata, ad_ROI)
        # reorder cell order
        df_sele_mask = df_sele_mask.reindex(list(cell_adata.obs.index))
        files = files_generate(sample_id)
        # open cell info and put cnv info under label
        cell_info = pd.read_csv(os.path.join(data_path, files["cell-info"]), index_col=0)
        cell_info["cell_select"] = list(df_sele_mask.iloc[:, 0])
        cell_info.to_csv(os.path.join(data_path, files["cell-info"]))
        if f"area{area}" in p_input_json["Area"]:
            area = area + 1
        else:
            area = area
        sample_id_area = sample_id + "-"+ f"area{area}"
        p_input_json["Area"].append(f"area{area}")
        args["sampleIdArea"] = sample_id_area
        dumpjson_parameter_from_user_input(folder_id, work_dir, args, p_input_json)
        calculation_similar_cell(folder_id, work_dir)
        return None
    


def clear_cache_forcall(n_clicks, folder_id, work_dir, app_dir):
    if n_clicks:
        clear_cache(folder_id, work_dir)
        clear_data(folder_id, work_dir)
        try:
            shutil.rmtree(f"{work_dir}/data_input_temp/tmp/{folder_id}")
        except FileNotFoundError:
            pass
        factor = 10.094100024003847
        new_factor = f"e*{factor}"
        js_path = app_dir + "/assets/dash_leaflet.js"
        update_javascript(file_path=js_path, new_factor=new_factor)
        dump_default_para_arg(folder_id, work_dir)
    return None


