# python app.py --port=8082
import argparse
from niceview.interface.callback import *
from niceview.interface.interface import prepare_file_folder, update_data_cache, dump_default_para_arg
import dash
from dash import html
from dash import dcc
from dash.dependencies import Input, Output, State
import dash_uploader as du
import dash_loading_spinners as dls
import shutil
import os
import uuid
from threading import Timer
import webbrowser
from localtileserver.web.blueprint import cache, tileserver


current_wd = os.getcwd()
parser = argparse.ArgumentParser(description='Run Dash app.')
parser.add_argument('--port', type=int, default=8080, help='Port to run the app on')
parser.add_argument('--wd', type=str, default=current_wd, help='Working directory for the app')
args = parser.parse_args()

work_dir = args.wd
folder_id = ""
app_dir = os.path.dirname(os.path.realpath(__file__))

# Initialize app
app = dash.Dash(
    __name__,
    meta_tags=[
       {"name": "viewport", "content": "width=device-width, initial-scale=1"}
    ],
    suppress_callback_exceptions=True
)
cache.init_app(app.server)
app.server.register_blueprint(tileserver, url_prefix='/')

temp_dir = f"{work_dir}/data_input_temp/tmp/"
app.title = "Mjolnir"
server = app.server
du.configure_upload(app, temp_dir, use_upload_id=True)
prepare_file_folder(folder_id, work_dir)
update_data_cache(folder_id, work_dir)
dump_default_para_arg(folder_id, work_dir)

gene_chosen = None
# target Null

hist = go.Figure(
        data=go.Histogram(
        ),
        layout=go.Layout(
            title=f'Histogram: selected region of {gene_chosen} for cell data',
            xaxis={'title': 'Gene expression','showline': True},
            yaxis={'title': 'Number of cells', 'showline': True},
            font=dict(color='white'),
            paper_bgcolor='black',
            plot_bgcolor='black'
        ),
    )
table = go.Figure(
    data=go.Table(
        header={
            'values': ['Mean', 'Median', 'Std'],
            'align': 'center',
            'fill_color': 'black'
        },
        cells={
            'values': [
                0,0,0
            ],
            'align': 'center',
            'fill_color': 'black'
        },
    ),
    layout=go.Layout(
        title=f'Statistics: selected region of {gene_chosen} for cell data',
        font=dict(color='white'),
        paper_bgcolor='black',
        plot_bgcolor='black'
    ),
)


# App layout
def app_layout():

    try:
        os.remove(f"{work_dir}/user{folder_id}/selected_area.zip")    
    except FileNotFoundError:
        pass
    try:
        shutil.rmtree(f"{work_dir}/user{folder_id}/selected_area/")
    except FileNotFoundError:
        pass
    return html.Div( id="body",
        
        children=[
            html.Link(rel='stylesheet', href="https://use.fontawesome.com/releases/v5.5.0/css/all.css", integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU", crossOrigin="anonymous"),
            html.Link(rel='stylesheet', href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"),
            html.Div(id='header',
            children=[
                html.H4(id="logo", children='Mjolnir', className="text"),
                html.H4(children='/ˈmjɔːlnɪər/', className="text")
            ]),
            html.Div(
                className='container clearfix', id="display",
                children=[
                    html.Div(id='submit-container', children=[  
                            html.Div(className="upload-data", children=[
                                html.H5("Upload H&E image:", className="text"),
                                du.Upload(id='upload-data-image', max_file_size=20000),
                            ]),
                            html.Br(),
                            html.H5("After page auto refresh", className="text"),
                            html.H5("click the re-visualize button to see input image", className="text"),
                            html.Button('Re-visualize Image', className="button", id="visual-input", n_clicks=0),
                            html.Br(),
                            html.Div(children=[
                                html.H5("Choose type of data", className="text"),
                                dcc.Dropdown(['Spot data', 'Cell data'], id="spot-cell-option", className='dropdown-input', placeholder="Choose Cell or Spot data type")
                                ]),
                            html.Br(),
                            html.Br(),
                            dls.Hash(
                                html.Div(id="additional-data-box"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            html.Br(), html.Br(),
                            html.H5("Choose type of visualization", className="text"),
                            html.Div(children=[dcc.Dropdown(['Pathway Enrichment Analysis', 'Gene Expression', 'CNV', 'Cell Detection Check', 'Similar Cell Locate'], id="visual-type-container", className='dropdown-input', placeholder="Select Type")]),
                            html.Br(), html.Br(), html.Br(),
                            dls.Hash(
                                html.Div(id="gene-dropdown"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            html.Button('Done (clear cache)', className="button", id="clear-cache", n_clicks=0),
                            html.H5("If you had not clicked DONE,", className="text"),
                            html.H5("you can still visualize your data without re-upload", className="text"),
                            html.Div(id='mouse-position'),
                            html.Br(),html.Br(),
                            dls.Hash(
                                html.Div(id="status1"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            dls.Hash(
                                html.Div(id="status2"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            dls.Hash(
                                html.Div(id="status3"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            dls.Hash(
                                dcc.Download(id="download"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            dls.Hash(
                                html.Div(id="status5"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100
                            ),
                            dls.Hash(
                                html.Div(id="status6"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100
                            ),
                             dls.Hash(
                                html.Div(id="status7"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100
                            ),
                            dls.Hash(
                                html.Div(id="status8"),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100
                            ),
                            ]),
                            
                    html.Div(
                        id='left-column-temp',
                        children=[
                        #     html.Div(id="cell-number", children=[
                        #         html.H2("Visualize HE image:", className="text"),
                        #         ]
                        #     ),
                            html.Br(),
                            html.Br(), 
                            dls.Hash(
                                html.Div(
                                    id="input-image",
                                    children=[
                                        html.Br(), html.Br(), html.Br(), html.Br(), html.Br(),
                                        html.Br(), html.Br(), html.Br(), html.Br(), html.Br(),
                                        html.Br(), html.Br(), html.Br(), html.Br(), html.Br(),
                                        html.Br(), html.Br(), html.Br(), html.Br(), html.Br(),
                                        html.H2("Welcome to Mjolnir, the website that can help you visualize your data", className="text")
                                        # visualization_img_input(folder_id, work_dir),
                                    ],
                                ),
                                color="#ffffff",
                                speed_multiplier=2,
                                size=100,
                            ),
                            
                        ],
                    ),
                    # html.Div(
                    #     id='right-column-temp',
                    #     children=[
                    #         html.Div(
                    #             id="output-image",
                    #             children=[
                    #                 # map_output,
                    #             ],
                    #         ),
                    #     ],
                    # ),
                    html.Div(
                            id='right-column-temp',
                            children=[
                                    html.Div(
                                        id="hist", children=[
                                            dcc.Graph(figure=hist, style={"height":"300px"})
                                        ]
                                    ),
                                    html.Div(
                                        id="stats", children=[
                                            dcc.Graph(figure=table, style={"height":"300px"})
                                        ]
                                    )
                            ],
                        ),
                    # html.Div(id ="graph", children=[
                    #     html.Div(
                    #         id='left-column',
                    #         children=[
                    #                 html.Div(
                    #                     id="hist"
                    #                 ),
                    #                 html.Div(
                    #                     id="stats"
                    #                 )
                    #         ],
                    #     ),
                    #     # html.Div(
                    #     #     id='right-column',
                    #     #     children=[
                    #     #             html.Div(
                    #     #                 id="stats"
                    #     #             )
                    #     #     ],
                    #     # ),
                    #     ]
                    # )
                ],
            ),
        html.Div(
            id="footer", children=[
                html.A(html.I(className="fa fa-github", style={"font-size": "24px"}),
            href="https://github.com/GuangyuWangLab2021", target="_blank"),
        
                html.A(html.I(className="fa fa-linkedin-square", style={"font-size": "24px"}),
                    href="https://www.linkedin.com/in/guangyu-wang-27696819b/", target="_blank"),

                html.A(html.I(className="fa fa-twitter", style={"font-size": "24px"}),
                    href="https://twitter.com/Guangyu_Wang01", target="_blank"),
                html.P("©2023 by Wang lab.", className="text")
            ]
        )
        ],
    )


app.layout = app_layout


# upload HE image
@du.callback(
    output=Output('status1', 'children'),
    id='upload-data-image',
)
def callback_upload_image(filenames_upload_image):
    return upload_image(filenames_upload_image, folder_id, work_dir, app_dir)


# @app.callback(
#     Output('input-image', 'children', allow_duplicate=True),
#     Input('visual-input', 'n_clicks'),
#     prevent_initial_call='initial_duplicate'
# )
# def callback_visualize_input_image(n_clicks):
#     if n_clicks:
#         map_input = visualization_img_input(folder_id, work_dir)
#     return html.Div(id="input-image", children=[map_input])


# choose cell or spot data
@app.callback(
    Output('additional-data-box', 'children'),
    Input('spot-cell-option', 'value'),
)
def callback_show_cell_spot_upload(spot_cell_option):
    return show_cell_spot_upload(spot_cell_option, folder_id, work_dir)


# upload aditional data 
@du.callback(
    output=Output('status2', 'children'),
    id='upload-data-addition-spot',
)
def callback_upload_spot_data(filenames_upload_spot_data):
    return upload_spot_data(filenames_upload_spot_data, folder_id, work_dir)


@du.callback(
    output=Output('status3', 'children'),
    id='upload-data-addition-cell',
)
def callback_upload_cell_data(filenames_upload_cell_data):
    return upload_cell_data(filenames_upload_cell_data, folder_id, work_dir)


# choose type of visualization
@app.callback(
    Output('gene-dropdown', 'children'),
    Input('spot-cell-option', 'value'),
    Input('visual-type-container', 'value')
)
def callback_update_output_visual(spot_cell_option, visualize_option):
    return update_output_visual(spot_cell_option, visualize_option, folder_id, work_dir)


# # show cell dectection result
# @app.callback(
#     Output('input-image', 'children', allow_duplicate=True),
#     Input("cell-detection", "n_clicks"),
#     prevent_initial_call='initial_duplicate'
# )
# def callback_show_cell_detection(n_clicks):
#     return show_cell_detection(n_clicks, folder_id, work_dir)


# upload pathway file
@du.callback(
    output=Output('pathway-dropdown', 'children'),
    id="upload-data-pathway"
)
def callback_upload_pathway(filenames_upload_pathway):
    return upload_pathway(filenames_upload_pathway, folder_id, work_dir)


# visualize pathway 
@app.callback(
    Output('input-image', 'children', allow_duplicate=True),
    Input('spot-cell-option', 'value'),
    Input('pathway-input-container', 'value'),
    prevent_initial_call='initial_duplicate'
)
def callback_get_pathway_output(spot_cell_option, pathway_value):
    return get_pathway_output(spot_cell_option, pathway_value, folder_id, work_dir)


# upload cnv file
@du.callback(
    output=Output('status7', 'children'),
    id="upload-data-cnv"
)
def callback_upload_cnv(filenames_upload_cnv):
    return upload_cnv(filenames_upload_cnv, folder_id, work_dir)


# choose gene
@app.callback(
    Output('input-image', 'children', allow_duplicate=True),
    Input('spot-cell-option', 'value'),
    Input('gene-input-container', 'value'),
    prevent_initial_call='initial_duplicate'
)
def callback_get_gene(spot_cell_option, gene_chosen):
    return get_gene(spot_cell_option, gene_chosen, folder_id, work_dir)


# apply vmin vmax
@app.callback(
    Output('input-image', 'children', allow_duplicate=True),
    #Output('status8', 'children', allow_duplicate=True),
    Input('cell-vminmax-button','n_clicks'),
    Input('cell-input-min', 'value'),
    Input('cell-input-max', 'value'),
    prevent_initial_call='initial_duplicate'
)
def callback_cell_vmin_vmax(n_clicks, vmin, vmax):
    changed_id = [p['prop_id'] for p in dash.callback_context.triggered][0]

    if 'n_clicks' in changed_id:
        return cell_vmin_vmax(n_clicks, vmin, vmax, folder_id, work_dir)
    else:
        return dash.exceptions.PreventUpdate


# apply vmin vmax spot
@app.callback(
    Output('input-image', 'children', allow_duplicate=True),
    #Output('status8', 'children', allow_duplicate=True),
    Input('spot-vminmax-button','n_clicks'),
    Input('spot-input-min', 'value'),
    Input('spot-input-max', 'value'),
    prevent_initial_call='initial_duplicate'
)
def callback_spot_vmin_vmax(n_clicks, vmin, vmax):
    changed_id = [p['prop_id'] for p in dash.callback_context.triggered][0]

    if 'n_clicks' in changed_id:
        return spot_vmin_vmax(n_clicks, vmin, vmax, folder_id, work_dir)
    else:
        return dash.exceptions.PreventUpdate


# reset button
@app.callback(
    Output('input-image', 'children', allow_duplicate=True),
    Input("visual-input", "n_clicks"),
    Input('spot-cell-option', 'value'),
    Input('visual-type-container', 'value'),    
    prevent_initial_call='initial_duplicate'
)
def callback_reset(n_clicks, spot_cell_option, visual_type):
    return reset(n_clicks, spot_cell_option, visual_type, folder_id, work_dir)


# save chosen region
@app.callback(
    Output('download', 'data'),
    Input('btn_save', 'n_clicks'),
    prevent_initial_call=True
)
def callback_copy_and_rename_file(n_clicks):
    return copy_and_rename_file(n_clicks, folder_id, work_dir,zip=True)


# get coordinate
@app.callback(
    Output('status5', 'children'),
    Input('editControl', 'geojson'),
    prevent_initial_call=True,
)
def callback_save_roi(drawn_geojson):
    return save_roi(drawn_geojson, folder_id, work_dir)


# plot graph and stats
@app.callback(
    Output('hist', 'children'),
    Output('stats', 'children'),
    Input('editControl', 'geojson'),
    Input('layer-overlay', 'baseLayer'),
    prevent_initial_call=True,
)
def callback_plot_stats(drawn_geojson, gene_chosen):
    return plot_stats(drawn_geojson, gene_chosen, folder_id, work_dir)



# show mouse coordinates with click
@app.callback(
    Output('mouse-position', 'children'),
    Input('map-output', 'clickData'),
)
def callback_show_mouse_position(clickData):
    return show_mouse_position(clickData, folder_id, work_dir)


# save chosen region
@app.callback(
    Output('status8', 'children', allow_duplicate=True),
    Input('btn_find', 'n_clicks'),
    prevent_initial_call='initial_duplicate'
)
def callbackcell_selection_interface(n_clicks):
    return cell_selection_interface(n_clicks, folder_id, work_dir)


# clear cache
@app.callback(
    Output('status6', 'children'),
    Input('clear-cache', 'n_clicks'),
)
def callback_clear_cache_forcall(n_clicks):
    return clear_cache_forcall(n_clicks, folder_id, work_dir, app_dir)


def open_browser():
    if not os.environ.get("WERKZEUG_RUN_MAIN"):
        webbrowser.open_new(f'http://localhost:{args.port}/')
# Run app
if __name__ == "__main__":
    Timer(1, open_browser).start()
    app.run_server(host="localhost", port=args.port, debug=False, dev_tools_hot_reload=True)
