# Mjolnir browser for large images and multi-omics data visualization and analysis

## Installation
Currently, you can install the app and run it locally. We plan to launch a web server, so users don't need to install anything and will be able to upload their data for visualization.

### 1. Create a conda environment.
``conda create -n mjolnir python=3.9``
### 2. Activate the environment.
``conda activate mjolnir``
### 3. Download this repository.
### 4. Install the required dependencies.
- On MacOS (tested) or Linux, run
  ``pip install -r requirements.txt``
  
- On Windows, run
  ``pip install -r requirements-w.txt``

### 5. Install Mjolnir.
``pip install .``

### 6. Launch the webapp locally. Your web browser should automatically open the app after you run the following command.
``python ./mjolnir/app/app.py``

---
## Test dataset
- The ductal_carcinoma_in_stu [dropbox link](https://www.dropbox.com/scl/fi/kz742n3c205zna9v2k3xe/breast_cancer.tar.gz?rlkey=twnd1dpl44vq9g3e7ik2pm7bd&dl=0)

More example data can be downloaded from [google drive](https://drive.google.com/drive/folders/1i68YZSb5jRU0iTxV7sYTNfBqSxNHJnpy?usp=sharing).

---
## Video tutorial
- [Mjolnir: Visualization of gene expression at spot and cell level](https://drive.google.com/file/d/1g_zGoHohbeXP2RFN_AVAhTQqSAKY5qcj/view?usp=sharing)
- [Mjolnir: Visualization of pathway enrichment heatmaps](https://drive.google.com/file/d/1e04zKErfZnXknPB3U7eENIfyq_o-RaBS/view?usp=sharing)
- [Mjolnir: Semi-supervised annotation of cells](https://drive.google.com/file/d/1gZYKZTNUnzS_qd2YZrGEoWd7RYhoIAjd/view?usp=sharing)
