import os
import time
import numpy as np

class Logger:
    def __init__(self, N):
        self.N = N

        dir_path = os.path.dirname(os.path.realpath(__file__))
        #  file_name = '/../../data/surf_line/data_r%d_lineN5N3_s3_%d.txt' % (N, int(time.time()))
        file_name = '/../../data/time_data/data_r%d_%d.txt' % (N, int(time.time()))
        self.fh = open(dir_path + file_name, 'a')
        self.start_time = None
        self.is_end = False

    def write(self, x, u, ref_traj=[], end_time=-1):
        '''
        x: 3N-1 vector, u: 2N-1 vector,
        ref_traj: m-by-N matrix, 
        '''
        N = self.N
        assert(x.shape == (3*N,))
        assert(u.shape == (2*N,))
        if len(ref_traj) > 0:
            # assert(ref_traj.shape == (3*N,))
            assert(ref_traj.shape[1] == N)
        M = ref_traj.shape[0] if len(ref_traj) > 0 else 0
        if self.start_time is None:
            self.start_time = time.time()
        if self.fh.closed:
            return

        # format: robot_id, time, pose 3-1 vec, u 2-1 vec, 
        #         ref_traj 3-1 vec
        curr_time = time.time()
        s = ""
        for i in range(N):
            s += "%d %.5f " % (i, curr_time)
            p = ' '.join(map(str, x[3*i:3*(i+1)]))
            s += p
            s += " %f %f " % (u[2*i], u[2*i+1])
            if M > 0:
                p = ' '.join(map(str, ref_traj[:, i]))
                s += p
            s += "\n"
        self.fh.write(s)

        if ((curr_time - self.start_time) > end_time) and (end_time > 0):
            self.end()

    def end(self):
        self.is_end = True
        self.fh.close()

