import numpy as np

# centralized method 
# from puzzlebot_assembly.robots import Robots, RobotParam
# from puzzlebot_assembly.control import Controller, ControlParam

# decentralized method
from puzzlebot_assembly.dec_robots import Robots, RobotParam
from puzzlebot_assembly.dec_control import Controller, ControlParam

from puzzlebot_assembly.simulation import BulletSim
from puzzlebot_assembly.logging import Logger
from multiprocessing.pool import Pool
from time import time

if __name__ == "__main__":
    dt = 0.15
    eth = 1.5e-3
    start = np.array([
                    [0, 0, 0],
                    [-0.15, 0, 0],
                    [0.15, 0, 0],
                    [-0.3, 0, 0],
                    [0.3, 0, 0],
                    [-0.45, 0, 0],
                    # [0.45, 0, 0],
                    # [0.4, 0.0, 0],
                    # [-0.2, 0.3, 0],
                    # [0.6, 0.5, -0.0],
                    # [-0.1, -0.1, 0],
                    # [1.0, 0.5, 0],
                    # [-0.3, 0.7, 0],
                    # [-0.6, 0.7, 0],
                    # [0.0, 0.6, 0],
                    # [0.5, 0.7, 0]
                    ], dtype=np.float64).T
    N = start.shape[1]
    r_param = RobotParam(L=5e-2, anchor_base_L=9e-3, anchor_L=1.4e-2)
    c_param = ControlParam(vmax=0.05, wmax=1.0,
                    uvmax=1.0, uwmax=1.0,
                    mpc_horizon=5, constr_horizon=2, eth=eth)
    # logger = Logger(N)
    logger = None

    c = Controller(N, dt, c_param, logger=logger)
    pool = Pool()
    rsys = Robots(N, c, pool, eth, robot_param=r_param, pilot_ids=[], 
                    logger=logger)
    sim = BulletSim(N, c_param, c, rsys, is_anchor_separate=False)
    sim.setup(start=start)
    sim.load_urdf(robot_file="urdf/puzzlebot.urdf",
                anchor_file="urdf/puz_anchor.urdf",
                env_file="urdf/plane.urdf")
    sim.start()
    sim.end()
