'''
©2024, Francisco C. Marques, Institute for Biomechanics, ETH Zurich
'''

from readlif.reader import LifFile
from stack_FITC_preprocessing import process_LIF_image, export_threshold_images, compute_matlab_stats

if __name__ == '__main__':
    
    number_of_processes = 2
    threshold_value = 0.5
    
    # Run preprocessing function and export image stacks
    input_file_path = '/path/to/input/file'
    save_path = '/path/to/save/stacks'

    lif_object = LifFile(input_file_path)
    img_stack, img_preprocessed, scaled_img_preprocessed = process_LIF_image(lif_object, number_of_processes=number_of_processes)
    export_threshold_images(scaled_img_preprocessed, save_path, threshold_value=threshold_value)

    # After completing the matlab analysis, conveniently export the results
    # sample_folders = ['list of folders with outputs from matlab']
    # complete_df = compute_matlab_stats(sample_folders)
    # csv_name = 'save_file_name.csv'
    # complete_df.to_csv(csv_name, index=False)