'''
©2024, Francisco C. Marques, Institute for Biomechanics, ETH Zurich
'''

from readlif.reader import LifFile
from stack_FITC_preprocessing import process_LIF_image, export_threshold_images, compute_matlab_stats

if __name__ == '__main__':
    
    number_of_processes = 2
    threshold_value = 0.5
    
    # DEMO DATA (Runtime: 27 seconds on 42 core CPU, 2min30s on 2 cores)
    img_path = 'data/DemoData.lif'
    img_stack, img_preprocessed, scaled_img_preprocessed = process_LIF_image(LifFile(img_path), number_of_processes=number_of_processes)
    export_threshold_images(scaled_img_preprocessed, 'data', threshold_value=threshold_value)