# Osteocyte Connectomics Image Preprocessing

![License](https://img.shields.io/gitlab/license/ifb/ocy_connectomics_preprocessing)

## Description

The **Osteocyte Connectomics Image Preprocessing** repository provides a set of Python scripts to preprocess confocal images, enhancing the details of the lacuno-canalicular network. The preprocessing step improves image quality, making it easier to analyze the network using the MATLAB tools available at [ocy_connectomics_updated](https://github.com/cschurm/ocy_connectomics_updated), from the paper __"Disrupted Osteocyte Connectivity and Pericellular Fluid Flow in Bone with Aging and Defective TGFb Signaling"__ by Schurman et. al. (https://www.pnas.org/content/118/25/e2023999118/tab-article-info), which are an updated version of the original pipeline (https://github.com/phi-max/OCY_connectomics).

![Example of workflow pipeline](assets/LCN_Pipeline.jpg)

The repository includes a script file with functions and a Jupyter notebook that demonstrates an example workflow. These methods were developed for the analysis presented in the following paper:

ADD CITATION HERE WHEN AVAILABLE

## Key Features

- Convenient functions to improve image quality and enhance osteocyte network details prior to thresholding.
- Python scripts and a Jupyter notebook for easy usage.

## Installation

To use the **Osteocyte Connectomics Image Preprocessing** scripts, you need to have the following dependencies installed:

- `python==3.11.6`
- `Pillow==10.2.0`
- `readlif==0.6.5`
- `h5py==3.10.0`
- `numpy==1.26.4`
- `pandas==2.2.0`
- `tqdm==4.66.1`
- `scipy==1.12.0`
- `scikit-image==0.22.0`

Additionally, to run the interactive widget on the jupyter notebook, the following packages are needed:

- `ipywidgets==8.1.1`
- `matplotlib==3.8.2`

The versions indicated correspond to the package versions we used. You can install these dependencies in a few minutes using `pip`, after creating a virtual environment:

```shell
python3 -m venv ocy_venv
source ocy_venv/bin/activate
pip install Pillow==10.2.0 readlif==0.6.5 h5py==3.10.0 numpy==1.26.4 pandas==2.2.0 tqdm==4.66.1 scipy==1.12.0 scikit-image==0.22.0
pip install ipywidgets==8.1.1 matplotlib==3.8.2
```

After installing the packages, you can run the example:
```shell
cd ocy_connectomics_preprocessing
python3 demo_workflow_FITC_preprocessing.py
```

## Usage

The repository provides a Jupyter notebook (`workflow_FITC_preprocessing.ipynb`) that demonstrates the entire preprocessing pipeline. The notebook showcases how to run the scripts and apply the preprocessing steps to your confocal images, export the image stacks and organise the outputs produced by the MATLAB analysis in a convenient pandas DataFrame.

The preprocessing script expects a LIF file as input and will create a folder inside the `save_path` provided with the name of the input image. Inside, one `.tiff` file for each section of the z-stack will be exported. This folder can be provided as input for the `OCY_connectomics` analysis in MATLAB, which will generate the output of the analysis inside it (**NOTE**: it is necessary to deactivate the filtering and thresholding operations in the MATLAB script since the input images will be already in binary format).

The analysis has been tested on Fedora 37 (`6.5.12-100`, `x86_64`), running on Intel(R) Xeon(R) Platinum 8168 CPU (2.70GHz). For an image of 60 stacks with dimensions `(560, 560)`, the preprocessing analysis takes approximately 25 seconds, running on 42 cores or 2 minutes and 30 seconds on 2 cores.

## License

This project is licensed under the BSD-3-Clause license.


## Acknowledgements

If you find this work useful, please consider citing:

ADD FORMATTED CITATION BIBTEX WHEN AVAILABLE

as well as the developers of the original [OCY_connectomics](https://github.com/phi-max/OCY_connectomics) analysis.
