#pragma once

#include <iostream>
#include <random>

class UniformDistribution
{
public:
    UniformDistribution(float min, float max, unsigned int seed)
        : min_(min), max_(max)
    {
        std::random_device rd;
        gen_ = std::mt19937(seed);
        distribution_ = std::uniform_real_distribution<float>(min_, max_);
    }

    float getValue()
    {
        return distribution_(gen_);
    }

private:
    float min_;
    float max_;
    std::mt19937 gen_;
    std::uniform_real_distribution<float> distribution_;
};
