#pragma once

#include <string>
#include <iostream>
#include <iomanip>

struct simulation_t
{
    float Rc_multiplicator, totalTime, deltaTime, outputScale, temperature, overlapDistance, Rmax, Rc, Rl, secureDistance, eta, dielectricConstant, density;
    std::string outputDir, distribution, restartFile;
    int nbrIteration, listSize, saveSecure, savePrecision, savePeriod, maxListSize, restartSaveInterval, nbrColloids, randomSeedPosition;
    float3 gridSize;
    int3 cellPerAxis;
};

struct particles_t
{
    int type, number;
    float psi, minRadius, maxRadius, radius, std_dev, volumicMass;
    std::string distribution;
};

struct grid_t
{
    int nbCells;
    int cellPerAxis;
    float Rl, Rc, cellSize, size;
    void print(std::string name)
    {
        std::cout << "Grid " << name << "\n";
        std::cout << "    Size: " << std::scientific << size << "\n";
        std::cout << "    Number of cells: " << nbCells << "\n";
        std::cout << "    Rc: " << std::scientific << Rc << "\n";
        std::cout << "    Rl: " << std::scientific << Rl << "\n";
        std::cout << "    cellSize: " << std::scientific << cellSize << "\n";
        std::cout << "    cellPerAxis: " << std::scientific << cellPerAxis << "\n";
    }
};

struct particle
{
    double3 p;
    float r;
    int t;
};
