#pragma once

#include <cmath>
#include <cuda_runtime.h>

#include "myTimer.h"

#define maxOptSteps 100

class optimizer
{
public:
    const int toTest[10] = {32, 64, 96, 128, 256, 384, 512, 768, 1024, 2048};
    int current;
    int max;
    int count;
    bool done;
    double times[10] = {0.0};

    optimizer(int maxValue, bool on)
    {
        max = maxValue;
        done = false;
        current = 0;
        count = 0;
        if (!on)
        {
            current = 0;
            done = true;
            std::cout << "No opt\n";
        }
    }

    int getThreads()
    {
        return toTest[current];
    }

    void updateTimming(double dt)
    {
        if (!done)
        {
            count++;
            times[current] += dt;

            if (count == maxOptSteps)
            {
                count = 0;
                current++;
            }

            if (current == 10 || toTest[current] > max)
            {
                done = true;
                int best = 0;
                double time = times[0];

                for (int i = 0; i < 10; i++)
                {
                    if (time > times[i] && times[i] != 0.0)
                    {
                        best = i;
                        time = times[i];
                    }
                }
                current = best;
            }
        }
    }
};
