#pragma once

#include <iostream>
#include <random>
#include <cmath>
#include <cfloat>

class NormalDistribution
{
public:
    NormalDistribution(float mean, float stddev, float min, float max, int seed)
        : mean_(mean), stddev_(stddev), min_(min), max_(max)
    {
        std::random_device rd;
        gen_ = std::mt19937(seed);
        if (min_ >= max_)
        {
            std::cerr << "Error: Invalid range [min, max]." << std::endl;
        }
        distribution_ = std::normal_distribution<float>(mean_, stddev_);
        if (min_ == 0.0f)
            min_ = FLT_MIN;
        if (max_ == 0.0f)
            max_ = FLT_MAX;
    }

    float getValue()
    {
        float v;
        // bool cond;
        do
        {
            v = distribution_(gen_);
        } while (v < min_ || v > max_);
        return v;
    }

private:
    float mean_;
    float stddev_;
    float min_;
    float max_;
    std::mt19937 gen_;
    std::normal_distribution<float> distribution_;
};
