#pragma once

#include <cstdint>
#include <chrono>
#include <vector>
#include <string>
#include <iostream>

class myTimer
{
public:
  double total_time, calls;
  double last;
  bool autoreset;
  double cond;
  std::string name;
  std::chrono::time_point<std::chrono::high_resolution_clock> start_time, end_time;
  myTimer(std::string Name, bool reset, int nbr) : total_time(0), calls(0), name(Name), cond(nbr), autoreset(reset){};

  inline void reset()
  {
    total_time = 0;
    calls = 0;
  }

  inline void start()
  {
    start_time = std::chrono::high_resolution_clock::now();
    calls++;
  };

  inline void stop()
  {
    end_time = std::chrono::high_resolution_clock::now();
    auto elapsed = std::chrono::duration_cast<std::chrono::nanoseconds>(end_time - start_time).count();
    total_time += static_cast<double>(elapsed);
    last = static_cast<double>(elapsed);
    if (this->autoreset)
    {
      if (calls == cond)
      {
        std::cout << this->name << " mean over " << this->cond << " times " << this->getAvgTime() * 1e-6 << " ms\n";
        this->reset();
      }
    }
  };

  inline void print()
  {
    std::cout << this->name << " mean over " << this->calls << " times " << this->getAvgTime() * 1e-6 << " ms\n";
    reset();
  }

  // return latency in ms
  inline double instantTime()
  {
    return total_time;
  };

  // return latency in ms
  inline double getAvgTime()
  {
    return (total_time / double(calls));
  };

  inline double getLast()
  {
    return last;
  };
};
