#pragma once

#include <iostream>
#include <random>
#include <cmath>

class LognormalDistribution
{
public:
    LognormalDistribution(float mean, float stddev, float min, float max, int seed)
        : mean_(mean), stddev_(stddev), min_(min), max_(max)
    {
        std::random_device rd;
        gen_ = std::mt19937(seed);
        if (min_ == 0.0f)
            min_ = FLT_MIN;
        if (max_ == 0.0f)
            max_ = FLT_MAX;
        distribution_ = std::lognormal_distribution<float>(mean_, stddev_);
    }

    float getValue()
    {
        float random_number;
        do
        {
            random_number = distribution_(gen_);
        } while (random_number < min_ || random_number > max_);
        return random_number;
    }

private:
    float mean_;
    float stddev_;
    float min_;
    float max_;
    std::mt19937 gen_;
    std::lognormal_distribution<float> distribution_;
};
