#pragma once

#include <curand.h>
#include <curand_kernel.h>

#include <thrust/device_ptr.h>

#include "structs.hpp"
#include "myTimer.h"
#include "optimizer.hpp"
#include "ForcesDescription/forces.hpp"

class SimulatorMultiPart
{
public:
	void saveBin(std::string path);
	void readBin(std::string path);
	myTimer *opttimer;
	std::vector<particles_t> Parts;
	simulation_t cpuSim;
	grid_t grid;
	int *id, *id_s, *tid, *nlist, *counters, pcount, nbCell, listSize, saveCount, *cellp;
	uint64_t *hash;
	float verletSecure;
	double3 *forceSum, *randomsV3;
	float3 *move;
	int2 *grids;
	curandState *rndBro;
	long int currentStep;
	float time, fluctuatingForceFactor, factorSumForce;
	thrust::device_ptr<uint64_t> dev_hash;
	thrust::device_ptr<int> dev_tid;
	bool *update;
	int bestMcpyDvec3, bestFindCell, bestToFill, bestMcpyInt, bestMcpyfloat, bestMenSetint, bestMenSetvec3, bestMenSetdvec3, bestMcpyfloat3, bestCalcHash, bestRandom;
	float *psis;
	particle *parts, *parts_s, *verletParts;
	SimulatorMultiPart(simulation_t mySim, std::vector<particles_t> myParticles, std::vector<Yukawa> Yukawas, std::vector<Lennard_Jones> Lennard_Joness, std::vector<DLVO> DLVOs);
	std::vector<Yukawa> Yukawas;
	std::vector<Lennard_Jones> Lennard_Joness;
	std::vector<DLVO> DLVOs;

	int gridRebuildCount, simIt;
	float getRc();
	float genRadius();
	void initPositions();
	void computeNext();
	void updateGrid();
	void initPbuffers();
	float getMaxRadius();
	float computeVolume();
	void save();
	void fillPsis();
	void readXYZ(std::string path);
	std::vector<optimizer> optimizers;
};
