#pragma once

#include <cmath>

#include <json.hpp>

#include "../../Commons/Physics.h"
#include "../../Commons/utilityKernel.cuh"

typedef struct
{
    float Rc;
    float k;
    float U;
    float rcrep;
    float coeffdir;
    int second;
    int first;
    float pot;

} Yukawa_t;

class Yukawa
{
public:
    Yukawa_t data;

    void init(nlohmann::json js, float temperature)
    {
        cudaMallocManaged((void **)&data, sizeof(Yukawa_t));
        data.Rc = js["Rc"];
        data.k = js["k"];
        data.U = js["U"];
        data.rcrep = js["rcrep"];
        data.coeffdir = js["coeffdir"];
        data.second = js["second"];
        data.first = js["first"];

        data.pot = Constant::kb * temperature * data.U;
    }

    inline __device__ double3 compute(const float r0, const float r1, const double dist, const double3 diff_p_pn, const float psii, const float psij)
    {
        const double a = (r0 + r1);
        if (dist > data.rcrep * a)
        {
            const float k = data.k;
            const double tmp = data.pot * psii * psij * 2 * a * (k * dist + 1) / (dist * dist) * exp(k * (dist - 2 * a)) / dist;
            return diff_p_pn * tmp;
        }
        else
        {
            return diff_p_pn * data.coeffdir / dist;
        }
        return make_double3(0, 0, 0);
    }
    ~Yukawa()
    {
    }
};
