#pragma once

#include <cmath>

#include <json.hpp>

#include "../../Commons/Physics.h"
#include "../../Commons/utilityKernel.cuh"

typedef struct
{
    float Rc;
    float well;
    int n;
    int second;
    int first;
    float pot;

} Lennard_Jones_t;

class Lennard_Jones
{
public:
    Lennard_Jones_t data;

    void init(nlohmann::json js, float temperature)
    {
        cudaMallocManaged((void **)&data, sizeof(Lennard_Jones_t));
        data.Rc = js["Rc"];
        data.well = js["well"];
        data.n = js["n"];
        data.second = js["second"];
        data.first = js["first"];

        data.pot = 4 * data.n * data.well * Constant::kb * temperature;
    }

    inline __device__ double3 compute(const float r0, const float r1, const double dist, const double3 diff_p_pn, const float psii, const float psij)
    {
        const double r = r0 + r1;
        const double p = power(r / dist, data.n);
        double3 res = diff_p_pn * data.pot * p / dist / dist * (2 * p - 1);
        return res;
    }
    ~Lennard_Jones()
    {
    }
};
