#include <sstream>
#include <regex>

#include "filesUtils.hpp"

bool is_file_exist(const char *fileName)
{
    std::ifstream infile(fileName);
    // std::cout<<"Path:"<<fileName<<"\n";
    return infile.good();
}

// This function get the list of all files of a directory according to a reg exp
std::vector<std::string> globVector(const std::string &pattern)
{
    std::vector<std::string> files;
#ifdef _MSC_VER
    std::vector<std::filesystem::path> pat = glob::glob(pattern);
    for (int i = 0; i < pat.size(); i++)
    {
        files.push_back(std::string(pat[i].u8string()));
    }
#else
    glob_t glob_result;
    glob(pattern.c_str(), GLOB_TILDE, NULL, &glob_result);
    for (unsigned int i = 0; i < glob_result.gl_pathc; ++i)
    {
        files.push_back(std::string(glob_result.gl_pathv[i]));
    }
    globfree(&glob_result);
#endif
    std::sort(files.begin(), files.end());
    return files;
}
