#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include <cuda_runtime.h>
#include <cuda.h>
#include <math.h>

#include <thrust/sort.h>
#include <thrust/execution_policy.h>
#include <thrust/device_ptr.h>

#include "fileManage.hpp"
#include "filesUtils.hpp"

bool logSave(long int nb)
{
    double t = log10(nb);
    int tt = int(t);
    long int ttt = int(pow(10, tt)) / 4; /// /2
    if (ttt == 0)
        ttt = 1;
    long int zero = 0;
    long int tmp = nb / ttt;
    bool res = tmp == 0;
    return nb % ttt == 0;
}

bool linearSave(long int nb, int interval)
{
    return nb % (long int)interval == 0;
}

std::string format_account_number(long int acct_no)
{
    char buffer[15];
    std::snprintf(buffer, sizeof(buffer), "%08ld", acct_no);
    return buffer;
}

float readXYZ(std::string path, double scale, double &time, double3 *pos, float *radius, int *type, int *gid, long int &iteration)
{
    std::ifstream infile(path.c_str());
    if (!infile.good())
    {
        std::cout << "Cant open :" << path << " Exiting..." << std::endl;
        exit(0);
    }
    std::ifstream file(path.c_str(), std::ios::binary | std::ios::in);
    std::string line;
    std::getline(file, line);
    std::getline(file, line);
    std::istringstream iss0(line);
    std::string word;
    iss0 >> time;
    iss0 >> iteration;
    float size;
    iss0 >> size;
    iss0 >> size;
    int toRecycle2;
    unsigned int partCounter = 0;
    while (std::getline(file, line))
    {
        std::istringstream iss(line);
        if (!(iss >> gid[partCounter] >> type[partCounter] >> pos[partCounter].x >> pos[partCounter].y >> pos[partCounter].z >> toRecycle2 >> radius[partCounter]))
        {
            std::cout << "Error durring loading .XYZ" << std::endl;
            exit(0);
        }
        pos[partCounter].x /= scale;
        pos[partCounter].y /= scale;
        pos[partCounter].z /= scale;
        radius[partCounter] /= scale;
        partCounter++;
    }
    return size / scale;
}

void writeXYZCluster(int saveNbr, std::string outDir, std::string subpath, long int iteration, double scale, float gridsize, int nbr, double3 *pos, float *radius, int *type, int *gid, int *clusters, int savePrecision, float deltaTime)
{
    std::string path = outDir + subpath + format_account_number(saveNbr) + ".xyz";
    std::ofstream logfile(path, std::ios::out | std::ios::binary);
    if (logfile.is_open())
    {
        char position[300];
        char nb_particle_string[15];
        sprintf(nb_particle_string, "%d", nbr);
        logfile << nb_particle_string << "\n";
        // logfile << "Lattice=\""<<gridsize.x*scale<<" 0.0 0.0 0.0 "<<gridsize.y*scale<<" 0.0 0.0 0.0 "<<gridsize.z*scale<<"\" Origine=\"0.0 0.0 0.0\" scale="<<scale<<" time="<<iteration*deltaTime<<" Properties=species:I:1:pos:R:3:cluster:I:1:radius:R:1\n";
        logfile << deltaTime * iteration << " " << iteration << " " << gridsize * scale << "\n";

        for (int i = 0; i < nbr; i++)
        {
            logfile << gid[i] << " " << type[i] << " ";
            sprintf(position, "%.*e %.*e %.*e %d %.*e", savePrecision, pos[i].x * scale, savePrecision, pos[i].y * scale, savePrecision, pos[i].z * scale, clusters[i], savePrecision, radius[i] * scale);
            logfile << position << "\n";
        }
        logfile.close();
    }
    else
    {
        std::cout << "Error : Impossible to write " << path << "\n";
        exit(0);
    }
}
