#!/usr/bin/python3
import sys
import os.path
import json
import subprocess
import glob
import matplotlib.pyplot as plt
import csv
import os

#Plot Radial distribution function
def makeRDFPlot(x,y,name):
	fig, ax = plt.subplots()
	ax.plot(x, y, color = 'g',label = "Radial Distribution Function")
	ax.set(xlabel='Pair Separation Distance',ylabel ='g(r)')
	ax.grid()
	ax.legend()
	fig.savefig(name+".pdf")
	# close to avoid memory warning and quit
	plt.close(fig)

def changeSDIR(f, newp):
	s =os.path.split(f)
	s2 = os.path.split(s[0])
	return s2[0]+newp+s[1]

def makeCCPlot2(x,y,name):
	fig, ax = plt.subplots()
	ax.plot(x, y, color = 'g',label = "Cluster Count")
	ax.set(xlabel='Time',ylabel ='number of clusters')
	ax.grid()
	ax.legend()
	ax.set_xscale('log')
	fig.savefig(name+".pdf")
	# close to avoid memory warning and quit
	plt.close(fig)

def makeCCPlot(x,y,name):
	fig, ax = plt.subplots()
	ax.bar(x, y, width = 1,color = 'g',label = "Clusters")
	ax.set(xlabel='Cluster count',ylabel ='Cluster Size')
	ax.grid()
	ax.legend()
	ax.set(xlim = [0,len(x)])
	ax.set(yscale =  "log")
	fig.savefig(name+".pdf")
	plt.close(fig)

#test if a config file is given
if(len(sys.argv)==1):
	print("No config file given!")
	quit()
#Try to read the config file
fname = sys.argv[1]
if(not os.path.isfile(fname)):
	print("Cant read ",fname,"!")
	quit()
#Read th path of simulation file
with open(fname) as json_file:
	data = json.load(json_file)
	simFolder = data["SIMULATION"]["outputDir"]
#Is the simulation folder exists?
if(not os.path.isdir(simFolder)):
	print("Impossible to find the simulation folder:",simFolder)
	quit()
#make sub directory for analysis
if(not os.path.isdir(simFolder+"/Analysis/")):
	os.mkdir(simFolder+"/Analysis/")

if(not os.path.isdir(simFolder+"/Graphs/")):
	os.mkdir(simFolder+"/Graphs/")


print("Preparing folders for analysis... Done")
print("Launching analysis!")
#Launch the analysis exec
subprocess.call(["./analyse "+fname],shell=True)
print("Analysis done.")
#Concatenate all the simulation XYZ in one file
files = glob.glob(simFolder+"/Analysis/"+"*.xyz")
total = ""
for f in files:
	text_file = open(f, "r")
	data = text_file.read()
	total = total+data
	text_file.close()

print("Plot clusters distribution!")

# Plot clusters distribution for each simulation file
print("Plot clusters count evolution")
filelist = glob.glob(simFolder+"/*cluster*.csv")
if(len(filelist)==0):
	quit()

x = []
y = []

with open(filelist[0],'r') as csvfile:
	lines = csv.reader(csvfile, delimiter=',')
	count = 0
	for row in lines:
		if count!= 0:
			x.append(float(row[0]))
			y.append(float(row[1]))
		count = count+1
	makeCCPlot2(x,y,filelist[0])