# 
#         vikO
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.30979, 0.1009, 0.23843],      
           [0.30692, 0.10306, 0.24318],      
           [0.30406, 0.10526, 0.24805],      
           [0.30121, 0.10764, 0.25296],      
           [0.29836, 0.11017, 0.25796],      
           [0.29551, 0.11276, 0.26307],      
           [0.29265, 0.11545, 0.26825],      
           [0.2898, 0.11832, 0.27354],      
           [0.28692, 0.12122, 0.27891],      
           [0.28406, 0.12431, 0.28434],      
           [0.28118, 0.12753, 0.28989],      
           [0.2783, 0.13089, 0.29552],      
           [0.27542, 0.13435, 0.30123],      
           [0.27249, 0.13793, 0.30704],      
           [0.2696, 0.14163, 0.31293],      
           [0.26666, 0.14548, 0.3189],      
           [0.26374, 0.14942, 0.32495],      
           [0.26079, 0.15348, 0.33107],      
           [0.25783, 0.15771, 0.33729],      
           [0.25491, 0.16208, 0.34356],      
           [0.25194, 0.16655, 0.34991],      
           [0.24899, 0.17114, 0.35633],      
           [0.24602, 0.17586, 0.36279],      
           [0.24308, 0.18073, 0.36931],      
           [0.24015, 0.18575, 0.37589],      
           [0.23728, 0.19084, 0.38251],      
           [0.23439, 0.19609, 0.38918],      
           [0.23155, 0.20143, 0.39588],      
           [0.22875, 0.20694, 0.40259],      
           [0.226, 0.21253, 0.40935],      
           [0.22331, 0.21825, 0.41612],      
           [0.22071, 0.22406, 0.42289],      
           [0.21817, 0.23, 0.42969],      
           [0.21576, 0.23608, 0.43648],      
           [0.21343, 0.24222, 0.44326],      
           [0.21128, 0.24849, 0.45004],      
           [0.20925, 0.25484, 0.4568],      
           [0.20741, 0.26127, 0.46354],      
           [0.20574, 0.26779, 0.47026],      
           [0.20429, 0.27443, 0.47695],      
           [0.20303, 0.28113, 0.48361],      
           [0.20203, 0.28792, 0.49024],      
           [0.20129, 0.29478, 0.49683],      
           [0.20083, 0.30171, 0.50338],      
           [0.20067, 0.30874, 0.50989],      
           [0.20082, 0.31581, 0.51636],      
           [0.2013, 0.32294, 0.52278],      
           [0.20213, 0.33012, 0.52917],      
           [0.20331, 0.33737, 0.53549],      
           [0.20484, 0.34466, 0.54177],      
           [0.20676, 0.35201, 0.54801],      
           [0.209, 0.35941, 0.5542],      
           [0.21166, 0.36686, 0.56035],      
           [0.21466, 0.37435, 0.56644],      
           [0.21806, 0.38186, 0.57249],      
           [0.22181, 0.38942, 0.57849],      
           [0.22595, 0.39701, 0.58446],      
           [0.2304, 0.40464, 0.59037],      
           [0.23526, 0.41231, 0.59625],      
           [0.24039, 0.41999, 0.60208],      
           [0.24588, 0.42771, 0.60787],      
           [0.25172, 0.43544, 0.61361],      
           [0.25782, 0.44319, 0.61933],      
           [0.26424, 0.45096, 0.62499],      
           [0.27094, 0.45875, 0.63062],      
           [0.27791, 0.46655, 0.6362],      
           [0.28513, 0.47436, 0.64173],      
           [0.29262, 0.48218, 0.64724],      
           [0.30034, 0.48999, 0.65269],      
           [0.30829, 0.49783, 0.65811],      
           [0.31647, 0.50564, 0.66348],      
           [0.32484, 0.51347, 0.66879],      
           [0.33343, 0.52127, 0.67406],      
           [0.3422, 0.52908, 0.67927],      
           [0.35115, 0.53686, 0.68443],      
           [0.36026, 0.54462, 0.68955],      
           [0.36956, 0.55236, 0.69458],      
           [0.37901, 0.56007, 0.69956],      
           [0.38861, 0.56775, 0.70447],      
           [0.39834, 0.57539, 0.70931],      
           [0.40821, 0.58298, 0.71406],      
           [0.4182, 0.59053, 0.71873],      
           [0.42832, 0.59803, 0.72331],      
           [0.43853, 0.60546, 0.7278],      
           [0.44887, 0.61283, 0.73218],      
           [0.45928, 0.62014, 0.73644],      
           [0.46979, 0.62734, 0.7406],      
           [0.48036, 0.63448, 0.74462],      
           [0.49102, 0.6415, 0.74851],      
           [0.50172, 0.64843, 0.75226],      
           [0.51247, 0.65525, 0.75586],      
           [0.52327, 0.66195, 0.75929],      
           [0.53409, 0.66852, 0.76256],      
           [0.54494, 0.67495, 0.76565],      
           [0.55578, 0.68123, 0.76854],      
           [0.56664, 0.68736, 0.77124],      
           [0.57747, 0.69332, 0.77372],      
           [0.58828, 0.6991, 0.77598],      
           [0.59905, 0.7047, 0.77802],      
           [0.60976, 0.7101, 0.77981],      
           [0.62041, 0.71529, 0.78135],      
           [0.63096, 0.72026, 0.78263],      
           [0.64142, 0.72501, 0.78364],      
           [0.65177, 0.72951, 0.78438],      
           [0.662, 0.73377, 0.78482],      
           [0.67207, 0.73776, 0.78496],      
           [0.68198, 0.74149, 0.78481],      
           [0.69173, 0.74495, 0.78434],      
           [0.70129, 0.74812, 0.78356],      
           [0.71064, 0.751, 0.78246],      
           [0.71977, 0.75357, 0.78103],      
           [0.72866, 0.75584, 0.77928],      
           [0.7373, 0.75781, 0.7772],      
           [0.74568, 0.75945, 0.77478],      
           [0.75379, 0.76078, 0.77204],      
           [0.76161, 0.76178, 0.76897],      
           [0.76913, 0.76246, 0.76558],      
           [0.77635, 0.76282, 0.76186],      
           [0.78325, 0.76286, 0.75783],      
           [0.78982, 0.76257, 0.75349],      
           [0.79607, 0.76197, 0.74884],      
           [0.80198, 0.76105, 0.7439],      
           [0.80756, 0.75982, 0.73867],      
           [0.81279, 0.75829, 0.73316],      
           [0.81768, 0.75645, 0.72738],      
           [0.82224, 0.75433, 0.72135],      
           [0.82645, 0.75191, 0.71507],      
           [0.83032, 0.74922, 0.70856],      
           [0.83386, 0.74627, 0.70181],      
           [0.83707, 0.74306, 0.69486],      
           [0.83996, 0.7396, 0.68771],      
           [0.84252, 0.73588, 0.68036],      
           [0.84477, 0.73195, 0.67285],      
           [0.84672, 0.72779, 0.66516],      
           [0.84838, 0.72343, 0.65733],      
           [0.84974, 0.71887, 0.64934],      
           [0.85082, 0.71411, 0.64122],      
           [0.85164, 0.70918, 0.63299],      
           [0.8522, 0.70406, 0.62464],      
           [0.8525, 0.69879, 0.61619],      
           [0.85256, 0.69337, 0.60765],      
           [0.85238, 0.68779, 0.59901],      
           [0.85198, 0.68208, 0.5903],      
           [0.85135, 0.67624, 0.58153],      
           [0.85052, 0.67028, 0.5727],      
           [0.8495, 0.66419, 0.56381],      
           [0.84827, 0.65799, 0.55487],      
           [0.84686, 0.65169, 0.54589],      
           [0.84527, 0.64528, 0.53688],      
           [0.8435, 0.63879, 0.52782],      
           [0.84157, 0.6322, 0.51875],      
           [0.83948, 0.62552, 0.50965],      
           [0.83723, 0.61876, 0.50053],      
           [0.83482, 0.61191, 0.49142],      
           [0.83226, 0.60499, 0.48228],      
           [0.82956, 0.59798, 0.47312],      
           [0.82672, 0.59091, 0.46399],      
           [0.82372, 0.58376, 0.45485],      
           [0.8206, 0.57655, 0.4457],      
           [0.81733, 0.56924, 0.43657],      
           [0.81392, 0.56189, 0.42746],      
           [0.81038, 0.55445, 0.41834],      
           [0.80671, 0.54695, 0.40925],      
           [0.80289, 0.53937, 0.40018],      
           [0.79894, 0.53172, 0.39114],      
           [0.79485, 0.52401, 0.38211],      
           [0.79062, 0.51622, 0.37312],      
           [0.78625, 0.50837, 0.36416],      
           [0.78173, 0.50043, 0.35526],      
           [0.77707, 0.49243, 0.34637],      
           [0.77227, 0.48436, 0.33755],      
           [0.76731, 0.47623, 0.32878],      
           [0.76221, 0.46802, 0.32008],      
           [0.75697, 0.45974, 0.31141],      
           [0.75157, 0.4514, 0.30283],      
           [0.74602, 0.443, 0.29434],      
           [0.74032, 0.43452, 0.28593],      
           [0.73447, 0.42599, 0.27763],      
           [0.72846, 0.41741, 0.26943],      
           [0.72231, 0.40876, 0.26133],      
           [0.71602, 0.40008, 0.25336],      
           [0.70958, 0.39136, 0.24551],      
           [0.703, 0.38259, 0.23784],      
           [0.69628, 0.37381, 0.23028],      
           [0.68944, 0.36499, 0.22293],      
           [0.68246, 0.35617, 0.21574],      
           [0.67538, 0.34735, 0.20873],      
           [0.66819, 0.33852, 0.20192],      
           [0.66089, 0.32973, 0.19535],      
           [0.6535, 0.32095, 0.189],      
           [0.64604, 0.31219, 0.18286],      
           [0.6385, 0.30351, 0.177],      
           [0.63092, 0.29488, 0.17138],      
           [0.62328, 0.28632, 0.16602],      
           [0.6156, 0.27787, 0.16097],      
           [0.60792, 0.2695, 0.15619],      
           [0.60022, 0.26122, 0.15165],      
           [0.59253, 0.25308, 0.14746],      
           [0.58486, 0.24505, 0.14353],      
           [0.57721, 0.23721, 0.13988],      
           [0.56961, 0.22946, 0.13656],      
           [0.56209, 0.2219, 0.13356],      
           [0.55461, 0.21451, 0.13084],      
           [0.54721, 0.20731, 0.12838],      
           [0.5399, 0.20025, 0.12623],      
           [0.5327, 0.19344, 0.12431],      
           [0.5256, 0.18679, 0.12269],      
           [0.51862, 0.18034, 0.12135],      
           [0.51174, 0.17413, 0.12028],      
           [0.505, 0.16809, 0.11946],      
           [0.49839, 0.16231, 0.11889],      
           [0.49191, 0.15672, 0.11853],      
           [0.48556, 0.15132, 0.11838],      
           [0.47937, 0.14618, 0.11844],      
           [0.47329, 0.14126, 0.1187],      
           [0.46739, 0.1365, 0.11913],      
           [0.46161, 0.13203, 0.11974],      
           [0.45597, 0.12774, 0.12054],      
           [0.45047, 0.12364, 0.1215],      
           [0.44511, 0.1198, 0.12263],      
           [0.43989, 0.1162, 0.12393],      
           [0.43479, 0.11277, 0.12538],      
           [0.42983, 0.10956, 0.12692],      
           [0.425, 0.10654, 0.12863],      
           [0.42027, 0.10371, 0.13049],      
           [0.41568, 0.10106, 0.13241],      
           [0.4112, 0.098655, 0.13449],      
           [0.40683, 0.096378, 0.13662],      
           [0.40256, 0.09442, 0.1389],      
           [0.3984, 0.092523, 0.14132],      
           [0.39433, 0.090892, 0.14379],      
           [0.39036, 0.089396, 0.14636],      
           [0.38647, 0.08809, 0.14904],      
           [0.38268, 0.086971, 0.1518],      
           [0.37896, 0.085915, 0.15466],      
           [0.37531, 0.085142, 0.15761],      
           [0.37174, 0.084549, 0.16064],      
           [0.36825, 0.08407, 0.1638],      
           [0.3648, 0.083717, 0.167],      
           [0.36142, 0.083521, 0.17027],      
           [0.3581, 0.083485, 0.17363],      
           [0.35484, 0.083605, 0.17709],      
           [0.3516, 0.083878, 0.1806],      
           [0.34843, 0.084281, 0.18422],      
           [0.34529, 0.084781, 0.18793],      
           [0.34219, 0.085387, 0.19167],      
           [0.33913, 0.086179, 0.19552],      
           [0.33609, 0.087176, 0.19943],      
           [0.3331, 0.08819, 0.20346],      
           [0.33012, 0.089356, 0.20755],      
           [0.32715, 0.090652, 0.21172],      
           [0.32422, 0.092078, 0.21597],      
           [0.32131, 0.093564, 0.22031],      
           [0.31841, 0.095269, 0.22468],      
           [0.31553, 0.096976, 0.2292],      
           [0.31264, 0.098899, 0.23377]]      
      
vikO_map = LinearSegmentedColormap.from_list('vikO', cm_data)      
# For use of "viscm view"      
test_cm = vikO_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(vikO_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=vikO_map)      
    plt.show()      
