# 
#         vik
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.0013282, 0.069836, 0.37953],      
           [0.0023664, 0.076475, 0.38352],      
           [0.0033042, 0.083083, 0.38749],      
           [0.0041459, 0.08959, 0.39148],      
           [0.0048968, 0.095948, 0.39545],      
           [0.0055632, 0.10227, 0.39941],      
           [0.0061512, 0.1085, 0.40339],      
           [0.0066676, 0.11469, 0.40734],      
           [0.0071192, 0.12085, 0.41129],      
           [0.0075116, 0.12696, 0.41523],      
           [0.0078503, 0.13307, 0.41917],      
           [0.0081413, 0.13909, 0.42308],      
           [0.0083912, 0.14517, 0.42701],      
           [0.0086057, 0.15114, 0.43091],      
           [0.0087895, 0.15714, 0.43481],      
           [0.0089466, 0.16315, 0.43869],      
           [0.0090802, 0.16914, 0.44259],      
           [0.0091935, 0.1751, 0.44646],      
           [0.0092897, 0.18105, 0.45034],      
           [0.0093719, 0.18705, 0.45421],      
           [0.0094431, 0.19303, 0.45808],      
           [0.0095061, 0.199, 0.46195],      
           [0.0095639, 0.20501, 0.46582],      
           [0.0096192, 0.21102, 0.46971],      
           [0.0096751, 0.21705, 0.47357],      
           [0.0097347, 0.22308, 0.47746],      
           [0.0098019, 0.22912, 0.48135],      
           [0.0098809, 0.23521, 0.48525],      
           [0.0099771, 0.24128, 0.48916],      
           [0.010098, 0.24739, 0.49308],      
           [0.010254, 0.25352, 0.49702],      
           [0.010463, 0.25968, 0.50097],      
           [0.010755, 0.26585, 0.50494],      
           [0.011176, 0.27204, 0.50893],      
           [0.011716, 0.2783, 0.51292],      
           [0.012286, 0.28455, 0.51695],      
           [0.012934, 0.29087, 0.521],      
           [0.01379, 0.29721, 0.52507],      
           [0.014838, 0.30358, 0.52918],      
           [0.016131, 0.31002, 0.53331],      
           [0.017711, 0.31647, 0.53748],      
           [0.01963, 0.32299, 0.54168],      
           [0.021948, 0.32955, 0.54593],      
           [0.02473, 0.33614, 0.55021],      
           [0.028047, 0.34283, 0.55454],      
           [0.03198, 0.34954, 0.55891],      
           [0.036812, 0.35633, 0.56334],      
           [0.042229, 0.36317, 0.56781],      
           [0.048008, 0.37009, 0.57235],      
           [0.054292, 0.37708, 0.57693],      
           [0.060963, 0.38413, 0.58157],      
           [0.068081, 0.39126, 0.58628],      
           [0.075457, 0.39846, 0.59104],      
           [0.083246, 0.40574, 0.59587],      
           [0.091425, 0.41309, 0.60075],      
           [0.099832, 0.4205, 0.6057],      
           [0.10859, 0.428, 0.61071],      
           [0.11769, 0.43557, 0.61577],      
           [0.12704, 0.44319, 0.6209],      
           [0.1367, 0.45089, 0.62606],      
           [0.14661, 0.45864, 0.63129],      
           [0.15679, 0.46646, 0.63656],      
           [0.16719, 0.47432, 0.64187],      
           [0.17781, 0.48224, 0.64722],      
           [0.18861, 0.49019, 0.6526],      
           [0.19958, 0.49819, 0.65802],      
           [0.21078, 0.5062, 0.66346],      
           [0.22212, 0.51426, 0.66892],      
           [0.2336, 0.52232, 0.6744],      
           [0.24523, 0.53041, 0.67989],      
           [0.257, 0.53852, 0.68541],      
           [0.26887, 0.54662, 0.69091],      
           [0.2808, 0.55472, 0.69643],      
           [0.29285, 0.56282, 0.70193],      
           [0.30498, 0.57091, 0.70745],      
           [0.31717, 0.579, 0.71295],      
           [0.32944, 0.58706, 0.71845],      
           [0.34173, 0.59512, 0.72393],      
           [0.35407, 0.60316, 0.72941],      
           [0.36646, 0.61119, 0.73488],      
           [0.37886, 0.61919, 0.74032],      
           [0.39131, 0.62716, 0.74576],      
           [0.40376, 0.63511, 0.75118],      
           [0.41623, 0.64305, 0.75658],      
           [0.42871, 0.65096, 0.76197],      
           [0.4412, 0.65884, 0.76734],      
           [0.4537, 0.6667, 0.7727],      
           [0.4662, 0.67454, 0.77804],      
           [0.4787, 0.68235, 0.78337],      
           [0.49121, 0.69014, 0.78868],      
           [0.50369, 0.69791, 0.79398],      
           [0.51618, 0.70566, 0.79926],      
           [0.52868, 0.71339, 0.80452],      
           [0.54115, 0.72109, 0.80977],      
           [0.55362, 0.72878, 0.81501],      
           [0.5661, 0.73644, 0.82023],      
           [0.57856, 0.74409, 0.82544],      
           [0.59101, 0.75172, 0.83063],      
           [0.60347, 0.75931, 0.83579],      
           [0.61591, 0.7669, 0.84094],      
           [0.62835, 0.77445, 0.84606],      
           [0.64078, 0.78199, 0.85115],      
           [0.6532, 0.78949, 0.85621],      
           [0.66563, 0.79694, 0.86121],      
           [0.67805, 0.80437, 0.86617],      
           [0.69046, 0.81174, 0.87106],      
           [0.70287, 0.81905, 0.87587],      
           [0.71526, 0.82629, 0.88057],      
           [0.72765, 0.83344, 0.88515],      
           [0.74002, 0.84048, 0.88957],      
           [0.75235, 0.84738, 0.89381],      
           [0.76466, 0.85413, 0.89782],      
           [0.77692, 0.86068, 0.90156],      
           [0.7891, 0.86699, 0.90499],      
           [0.80117, 0.87303, 0.90804],      
           [0.81311, 0.87874, 0.91065],      
           [0.82487, 0.88406, 0.91276],      
           [0.8364, 0.88893, 0.9143],      
           [0.84762, 0.89329, 0.9152],      
           [0.85847, 0.89707, 0.91539],      
           [0.86887, 0.90021, 0.91481],      
           [0.87873, 0.90264, 0.91342],      
           [0.88797, 0.9043, 0.91116],      
           [0.8965, 0.90518, 0.90803],      
           [0.90424, 0.90522, 0.90401],      
           [0.91115, 0.90442, 0.89913],      
           [0.91718, 0.9028, 0.89341],      
           [0.92229, 0.90037, 0.88691],      
           [0.92648, 0.89717, 0.87969],      
           [0.92979, 0.89326, 0.87183],      
           [0.93224, 0.8887, 0.8634],      
           [0.93388, 0.88355, 0.85448],      
           [0.93478, 0.87789, 0.84515],      
           [0.93501, 0.8718, 0.83549],      
           [0.93464, 0.86531, 0.82556],      
           [0.93375, 0.85852, 0.81542],      
           [0.93241, 0.85147, 0.80511],      
           [0.93068, 0.84421, 0.79468],      
           [0.92862, 0.83678, 0.78417],      
           [0.9263, 0.82921, 0.77358],      
           [0.92375, 0.82154, 0.76296],      
           [0.92102, 0.8138, 0.75231],      
           [0.91815, 0.806, 0.74166],      
           [0.91516, 0.79816, 0.73101],      
           [0.91208, 0.79029, 0.72037],      
           [0.90893, 0.78242, 0.70975],      
           [0.90574, 0.77454, 0.69915],      
           [0.90251, 0.76667, 0.68859],      
           [0.89925, 0.75881, 0.67805],      
           [0.89597, 0.75097, 0.66755],      
           [0.89269, 0.74315, 0.65709],      
           [0.8894, 0.73535, 0.64666],      
           [0.88612, 0.72757, 0.63627],      
           [0.88283, 0.71983, 0.62592],      
           [0.87956, 0.71211, 0.61562],      
           [0.87629, 0.70442, 0.60536],      
           [0.87303, 0.69676, 0.59514],      
           [0.86978, 0.68914, 0.58497],      
           [0.86655, 0.68154, 0.57483],      
           [0.86333, 0.67398, 0.56475],      
           [0.86012, 0.66645, 0.55471],      
           [0.85692, 0.65896, 0.54471],      
           [0.85373, 0.6515, 0.53475],      
           [0.85056, 0.64406, 0.52484],      
           [0.8474, 0.63667, 0.51497],      
           [0.84426, 0.6293, 0.50515],      
           [0.84113, 0.62196, 0.49537],      
           [0.838, 0.61465, 0.48563],      
           [0.83489, 0.60739, 0.47594],      
           [0.8318, 0.60014, 0.46628],      
           [0.82872, 0.59294, 0.45668],      
           [0.82564, 0.58576, 0.44711],      
           [0.82258, 0.5786, 0.43759],      
           [0.81953, 0.57148, 0.42811],      
           [0.8165, 0.56439, 0.41866],      
           [0.81346, 0.55733, 0.40926],      
           [0.81045, 0.55028, 0.39989],      
           [0.80744, 0.54327, 0.39058],      
           [0.80445, 0.53629, 0.3813],      
           [0.80145, 0.52933, 0.37204],      
           [0.79847, 0.52238, 0.36284],      
           [0.7955, 0.51546, 0.35366],      
           [0.79253, 0.50857, 0.34452],      
           [0.78957, 0.50169, 0.33544],      
           [0.78662, 0.49483, 0.32634],      
           [0.78366, 0.48798, 0.31731],      
           [0.7807, 0.48112, 0.3083],      
           [0.77774, 0.4743, 0.29933],      
           [0.77476, 0.46746, 0.29035],      
           [0.77179, 0.46062, 0.28142],      
           [0.76879, 0.45378, 0.27251],      
           [0.76578, 0.44693, 0.26364],      
           [0.76272, 0.44005, 0.25476],      
           [0.75964, 0.43315, 0.24587],      
           [0.75651, 0.4262, 0.23705],      
           [0.75332, 0.41922, 0.22819],      
           [0.75005, 0.41216, 0.21933],      
           [0.7467, 0.40503, 0.21047],      
           [0.74324, 0.39782, 0.20159],      
           [0.73965, 0.39049, 0.19274],      
           [0.7359, 0.38306, 0.18385],      
           [0.73199, 0.37547, 0.17498],      
           [0.72786, 0.36774, 0.16605],      
           [0.72352, 0.35985, 0.15713],      
           [0.71891, 0.35177, 0.14821],      
           [0.71403, 0.3435, 0.13928],      
           [0.70884, 0.33505, 0.13046],      
           [0.70332, 0.32635, 0.12154],      
           [0.69745, 0.3175, 0.11284],      
           [0.69123, 0.30846, 0.10413],      
           [0.68465, 0.29926, 0.095633],      
           [0.67773, 0.28992, 0.08735],      
           [0.67048, 0.28048, 0.079197],      
           [0.6629, 0.27102, 0.07151],      
           [0.65505, 0.26152, 0.064079],      
           [0.64697, 0.25208, 0.057104],      
           [0.63869, 0.24271, 0.050618],      
           [0.63026, 0.23349, 0.04475],      
           [0.62172, 0.22445, 0.039414],      
           [0.61313, 0.21566, 0.034829],      
           [0.60454, 0.20709, 0.031072],      
           [0.59595, 0.19874, 0.028212],      
           [0.5874, 0.1907, 0.026019],      
           [0.57894, 0.18292, 0.024396],      
           [0.57054, 0.17542, 0.023257],      
           [0.56227, 0.16817, 0.022523],      
           [0.55408, 0.1612, 0.02211],      
           [0.54601, 0.1544, 0.021861],      
           [0.53804, 0.14785, 0.021737],      
           [0.53018, 0.14149, 0.021722],      
           [0.52242, 0.13528, 0.0218],      
           [0.51478, 0.12921, 0.021957],      
           [0.50721, 0.12327, 0.022179],      
           [0.49973, 0.11749, 0.022455],      
           [0.49235, 0.11182, 0.022775],      
           [0.48503, 0.10621, 0.02313],      
           [0.4778, 0.10061, 0.023513],      
           [0.47064, 0.095156, 0.023916],      
           [0.46353, 0.089668, 0.024336],      
           [0.45649, 0.084258, 0.024766],      
           [0.44952, 0.078741, 0.025203],      
           [0.4426, 0.073404, 0.025644],      
           [0.43574, 0.067904, 0.026084],      
           [0.42892, 0.062415, 0.026522],      
           [0.42215, 0.056832, 0.026954],      
           [0.41544, 0.051116, 0.027378],      
           [0.40877, 0.045352, 0.02779],      
           [0.40213, 0.039448, 0.028189],      
           [0.39556, 0.033385, 0.02857],      
           [0.38902, 0.027844, 0.028932],      
           [0.3825, 0.022586, 0.029271],      
           [0.37603, 0.017608, 0.029583],      
           [0.36958, 0.01289, 0.029866],      
           [0.36316, 0.0082428, 0.030115],      
           [0.35679, 0.0040345, 0.030327],      
           [0.35042, 6.1141e-05, 0.030499]]      
      
vik_map = LinearSegmentedColormap.from_list('vik', cm_data)      
# For use of "viscm view"      
test_cm = vik_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(vik_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=vik_map)      
    plt.show()      
