# 
#         turku
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[6.3216e-05, 5.1671e-06, 3.583e-05],      
           [0.0072897, 0.0072041, 0.006548],      
           [0.01471, 0.014597, 0.013245],      
           [0.021935, 0.021794, 0.019755],      
           [0.029159, 0.028991, 0.026252],      
           [0.03657, 0.036375, 0.032748],      
           [0.043586, 0.043359, 0.039417],      
           [0.050168, 0.049959, 0.045556],      
           [0.056203, 0.055961, 0.051274],      
           [0.061712, 0.061463, 0.056643],      
           [0.066992, 0.066746, 0.061506],      
           [0.071921, 0.071694, 0.066226],      
           [0.076552, 0.076296, 0.070642],      
           [0.081056, 0.080777, 0.074828],      
           [0.085276, 0.085021, 0.078791],      
           [0.089398, 0.08911, 0.08266],      
           [0.093274, 0.092973, 0.086288],      
           [0.09712, 0.096859, 0.089825],      
           [0.10104, 0.10079, 0.093141],      
           [0.10494, 0.10467, 0.096482],      
           [0.10893, 0.10862, 0.099864],      
           [0.11292, 0.11262, 0.10324],      
           [0.11686, 0.11656, 0.10659],      
           [0.12082, 0.1205, 0.10991],      
           [0.12484, 0.12448, 0.11321],      
           [0.12884, 0.1285, 0.11649],      
           [0.13289, 0.13251, 0.11975],      
           [0.13692, 0.1365, 0.123],      
           [0.14099, 0.14056, 0.1263],      
           [0.14505, 0.1446, 0.12953],      
           [0.14908, 0.14861, 0.13275],      
           [0.15314, 0.15267, 0.13591],      
           [0.15722, 0.15676, 0.1391],      
           [0.16135, 0.16081, 0.14228],      
           [0.16539, 0.16488, 0.14544],      
           [0.16953, 0.16899, 0.1485],      
           [0.17361, 0.17304, 0.15159],      
           [0.17774, 0.17714, 0.15466],      
           [0.18181, 0.18121, 0.15769],      
           [0.18596, 0.18534, 0.1607],      
           [0.19005, 0.18941, 0.16371],      
           [0.19419, 0.19352, 0.16664],      
           [0.19828, 0.19761, 0.16957],      
           [0.20239, 0.20169, 0.17243],      
           [0.20655, 0.20582, 0.1753],      
           [0.21064, 0.2099, 0.17815],      
           [0.21475, 0.21401, 0.18091],      
           [0.21887, 0.2181, 0.18368],      
           [0.22299, 0.22219, 0.18642],      
           [0.22709, 0.2263, 0.18912],      
           [0.2312, 0.23036, 0.19178],      
           [0.23531, 0.23447, 0.19445],      
           [0.23939, 0.23853, 0.19704],      
           [0.24347, 0.24261, 0.19958],      
           [0.24758, 0.24669, 0.20213],      
           [0.25167, 0.25076, 0.20466],      
           [0.25574, 0.25485, 0.20713],      
           [0.25982, 0.2589, 0.20956],      
           [0.2639, 0.26295, 0.21199],      
           [0.26794, 0.26699, 0.21436],      
           [0.272, 0.27106, 0.21672],      
           [0.27609, 0.2751, 0.21904],      
           [0.28012, 0.27914, 0.22133],      
           [0.28416, 0.28317, 0.22359],      
           [0.28821, 0.28719, 0.22583],      
           [0.29225, 0.29123, 0.22804],      
           [0.29629, 0.29524, 0.23019],      
           [0.30031, 0.29927, 0.23237],      
           [0.30434, 0.30327, 0.2345],      
           [0.30837, 0.30728, 0.23661],      
           [0.31238, 0.3113, 0.23866],      
           [0.31642, 0.3153, 0.24072],      
           [0.32044, 0.3193, 0.24276],      
           [0.32444, 0.3233, 0.24476],      
           [0.32846, 0.32729, 0.24677],      
           [0.33249, 0.33128, 0.24876],      
           [0.33649, 0.3353, 0.2507],      
           [0.34051, 0.33929, 0.25265],      
           [0.34452, 0.34327, 0.25458],      
           [0.34855, 0.34726, 0.25647],      
           [0.35257, 0.35125, 0.25836],      
           [0.35661, 0.35525, 0.26025],      
           [0.36062, 0.35922, 0.26211],      
           [0.36467, 0.36321, 0.26398],      
           [0.36872, 0.3672, 0.26582],      
           [0.37276, 0.3712, 0.26764],      
           [0.37684, 0.37519, 0.2695],      
           [0.38091, 0.3792, 0.2713],      
           [0.38497, 0.38321, 0.27313],      
           [0.38908, 0.3872, 0.27493],      
           [0.39318, 0.39122, 0.27675],      
           [0.3973, 0.39524, 0.27856],      
           [0.40144, 0.39924, 0.28035],      
           [0.4056, 0.40328, 0.28218],      
           [0.40977, 0.4073, 0.28397],      
           [0.41396, 0.41134, 0.28577],      
           [0.41817, 0.41538, 0.28759],      
           [0.42241, 0.41944, 0.28942],      
           [0.42668, 0.42348, 0.29125],      
           [0.43097, 0.42756, 0.29307],      
           [0.4353, 0.43163, 0.29491],      
           [0.43964, 0.4357, 0.29678],      
           [0.44402, 0.43979, 0.29864],      
           [0.44844, 0.44388, 0.30051],      
           [0.45289, 0.44797, 0.3024],      
           [0.45737, 0.4521, 0.30432],      
           [0.4619, 0.45621, 0.30627],      
           [0.46647, 0.46033, 0.3082],      
           [0.47109, 0.46448, 0.31018],      
           [0.47576, 0.46861, 0.31215],      
           [0.48046, 0.47276, 0.31418],      
           [0.48521, 0.47692, 0.31623],      
           [0.49003, 0.48108, 0.31829],      
           [0.4949, 0.48525, 0.3204],      
           [0.49981, 0.48942, 0.32252],      
           [0.5048, 0.49361, 0.32466],      
           [0.50984, 0.4978, 0.32685],      
           [0.51494, 0.50198, 0.32909],      
           [0.5201, 0.50615, 0.33133],      
           [0.52533, 0.51034, 0.33364],      
           [0.53062, 0.51453, 0.33596],      
           [0.53597, 0.5187, 0.33833],      
           [0.54139, 0.52287, 0.34075],      
           [0.54688, 0.52703, 0.3432],      
           [0.55243, 0.53117, 0.34568],      
           [0.55804, 0.53529, 0.34822],      
           [0.56373, 0.5394, 0.3508],      
           [0.56946, 0.54349, 0.3534],      
           [0.57527, 0.54755, 0.35606],      
           [0.58113, 0.55159, 0.35875],      
           [0.58704, 0.55558, 0.36149],      
           [0.59302, 0.55954, 0.36426],      
           [0.59904, 0.56346, 0.36708],      
           [0.6051, 0.56733, 0.36993],      
           [0.6112, 0.57114, 0.37282],      
           [0.61734, 0.5749, 0.37575],      
           [0.62351, 0.5786, 0.37871],      
           [0.6297, 0.58224, 0.3817],      
           [0.63592, 0.58581, 0.38472],      
           [0.64215, 0.58928, 0.38776],      
           [0.64837, 0.59271, 0.39084],      
           [0.65461, 0.59602, 0.39392],      
           [0.66083, 0.59926, 0.39703],      
           [0.66705, 0.6024, 0.40016],      
           [0.67324, 0.60545, 0.4033],      
           [0.6794, 0.60841, 0.40645],      
           [0.68554, 0.61126, 0.40961],      
           [0.69163, 0.614, 0.41278],      
           [0.69767, 0.61665, 0.41594],      
           [0.70367, 0.61918, 0.41911],      
           [0.7096, 0.6216, 0.42226],      
           [0.71548, 0.62393, 0.42543],      
           [0.72128, 0.62613, 0.42859],      
           [0.72702, 0.62824, 0.43175],      
           [0.73268, 0.63023, 0.43489],      
           [0.73826, 0.63212, 0.43802],      
           [0.74377, 0.63391, 0.44114],      
           [0.74919, 0.63559, 0.44426],      
           [0.75454, 0.63718, 0.44735],      
           [0.75979, 0.63867, 0.45046],      
           [0.76496, 0.64007, 0.45354],      
           [0.77004, 0.64138, 0.45662],      
           [0.77504, 0.64261, 0.4597],      
           [0.77996, 0.64375, 0.46277],      
           [0.7848, 0.64482, 0.46584],      
           [0.78955, 0.64583, 0.46892],      
           [0.79423, 0.64677, 0.472],      
           [0.79883, 0.64765, 0.47508],      
           [0.80335, 0.64847, 0.47816],      
           [0.80781, 0.64925, 0.48126],      
           [0.8122, 0.64999, 0.48437],      
           [0.81652, 0.65069, 0.48753],      
           [0.82078, 0.65136, 0.49069],      
           [0.82499, 0.652, 0.49388],      
           [0.82914, 0.65263, 0.49711],      
           [0.83324, 0.65324, 0.50037],      
           [0.83729, 0.65386, 0.50368],      
           [0.8413, 0.65448, 0.50704],      
           [0.84526, 0.6551, 0.51045],      
           [0.84919, 0.65575, 0.51393],      
           [0.85308, 0.65642, 0.51746],      
           [0.85694, 0.65711, 0.52105],      
           [0.86077, 0.65784, 0.52472],      
           [0.86458, 0.65861, 0.52847],      
           [0.86836, 0.65943, 0.5323],      
           [0.87211, 0.6603, 0.53622],      
           [0.87584, 0.66124, 0.54022],      
           [0.87955, 0.66225, 0.54432],      
           [0.88325, 0.66333, 0.54853],      
           [0.88692, 0.66449, 0.55281],      
           [0.89057, 0.66573, 0.55722],      
           [0.8942, 0.66707, 0.56172],      
           [0.89781, 0.6685, 0.56633],      
           [0.90139, 0.67004, 0.57104],      
           [0.90496, 0.67167, 0.57587],      
           [0.90849, 0.67342, 0.58079],      
           [0.912, 0.67527, 0.58583],      
           [0.91547, 0.67725, 0.59096],      
           [0.91891, 0.67933, 0.59619],      
           [0.92231, 0.68154, 0.60153],      
           [0.92567, 0.68387, 0.60696],      
           [0.92898, 0.68632, 0.61246],      
           [0.93224, 0.68889, 0.61806],      
           [0.93545, 0.69156, 0.62374],      
           [0.9386, 0.69436, 0.62947],      
           [0.94168, 0.69728, 0.63527],      
           [0.9447, 0.70031, 0.64113],      
           [0.94765, 0.70344, 0.64704],      
           [0.95052, 0.70669, 0.65298],      
           [0.95331, 0.71003, 0.65896],      
           [0.95602, 0.71346, 0.66497],      
           [0.95865, 0.717, 0.67099],      
           [0.96119, 0.7206, 0.67702],      
           [0.96363, 0.7243, 0.68304],      
           [0.96599, 0.72807, 0.68907],      
           [0.96826, 0.73191, 0.69507],      
           [0.97043, 0.73581, 0.70105],      
           [0.97251, 0.73978, 0.70702],      
           [0.97448, 0.74378, 0.71294],      
           [0.97637, 0.74785, 0.71883],      
           [0.97816, 0.75195, 0.72468],      
           [0.97987, 0.75608, 0.73048],      
           [0.98148, 0.76025, 0.73623],      
           [0.983, 0.76445, 0.74194],      
           [0.98444, 0.76867, 0.74759],      
           [0.98578, 0.77292, 0.75318],      
           [0.98705, 0.77719, 0.75873],      
           [0.98823, 0.78146, 0.76421],      
           [0.98935, 0.78575, 0.76963],      
           [0.99038, 0.79004, 0.775],      
           [0.99134, 0.79435, 0.78032],      
           [0.99224, 0.79865, 0.78558],      
           [0.99307, 0.80296, 0.79078],      
           [0.99383, 0.80727, 0.79594],      
           [0.99453, 0.81158, 0.80104],      
           [0.99518, 0.8159, 0.8061],      
           [0.99577, 0.8202, 0.81111],      
           [0.99632, 0.82451, 0.81608],      
           [0.99681, 0.82882, 0.821],      
           [0.99726, 0.83312, 0.82588],      
           [0.99767, 0.83743, 0.83074],      
           [0.99804, 0.84173, 0.83555],      
           [0.99837, 0.84602, 0.84033],      
           [0.99866, 0.85032, 0.84508],      
           [0.99892, 0.85461, 0.84981],      
           [0.99915, 0.8589, 0.85451],      
           [0.99934, 0.86319, 0.85919],      
           [0.99951, 0.86747, 0.86385],      
           [0.99965, 0.87176, 0.86849],      
           [0.99977, 0.87604, 0.87312],      
           [0.99986, 0.88032, 0.87773],      
           [0.99994, 0.88461, 0.88233],      
           [0.99999, 0.88889, 0.88693],      
           [1, 0.89317, 0.89151],      
           [1, 0.89746, 0.89609],      
           [1, 0.90174, 0.90067]]      
      
turku_map = LinearSegmentedColormap.from_list('turku', cm_data)      
# For use of "viscm view"      
test_cm = turku_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(turku_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=turku_map)      
    plt.show()      
