# 
#         turkuS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.029159, 0.028991, 0.026252],      
           [1, 0.90174, 0.90067],      
           [0.58704, 0.55558, 0.36149],      
           [0.30031, 0.29927, 0.23237],      
           [0.89781, 0.6685, 0.56633],      
           [0.17361, 0.17304, 0.15159],      
           [0.983, 0.76445, 0.74194],      
           [0.42668, 0.42348, 0.29125],      
           [0.77004, 0.64138, 0.45662],      
           [0.49981, 0.48942, 0.32252],      
           [0.10893, 0.10862, 0.099864],      
           [0.99726, 0.83312, 0.82588],      
           [0.68554, 0.61126, 0.40961],      
           [0.94765, 0.70344, 0.64704],      
           [0.36467, 0.36321, 0.26398],      
           [0.8413, 0.65448, 0.50704],      
           [0.23531, 0.23447, 0.19445],      
           [0.96826, 0.73191, 0.69507],      
           [0.076552, 0.076296, 0.070642],      
           [0.4619, 0.45621, 0.30627],      
           [0.33249, 0.33128, 0.24876],      
           [0.99224, 0.79865, 0.78558],      
           [0.14099, 0.14056, 0.1263],      
           [0.80781, 0.64925, 0.48126],      
           [0.99951, 0.86747, 0.86385],      
           [0.26794, 0.26699, 0.21436],      
           [0.63592, 0.58581, 0.38472],      
           [0.54139, 0.52287, 0.34075],      
           [0.20239, 0.20169, 0.17243],      
           [0.3973, 0.39524, 0.27856],      
           [0.86836, 0.65943, 0.5323],      
           [0.92231, 0.68154, 0.60153],      
           [0.72702, 0.62824, 0.43175],      
           [0.34855, 0.34726, 0.25647],      
           [0.78955, 0.64583, 0.46892],      
           [0.95865, 0.717, 0.67099],      
           [0.28416, 0.28317, 0.22359],      
           [0.56373, 0.5394, 0.3508],      
           [0.98823, 0.78146, 0.76421],      
           [0.66083, 0.59926, 0.39703],      
           [0.5201, 0.50615, 0.33133],      
           [0.31642, 0.3153, 0.24072],      
           [0.44402, 0.43979, 0.29864],      
           [0.97637, 0.74785, 0.71883],      
           [0.25167, 0.25076, 0.20466],      
           [0.48046, 0.47276, 0.31418],      
           [0.38091, 0.3792, 0.2713],      
           [0.88325, 0.66333, 0.54853],      
           [0.74919, 0.63559, 0.44426],      
           [0.93545, 0.69156, 0.62374],      
           [0.21887, 0.2181, 0.18368],      
           [0.15722, 0.15676, 0.1391],      
           [0.6112, 0.57114, 0.37282],      
           [0.056203, 0.055961, 0.051274],      
           [0.82499, 0.652, 0.49388],      
           [0.99994, 0.88461, 0.88233],      
           [0.99866, 0.85032, 0.84508],      
           [0.99518, 0.8159, 0.8061],      
           [0.12484, 0.12448, 0.11321],      
           [0.093274, 0.092973, 0.086288],      
           [0.912, 0.67527, 0.58583],      
           [0.18596, 0.18534, 0.1607],      
           [0.70367, 0.61918, 0.41911],      
           [0.41396, 0.41134, 0.28577],      
           [0.85308, 0.65642, 0.51746],      
           [0.87584, 0.66124, 0.54022],      
           [0.19419, 0.19352, 0.16664],      
           [0.21064, 0.2099, 0.17815],      
           [0.86077, 0.65784, 0.52472],      
           [0.4353, 0.43163, 0.29491],      
           [0.11686, 0.11656, 0.10659],      
           [0.49003, 0.48108, 0.31829],      
           [0.22709, 0.2263, 0.18912],      
           [0.96363, 0.7243, 0.68304],      
           [0.99804, 0.84173, 0.83555],      
           [0.043586, 0.043359, 0.039417],      
           [0.79883, 0.64765, 0.47508],      
           [0.81652, 0.65069, 0.48753],      
           [0.32444, 0.3233, 0.24476],      
           [0.97987, 0.75608, 0.73048],      
           [0.35661, 0.35525, 0.26025],      
           [0.085276, 0.085021, 0.078791],      
           [0.14908, 0.14861, 0.13275],      
           [0.95331, 0.71003, 0.65896],      
           [0.89057, 0.66573, 0.55722],      
           [0.94168, 0.69728, 0.63527],      
           [0.71548, 0.62393, 0.42543],      
           [0.98578, 0.77292, 0.75318],      
           [0.10104, 0.10079, 0.093141],      
           [0.50984, 0.4978, 0.32685],      
           [0.34051, 0.33929, 0.25265],      
           [0.57527, 0.54755, 0.35606],      
           [0.99632, 0.82451, 0.81608],      
           [0.37276, 0.3712, 0.26764],      
           [0.67324, 0.60545, 0.4033],      
           [0.066992, 0.066746, 0.061506],      
           [0.27609, 0.2751, 0.21904],      
           [0.99038, 0.79004, 0.775],      
           [0.30837, 0.30728, 0.23661],      
           [0.97251, 0.73978, 0.70702]]      
      
turkuS_map = LinearSegmentedColormap.from_list('turkuS', cm_data)      
# For use of "viscm view"      
test_cm = turkuS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(turkuS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=turkuS_map)      
    plt.show()      
