# 
#         tokyoS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.10387, 0.056805, 0.20243],      
           [0.99708, 0.99733, 0.84887],      
           [0.56301, 0.52969, 0.52511],      
           [0.46223, 0.27624, 0.42457],      
           [0.63013, 0.77187, 0.5993],      
           [0.53661, 0.41269, 0.48849],      
           [0.80822, 0.93317, 0.71825],      
           [0.29442, 0.13697, 0.31333],      
           [0.5835, 0.64523, 0.55687],      
           [0.19833, 0.090586, 0.2555],      
           [0.57276, 0.58696, 0.54104],      
           [0.50996, 0.34812, 0.46237],      
           [0.55207, 0.4722, 0.50818],      
           [0.38753, 0.2015, 0.37279],      
           [0.69973, 0.85431, 0.64681],      
           [0.91316, 0.97898, 0.78927],      
           [0.59826, 0.70264, 0.57342],      
           [0.86348, 0.96072, 0.75524],      
           [0.65894, 0.81164, 0.61951],      
           [0.52526, 0.38125, 0.47656],      
           [0.34223, 0.16717, 0.34337],      
           [0.54522, 0.44286, 0.49885],      
           [0.55783, 0.50106, 0.51684],      
           [0.61097, 0.73576, 0.5846],      
           [0.48934, 0.31305, 0.44524],      
           [0.95708, 0.99022, 0.82012],      
           [0.75136, 0.89651, 0.68075],      
           [0.57782, 0.61589, 0.54891],      
           [0.2461, 0.11159, 0.28383],      
           [0.56789, 0.55827, 0.53315],      
           [0.15119, 0.072938, 0.22845],      
           [0.42811, 0.2385, 0.40025],      
           [0.59039, 0.67531, 0.56526],      
           [0.40854, 0.21982, 0.38685],      
           [0.22212, 0.10056, 0.26951],      
           [0.93575, 0.9853, 0.80504],      
           [0.57524, 0.60139, 0.54497],      
           [0.54118, 0.42791, 0.49383],      
           [0.604, 0.7189, 0.57868],      
           [0.6778, 0.83276, 0.63223],      
           [0.51819, 0.36491, 0.4698],      
           [0.58674, 0.66015, 0.56098],      
           [0.36533, 0.18389, 0.35824],      
           [0.97743, 0.99412, 0.83468],      
           [0.61955, 0.75338, 0.59139],      
           [0.3185, 0.15147, 0.32834],      
           [0.54882, 0.45761, 0.50361],      
           [0.57031, 0.57261, 0.53711],      
           [0.8364, 0.94818, 0.73701],      
           [0.55505, 0.48667, 0.51257],      
           [0.56546, 0.54398, 0.52916],      
           [0.58056, 0.6305, 0.55286],      
           [0.8891, 0.9709, 0.77268],      
           [0.17475, 0.081435, 0.24182],      
           [0.5004, 0.33082, 0.45422],      
           [0.44603, 0.25739, 0.41286],      
           [0.64313, 0.79129, 0.60859],      
           [0.77959, 0.91583, 0.69932],      
           [0.47666, 0.29481, 0.43537],      
           [0.72445, 0.87578, 0.66309],      
           [0.27026, 0.12365, 0.29845],      
           [0.53134, 0.39714, 0.48276],      
           [0.56047, 0.51538, 0.52102],      
           [0.12757, 0.064935, 0.21531],      
           [0.59349, 0.68688, 0.56863],      
           [0.65067, 0.80136, 0.61382],      
           [0.41851, 0.22913, 0.39364],      
           [0.16298, 0.077038, 0.23511],      
           [0.55358, 0.47945, 0.51039],      
           [0.92463, 0.98234, 0.79725],      
           [0.48321, 0.30398, 0.44041],      
           [0.57399, 0.59417, 0.54301],      
           [0.53406, 0.40495, 0.48567],      
           [0.13939, 0.068939, 0.22184],      
           [0.56669, 0.55112, 0.53116],      
           [0.73768, 0.88628, 0.67178],      
           [0.46968, 0.28555, 0.43009],      
           [0.21021, 0.095479, 0.26246],      
           [0.49507, 0.322, 0.44984],      
           [0.60099, 0.7107, 0.57599],      
           [0.52841, 0.38925, 0.47973],      
           [0.59578, 0.6947, 0.57097],      
           [0.11566, 0.061046, 0.20884],      
           [0.6363, 0.78146, 0.60376],      
           [0.55048, 0.46492, 0.50591],      
           [0.2341, 0.10596, 0.27664],      
           [0.55917, 0.50823, 0.51895],      
           [0.66798, 0.82213, 0.62564],      
           [0.90133, 0.97518, 0.78108],      
           [0.98733, 0.99579, 0.84181],      
           [0.96736, 0.99228, 0.82746],      
           [0.82241, 0.94098, 0.72768],      
           [0.76537, 0.90639, 0.68996],      
           [0.62456, 0.76251, 0.59518],      
           [0.56425, 0.53684, 0.52714],      
           [0.53897, 0.42033, 0.49121],      
           [0.33042, 0.15918, 0.33586],      
           [0.582, 0.63785, 0.55485],      
           [0.71178, 0.86509, 0.65474],      
           [0.43729, 0.24796, 0.40666]]      
      
tokyoS_map = LinearSegmentedColormap.from_list('tokyoS', cm_data)      
# For use of "viscm view"      
test_cm = tokyoS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(tokyoS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=tokyoS_map)      
    plt.show()      
