# 
#         roma
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.49232, 0.090787, 7.635e-05],      
           [0.49673, 0.1028, 0.0036753],      
           [0.50113, 0.11403, 0.0071337],      
           [0.50547, 0.12468, 0.010421],      
           [0.50981, 0.13489, 0.013817],      
           [0.51412, 0.14464, 0.016841],      
           [0.5184, 0.15404, 0.01972],      
           [0.52263, 0.16319, 0.022451],      
           [0.52685, 0.17204, 0.025034],      
           [0.53102, 0.18068, 0.027528],      
           [0.53514, 0.18915, 0.030132],      
           [0.53922, 0.19742, 0.032869],      
           [0.54327, 0.20552, 0.035925],      
           [0.54725, 0.21348, 0.038888],      
           [0.5512, 0.22132, 0.041994],      
           [0.5551, 0.22902, 0.045012],      
           [0.55895, 0.23661, 0.047967],      
           [0.56278, 0.24405, 0.051012],      
           [0.56654, 0.25146, 0.053998],      
           [0.57026, 0.25873, 0.057033],      
           [0.57394, 0.26592, 0.060051],      
           [0.57758, 0.27302, 0.063001],      
           [0.58118, 0.28005, 0.065873],      
           [0.58474, 0.28699, 0.068856],      
           [0.58825, 0.29388, 0.071712],      
           [0.59174, 0.3007, 0.074564],      
           [0.59517, 0.30745, 0.077376],      
           [0.59858, 0.31415, 0.080252],      
           [0.60195, 0.3208, 0.083076],      
           [0.60528, 0.32736, 0.085853],      
           [0.60859, 0.33391, 0.088711],      
           [0.61186, 0.34039, 0.091525],      
           [0.61509, 0.34683, 0.094279],      
           [0.61831, 0.35322, 0.096979],      
           [0.62149, 0.35957, 0.099753],      
           [0.62465, 0.3659, 0.10251],      
           [0.62778, 0.37217, 0.10522],      
           [0.6309, 0.37844, 0.10796],      
           [0.63399, 0.38467, 0.11074],      
           [0.63707, 0.39089, 0.11348],      
           [0.64013, 0.39708, 0.11622],      
           [0.64317, 0.40327, 0.11896],      
           [0.64621, 0.40945, 0.12167],      
           [0.64924, 0.41561, 0.12447],      
           [0.65226, 0.42178, 0.12727],      
           [0.65528, 0.42796, 0.13015],      
           [0.6583, 0.43413, 0.13297],      
           [0.66131, 0.44033, 0.13583],      
           [0.66433, 0.44654, 0.13878],      
           [0.66736, 0.45278, 0.14176],      
           [0.6704, 0.45903, 0.14479],      
           [0.67344, 0.4653, 0.14785],      
           [0.67649, 0.47163, 0.15097],      
           [0.67955, 0.47797, 0.15416],      
           [0.68264, 0.48435, 0.15743],      
           [0.68574, 0.49078, 0.16079],      
           [0.68885, 0.49724, 0.16425],      
           [0.69198, 0.50374, 0.16775],      
           [0.69512, 0.5103, 0.17137],      
           [0.69828, 0.5169, 0.17511],      
           [0.70147, 0.52356, 0.17896],      
           [0.70468, 0.53026, 0.1829],      
           [0.70791, 0.53702, 0.18701],      
           [0.71116, 0.54382, 0.19123],      
           [0.71443, 0.55069, 0.1956],      
           [0.71772, 0.55762, 0.20011],      
           [0.72103, 0.56459, 0.20483],      
           [0.72437, 0.57163, 0.20968],      
           [0.72772, 0.57873, 0.21471],      
           [0.73109, 0.58589, 0.21995],      
           [0.73448, 0.5931, 0.22535],      
           [0.73788, 0.60036, 0.23097],      
           [0.7413, 0.6077, 0.23681],      
           [0.74473, 0.61507, 0.24282],      
           [0.74818, 0.62252, 0.2491],      
           [0.75162, 0.63001, 0.2556],      
           [0.75507, 0.63756, 0.26233],      
           [0.75852, 0.64515, 0.26932],      
           [0.76196, 0.65279, 0.27655],      
           [0.76541, 0.66047, 0.28401],      
           [0.76882, 0.6682, 0.29176],      
           [0.77222, 0.67595, 0.29974],      
           [0.7756, 0.68373, 0.30798],      
           [0.77894, 0.69153, 0.3165],      
           [0.78224, 0.69935, 0.32526],      
           [0.78549, 0.70719, 0.3343],      
           [0.78869, 0.71502, 0.34356],      
           [0.79181, 0.72284, 0.35309],      
           [0.79486, 0.73065, 0.36285],      
           [0.79783, 0.73844, 0.37284],      
           [0.8007, 0.74619, 0.38307],      
           [0.80346, 0.75389, 0.3935],      
           [0.80611, 0.76154, 0.40413],      
           [0.80862, 0.76911, 0.41495],      
           [0.811, 0.77662, 0.42594],      
           [0.81322, 0.78403, 0.43709],      
           [0.81528, 0.79132, 0.44836],      
           [0.81717, 0.79851, 0.45976],      
           [0.81886, 0.80556, 0.47125],      
           [0.82037, 0.81248, 0.48281],      
           [0.82168, 0.81924, 0.49444],      
           [0.82276, 0.82584, 0.50608],      
           [0.82361, 0.83227, 0.51775],      
           [0.82424, 0.83851, 0.5294],      
           [0.82462, 0.84455, 0.541],      
           [0.82475, 0.85039, 0.55256],      
           [0.82463, 0.85602, 0.56404],      
           [0.82425, 0.86143, 0.57541],      
           [0.82361, 0.86661, 0.58666],      
           [0.82269, 0.87156, 0.59777],      
           [0.8215, 0.87627, 0.60873],      
           [0.82003, 0.88074, 0.61951],      
           [0.81829, 0.88497, 0.6301],      
           [0.81627, 0.88895, 0.64049],      
           [0.81395, 0.89268, 0.65066],      
           [0.81137, 0.89616, 0.6606],      
           [0.8085, 0.89939, 0.67031],      
           [0.80535, 0.90236, 0.67976],      
           [0.80192, 0.90509, 0.68897],      
           [0.79821, 0.90757, 0.69791],      
           [0.79423, 0.90979, 0.70659],      
           [0.78996, 0.91177, 0.71498],      
           [0.78543, 0.91351, 0.72311],      
           [0.78062, 0.91499, 0.73095],      
           [0.77555, 0.91624, 0.73852],      
           [0.77022, 0.91725, 0.7458],      
           [0.76462, 0.91801, 0.7528],      
           [0.75877, 0.91854, 0.75952],      
           [0.75266, 0.91884, 0.76596],      
           [0.74632, 0.9189, 0.77211],      
           [0.73973, 0.91874, 0.77798],      
           [0.7329, 0.91835, 0.78357],      
           [0.72583, 0.91774, 0.78889],      
           [0.71854, 0.9169, 0.79394],      
           [0.71103, 0.91583, 0.79871],      
           [0.7033, 0.91455, 0.80321],      
           [0.69536, 0.91305, 0.80746],      
           [0.68722, 0.91134, 0.81144],      
           [0.67887, 0.90941, 0.81517],      
           [0.67035, 0.90728, 0.81864],      
           [0.66163, 0.90493, 0.82188],      
           [0.65274, 0.90238, 0.82486],      
           [0.64368, 0.89962, 0.82761],      
           [0.63446, 0.89666, 0.83014],      
           [0.62509, 0.8935, 0.83242],      
           [0.61557, 0.89015, 0.83449],      
           [0.60591, 0.8866, 0.83634],      
           [0.59614, 0.88285, 0.83797],      
           [0.58626, 0.87892, 0.83939],      
           [0.57628, 0.87481, 0.84061],      
           [0.56619, 0.87052, 0.84163],      
           [0.55602, 0.86606, 0.84246],      
           [0.54581, 0.86142, 0.84309],      
           [0.53553, 0.85662, 0.84354],      
           [0.52522, 0.85166, 0.84381],      
           [0.51488, 0.84654, 0.84391],      
           [0.50453, 0.84129, 0.84384],      
           [0.49418, 0.83588, 0.8436],      
           [0.48384, 0.83035, 0.84322],      
           [0.47354, 0.82468, 0.84268],      
           [0.46329, 0.8189, 0.84199],      
           [0.45311, 0.81301, 0.84116],      
           [0.44301, 0.80702, 0.8402],      
           [0.43298, 0.80092, 0.83911],      
           [0.42306, 0.79474, 0.8379],      
           [0.41327, 0.78847, 0.83657],      
           [0.4036, 0.78214, 0.83513],      
           [0.39406, 0.77573, 0.8336],      
           [0.38468, 0.76926, 0.83196],      
           [0.37547, 0.76275, 0.83023],      
           [0.36645, 0.75619, 0.82841],      
           [0.35759, 0.74958, 0.82651],      
           [0.34892, 0.74296, 0.82454],      
           [0.34045, 0.73629, 0.8225],      
           [0.33219, 0.72962, 0.82039],      
           [0.32411, 0.72292, 0.81823],      
           [0.31628, 0.71622, 0.81602],      
           [0.30865, 0.70951, 0.81375],      
           [0.30122, 0.7028, 0.81144],      
           [0.29404, 0.6961, 0.80909],      
           [0.28707, 0.6894, 0.8067],      
           [0.28032, 0.68271, 0.80427],      
           [0.27382, 0.67603, 0.80182],      
           [0.26748, 0.66938, 0.79934],      
           [0.26141, 0.66274, 0.79684],      
           [0.25554, 0.65612, 0.79432],      
           [0.24986, 0.64952, 0.79178],      
           [0.2444, 0.64294, 0.78923],      
           [0.23916, 0.6364, 0.78667],      
           [0.2341, 0.62987, 0.78409],      
           [0.22923, 0.62338, 0.7815],      
           [0.22453, 0.61692, 0.77891],      
           [0.22006, 0.61047, 0.77631],      
           [0.21573, 0.60407, 0.77371],      
           [0.21157, 0.59767, 0.77111],      
           [0.20755, 0.59132, 0.7685],      
           [0.20371, 0.58499, 0.7659],      
           [0.19997, 0.57868, 0.76329],      
           [0.19644, 0.5724, 0.76069],      
           [0.19299, 0.56614, 0.75809],      
           [0.18968, 0.55991, 0.75548],      
           [0.18649, 0.55369, 0.75287],      
           [0.1834, 0.5475, 0.75028],      
           [0.18042, 0.54132, 0.74768],      
           [0.17759, 0.53516, 0.74507],      
           [0.1748, 0.52903, 0.74248],      
           [0.17208, 0.52288, 0.73988],      
           [0.1695, 0.51675, 0.73727],      
           [0.16696, 0.51063, 0.73467],      
           [0.16448, 0.50452, 0.73207],      
           [0.16209, 0.4984, 0.72945],      
           [0.1597, 0.49226, 0.72684],      
           [0.15741, 0.48613, 0.72421],      
           [0.15518, 0.47999, 0.72158],      
           [0.15296, 0.47383, 0.71895],      
           [0.1508, 0.46766, 0.71631],      
           [0.14865, 0.46147, 0.71364],      
           [0.14655, 0.45526, 0.71098],      
           [0.14449, 0.44903, 0.70829],      
           [0.14241, 0.44276, 0.70559],      
           [0.14034, 0.43647, 0.70289],      
           [0.13831, 0.43014, 0.70016],      
           [0.13621, 0.42378, 0.69741],      
           [0.1342, 0.41741, 0.69465],      
           [0.13213, 0.41098, 0.69188],      
           [0.13009, 0.40452, 0.68909],      
           [0.12797, 0.39804, 0.68628],      
           [0.12586, 0.39152, 0.68345],      
           [0.12366, 0.38495, 0.6806],      
           [0.12148, 0.37835, 0.67775],      
           [0.11929, 0.37171, 0.67486],      
           [0.117, 0.36505, 0.67196],      
           [0.11465, 0.35834, 0.66905],      
           [0.11232, 0.3516, 0.66611],      
           [0.10989, 0.34482, 0.66316],      
           [0.10732, 0.33799, 0.66018],      
           [0.10464, 0.33113, 0.6572],      
           [0.10195, 0.32424, 0.65418],      
           [0.099119, 0.3173, 0.65115],      
           [0.096135, 0.31034, 0.6481],      
           [0.093031, 0.3033, 0.64503],      
           [0.089832, 0.29624, 0.64195],      
           [0.086378, 0.28914, 0.63884],      
           [0.082771, 0.28199, 0.63572],      
           [0.078888, 0.27477, 0.63257],      
           [0.074823, 0.26751, 0.6294],      
           [0.070429, 0.26024, 0.62622],      
           [0.065707, 0.25289, 0.62301],      
           [0.060588, 0.24547, 0.61979],      
           [0.054957, 0.23804, 0.61654],      
           [0.048861, 0.23052, 0.61327],      
           [0.041963, 0.22298, 0.60999],      
           [0.034076, 0.21534, 0.6067],      
           [0.026246, 0.20768, 0.60338],      
           [0.018222, 0.19991, 0.60005],      
           [0.0098239, 0.19213, 0.5967]]      
      
roma_map = LinearSegmentedColormap.from_list('roma', cm_data)      
# For use of "viscm view"      
test_cm = roma_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(roma_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=roma_map)      
    plt.show()      
