# 
#         nuuk
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.018013, 0.35076, 0.55062],      
           [0.025926, 0.35177, 0.54917],      
           [0.033826, 0.35281, 0.54772],      
           [0.042005, 0.35384, 0.54628],      
           [0.049338, 0.35491, 0.54484],      
           [0.056017, 0.35596, 0.54341],      
           [0.062265, 0.35703, 0.54199],      
           [0.068128, 0.3581, 0.54059],      
           [0.073701, 0.35918, 0.5392],      
           [0.078892, 0.36028, 0.53783],      
           [0.084046, 0.36141, 0.53646],      
           [0.088911, 0.36254, 0.53511],      
           [0.093625, 0.36368, 0.53377],      
           [0.098277, 0.36485, 0.53247],      
           [0.10277, 0.36604, 0.53117],      
           [0.1072, 0.36724, 0.5299],      
           [0.11153, 0.36847, 0.52866],      
           [0.1158, 0.36971, 0.52743],      
           [0.11998, 0.37098, 0.52624],      
           [0.12415, 0.37227, 0.52507],      
           [0.12832, 0.3736, 0.52393],      
           [0.13244, 0.37494, 0.52282],      
           [0.1365, 0.37633, 0.52173],      
           [0.14062, 0.37772, 0.52069],      
           [0.14469, 0.37915, 0.51968],      
           [0.14872, 0.38062, 0.51871],      
           [0.15279, 0.3821, 0.51778],      
           [0.15688, 0.38364, 0.51688],      
           [0.16097, 0.38519, 0.51602],      
           [0.16503, 0.38678, 0.51521],      
           [0.16919, 0.38842, 0.51445],      
           [0.17328, 0.39007, 0.51373],      
           [0.17746, 0.39178, 0.51305],      
           [0.18159, 0.39352, 0.51242],      
           [0.18583, 0.3953, 0.51185],      
           [0.19003, 0.3971, 0.51132],      
           [0.19431, 0.39896, 0.51085],      
           [0.19855, 0.40087, 0.51043],      
           [0.20287, 0.40279, 0.51007],      
           [0.20723, 0.40475, 0.50977],      
           [0.21161, 0.40677, 0.50952],      
           [0.21602, 0.40882, 0.50933],      
           [0.22047, 0.41091, 0.50919],      
           [0.22491, 0.41305, 0.50912],      
           [0.22943, 0.41521, 0.50911],      
           [0.23398, 0.41742, 0.50915],      
           [0.23855, 0.41967, 0.50926],      
           [0.24317, 0.42194, 0.50943],      
           [0.24784, 0.42427, 0.50965],      
           [0.25252, 0.42664, 0.50994],      
           [0.25723, 0.42904, 0.51029],      
           [0.26198, 0.43148, 0.51071],      
           [0.26676, 0.43393, 0.51118],      
           [0.27156, 0.43644, 0.51171],      
           [0.27643, 0.43897, 0.51231],      
           [0.28128, 0.44155, 0.51296],      
           [0.28617, 0.44415, 0.51367],      
           [0.29112, 0.44677, 0.51444],      
           [0.29607, 0.44943, 0.51526],      
           [0.30104, 0.45213, 0.51613],      
           [0.30607, 0.45484, 0.51707],      
           [0.31108, 0.45757, 0.51805],      
           [0.31614, 0.46033, 0.51909],      
           [0.32119, 0.46311, 0.52016],      
           [0.32627, 0.46592, 0.52129],      
           [0.33138, 0.46876, 0.52247],      
           [0.3365, 0.47162, 0.52369],      
           [0.34165, 0.47448, 0.52495],      
           [0.3468, 0.47736, 0.52626],      
           [0.35195, 0.48027, 0.52759],      
           [0.35714, 0.48318, 0.52897],      
           [0.36232, 0.48612, 0.53037],      
           [0.3675, 0.48906, 0.53182],      
           [0.3727, 0.49202, 0.53328],      
           [0.37791, 0.49499, 0.53478],      
           [0.38313, 0.49798, 0.53631],      
           [0.38834, 0.50096, 0.53786],      
           [0.39356, 0.50396, 0.53941],      
           [0.39878, 0.50695, 0.541],      
           [0.404, 0.50996, 0.5426],      
           [0.40922, 0.51298, 0.54421],      
           [0.41443, 0.51599, 0.54584],      
           [0.41965, 0.51903, 0.54747],      
           [0.42486, 0.52205, 0.54911],      
           [0.43006, 0.52509, 0.55075],      
           [0.43526, 0.52812, 0.5524],      
           [0.44043, 0.53115, 0.55404],      
           [0.4456, 0.53418, 0.55567],      
           [0.45078, 0.53722, 0.55732],      
           [0.45593, 0.54025, 0.55894],      
           [0.46106, 0.54328, 0.56056],      
           [0.46618, 0.54631, 0.56217],      
           [0.4713, 0.54933, 0.56376],      
           [0.47638, 0.55235, 0.56532],      
           [0.48145, 0.55536, 0.56688],      
           [0.48649, 0.55837, 0.56841],      
           [0.49153, 0.56138, 0.56991],      
           [0.49651, 0.56437, 0.57139],      
           [0.5015, 0.56736, 0.57285],      
           [0.50643, 0.57033, 0.57426],      
           [0.51135, 0.57331, 0.57566],      
           [0.51623, 0.57628, 0.57702],      
           [0.52109, 0.57922, 0.57833],      
           [0.52591, 0.58215, 0.57961],      
           [0.53069, 0.58508, 0.58085],      
           [0.53543, 0.58798, 0.58204],      
           [0.54014, 0.59087, 0.58319],      
           [0.5448, 0.59375, 0.5843],      
           [0.54942, 0.59662, 0.58536],      
           [0.55399, 0.59946, 0.58637],      
           [0.55851, 0.60229, 0.58732],      
           [0.563, 0.60509, 0.58822],      
           [0.56743, 0.60789, 0.58908],      
           [0.5718, 0.61065, 0.58988],      
           [0.57613, 0.61339, 0.59062],      
           [0.58039, 0.61612, 0.59131],      
           [0.5846, 0.61882, 0.59195],      
           [0.58874, 0.62149, 0.59252],      
           [0.59285, 0.62415, 0.59303],      
           [0.59688, 0.62677, 0.59348],      
           [0.60085, 0.62936, 0.59388],      
           [0.60476, 0.63194, 0.59421],      
           [0.60861, 0.63449, 0.59449],      
           [0.61239, 0.637, 0.5947],      
           [0.61611, 0.63949, 0.59486],      
           [0.61977, 0.64195, 0.59495],      
           [0.62335, 0.64438, 0.59499],      
           [0.62687, 0.64679, 0.59496],      
           [0.63033, 0.64916, 0.59488],      
           [0.63372, 0.65151, 0.59474],      
           [0.63704, 0.65382, 0.59454],      
           [0.6403, 0.65611, 0.59429],      
           [0.64349, 0.65836, 0.59398],      
           [0.64662, 0.66058, 0.59361],      
           [0.64969, 0.66278, 0.5932],      
           [0.65268, 0.66494, 0.59273],      
           [0.65562, 0.66708, 0.5922],      
           [0.6585, 0.66919, 0.59162],      
           [0.66131, 0.67127, 0.59099],      
           [0.66407, 0.67332, 0.59031],      
           [0.66676, 0.67535, 0.58959],      
           [0.66941, 0.67735, 0.58882],      
           [0.67199, 0.67932, 0.58801],      
           [0.67452, 0.68126, 0.58716],      
           [0.677, 0.68319, 0.58627],      
           [0.67941, 0.68509, 0.58534],      
           [0.68178, 0.68696, 0.58436],      
           [0.68411, 0.68881, 0.58334],      
           [0.68639, 0.69063, 0.58229],      
           [0.68862, 0.69245, 0.58121],      
           [0.6908, 0.69423, 0.5801],      
           [0.69296, 0.696, 0.57894],      
           [0.69506, 0.69774, 0.57776],      
           [0.69712, 0.69947, 0.57656],      
           [0.69915, 0.70119, 0.57532],      
           [0.70115, 0.70289, 0.57405],      
           [0.70311, 0.70457, 0.57277],      
           [0.70504, 0.70624, 0.57145],      
           [0.70694, 0.70789, 0.57012],      
           [0.70881, 0.70953, 0.56877],      
           [0.71065, 0.71116, 0.5674],      
           [0.71247, 0.71278, 0.566],      
           [0.71426, 0.71439, 0.56459],      
           [0.71604, 0.716, 0.56318],      
           [0.7178, 0.71759, 0.56174],      
           [0.71953, 0.71917, 0.56028],      
           [0.72124, 0.72075, 0.55881],      
           [0.72295, 0.72233, 0.55735],      
           [0.72464, 0.7239, 0.55585],      
           [0.72632, 0.72548, 0.55437],      
           [0.72799, 0.72705, 0.55288],      
           [0.72965, 0.72862, 0.55138],      
           [0.7313, 0.7302, 0.54988],      
           [0.73296, 0.73177, 0.54838],      
           [0.73461, 0.73335, 0.54687],      
           [0.73625, 0.73494, 0.54537],      
           [0.73789, 0.73652, 0.54387],      
           [0.73955, 0.73812, 0.54238],      
           [0.7412, 0.73974, 0.54089],      
           [0.74286, 0.74135, 0.53941],      
           [0.74453, 0.743, 0.53795],      
           [0.74621, 0.74464, 0.5365],      
           [0.7479, 0.74631, 0.53506],      
           [0.7496, 0.748, 0.53363],      
           [0.75133, 0.7497, 0.53225],      
           [0.75307, 0.75144, 0.53087],      
           [0.75484, 0.75318, 0.52952],      
           [0.75662, 0.75497, 0.5282],      
           [0.75844, 0.75678, 0.52692],      
           [0.76028, 0.75863, 0.52567],      
           [0.76216, 0.76051, 0.52445],      
           [0.76407, 0.76242, 0.52329],      
           [0.76603, 0.76438, 0.52216],      
           [0.76802, 0.76638, 0.52109],      
           [0.77006, 0.76843, 0.52008],      
           [0.77215, 0.77053, 0.51913],      
           [0.77428, 0.77269, 0.51825],      
           [0.77648, 0.77489, 0.51743],      
           [0.77873, 0.77717, 0.51669],      
           [0.78104, 0.7795, 0.51602],      
           [0.78342, 0.7819, 0.51545],      
           [0.78587, 0.78437, 0.51498],      
           [0.78839, 0.78691, 0.51461],      
           [0.79099, 0.78953, 0.51434],      
           [0.79367, 0.79223, 0.51418],      
           [0.79642, 0.79501, 0.51415],      
           [0.79927, 0.79787, 0.51424],      
           [0.80219, 0.80083, 0.51446],      
           [0.80521, 0.80388, 0.51482],      
           [0.80833, 0.80702, 0.51533],      
           [0.81154, 0.81024, 0.51599],      
           [0.81483, 0.81357, 0.51683],      
           [0.81823, 0.81699, 0.51782],      
           [0.82173, 0.8205, 0.51899],      
           [0.82531, 0.82411, 0.52032],      
           [0.829, 0.82782, 0.52184],      
           [0.83277, 0.83162, 0.52356],      
           [0.83664, 0.8355, 0.52546],      
           [0.8406, 0.83947, 0.52754],      
           [0.84463, 0.84352, 0.52983],      
           [0.84875, 0.84765, 0.53231],      
           [0.85294, 0.85185, 0.53497],      
           [0.85719, 0.85612, 0.53784],      
           [0.86151, 0.86045, 0.54089],      
           [0.86589, 0.86483, 0.54413],      
           [0.87031, 0.86927, 0.54755],      
           [0.87477, 0.87373, 0.55115],      
           [0.87927, 0.87824, 0.55492],      
           [0.88379, 0.88276, 0.55886],      
           [0.88833, 0.88731, 0.56296],      
           [0.89287, 0.89186, 0.56721],      
           [0.89743, 0.89642, 0.5716],      
           [0.90197, 0.90097, 0.57613],      
           [0.9065, 0.90551, 0.58077],      
           [0.91101, 0.91004, 0.58554],      
           [0.9155, 0.91453, 0.5904],      
           [0.91996, 0.919, 0.59537],      
           [0.92438, 0.92344, 0.60043],      
           [0.92876, 0.92784, 0.60556],      
           [0.9331, 0.9322, 0.61078],      
           [0.9374, 0.93652, 0.61605],      
           [0.94164, 0.94079, 0.62138],      
           [0.94584, 0.94502, 0.62676],      
           [0.94999, 0.9492, 0.63218],      
           [0.95409, 0.95334, 0.63764],      
           [0.95813, 0.95742, 0.64313],      
           [0.96213, 0.96146, 0.64864],      
           [0.96608, 0.96546, 0.65418],      
           [0.96998, 0.96942, 0.65974],      
           [0.97384, 0.97334, 0.66532],      
           [0.97766, 0.97722, 0.67091],      
           [0.98144, 0.98106, 0.67651],      
           [0.98519, 0.98488, 0.68211],      
           [0.9889, 0.98867, 0.68773],      
           [0.99259, 0.99243, 0.69335],      
           [0.99624, 0.99617, 0.69898]]      
      
nuuk_map = LinearSegmentedColormap.from_list('nuuk', cm_data)      
# For use of "viscm view"      
test_cm = nuuk_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(nuuk_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=nuuk_map)      
    plt.show()      
