# 
#         lisbon
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.90019, 0.89986, 0.99991],      
           [0.88957, 0.8921, 0.9936],      
           [0.87895, 0.88435, 0.9873],      
           [0.86836, 0.8766, 0.981],      
           [0.85776, 0.86888, 0.97471],      
           [0.84718, 0.86115, 0.96843],      
           [0.83662, 0.85344, 0.96215],      
           [0.82607, 0.84574, 0.95589],      
           [0.81553, 0.83806, 0.94962],      
           [0.80499, 0.83038, 0.94336],      
           [0.79448, 0.82271, 0.93711],      
           [0.78398, 0.81505, 0.93086],      
           [0.77348, 0.8074, 0.92462],      
           [0.763, 0.79976, 0.91838],      
           [0.75253, 0.79212, 0.91216],      
           [0.74208, 0.7845, 0.90593],      
           [0.73164, 0.77688, 0.89972],      
           [0.72122, 0.76927, 0.8935],      
           [0.71081, 0.76167, 0.8873],      
           [0.70041, 0.75408, 0.8811],      
           [0.69002, 0.74649, 0.87491],      
           [0.67965, 0.73892, 0.86872],      
           [0.6693, 0.73134, 0.86254],      
           [0.65896, 0.72378, 0.85636],      
           [0.64863, 0.71623, 0.85019],      
           [0.63832, 0.70868, 0.84402],      
           [0.62803, 0.70113, 0.83787],      
           [0.61774, 0.6936, 0.83171],      
           [0.60748, 0.68607, 0.82555],      
           [0.59723, 0.67854, 0.8194],      
           [0.58699, 0.67103, 0.81326],      
           [0.57678, 0.66352, 0.80713],      
           [0.56658, 0.65601, 0.80098],      
           [0.55639, 0.6485, 0.79485],      
           [0.54623, 0.641, 0.78872],      
           [0.53607, 0.63351, 0.78258],      
           [0.52594, 0.62601, 0.77644],      
           [0.51581, 0.61852, 0.7703],      
           [0.50571, 0.61104, 0.76416],      
           [0.49564, 0.60355, 0.75801],      
           [0.48558, 0.59606, 0.75185],      
           [0.47555, 0.58857, 0.74568],      
           [0.46551, 0.58109, 0.73951],      
           [0.45552, 0.57361, 0.73331],      
           [0.44554, 0.56612, 0.7271],      
           [0.4356, 0.55862, 0.72086],      
           [0.42566, 0.55113, 0.71459],      
           [0.41576, 0.54363, 0.70831],      
           [0.40589, 0.53612, 0.70197],      
           [0.39604, 0.52861, 0.69561],      
           [0.38621, 0.52108, 0.6892],      
           [0.37644, 0.51355, 0.68272],      
           [0.3667, 0.506, 0.6762],      
           [0.357, 0.49846, 0.66961],      
           [0.34734, 0.4909, 0.66295],      
           [0.33772, 0.48331, 0.65622],      
           [0.32816, 0.47573, 0.6494],      
           [0.31867, 0.46812, 0.64248],      
           [0.30926, 0.46051, 0.63547],      
           [0.29989, 0.45291, 0.62837],      
           [0.29062, 0.44528, 0.62115],      
           [0.28145, 0.43766, 0.61382],      
           [0.27237, 0.43002, 0.60638],      
           [0.26344, 0.42238, 0.59882],      
           [0.25462, 0.41477, 0.59114],      
           [0.2459, 0.40715, 0.58333],      
           [0.23739, 0.39954, 0.57541],      
           [0.22901, 0.39196, 0.56736],      
           [0.22082, 0.3844, 0.55919],      
           [0.21278, 0.37688, 0.55092],      
           [0.20499, 0.36938, 0.54253],      
           [0.1974, 0.36193, 0.53402],      
           [0.19002, 0.35453, 0.52543],      
           [0.18288, 0.34718, 0.51674],      
           [0.17599, 0.33988, 0.50798],      
           [0.1694, 0.33265, 0.49912],      
           [0.16302, 0.32546, 0.49021],      
           [0.15689, 0.31838, 0.48124],      
           [0.15103, 0.31136, 0.47222],      
           [0.14549, 0.30442, 0.46315],      
           [0.14012, 0.29756, 0.45407],      
           [0.13509, 0.29078, 0.44496],      
           [0.1303, 0.28408, 0.43583],      
           [0.12572, 0.27748, 0.42669],      
           [0.12135, 0.27096, 0.41756],      
           [0.11727, 0.2645, 0.40842],      
           [0.11345, 0.25812, 0.3993],      
           [0.10981, 0.25186, 0.39021],      
           [0.10635, 0.24564, 0.38115],      
           [0.10306, 0.23952, 0.37208],      
           [0.099941, 0.23345, 0.36307],      
           [0.097002, 0.2275, 0.35409],      
           [0.094303, 0.22159, 0.34515],      
           [0.091713, 0.21576, 0.33624],      
           [0.08922, 0.20999, 0.32738],      
           [0.086919, 0.20432, 0.31857],      
           [0.084717, 0.19867, 0.30982],      
           [0.082644, 0.19313, 0.30108],      
           [0.080696, 0.18768, 0.29243],      
           [0.078849, 0.18223, 0.28382],      
           [0.077157, 0.17692, 0.27529],      
           [0.075616, 0.17166, 0.26679],      
           [0.074219, 0.16651, 0.25838],      
           [0.072907, 0.16146, 0.25002],      
           [0.071722, 0.15647, 0.24178],      
           [0.070637, 0.15156, 0.23358],      
           [0.069756, 0.14679, 0.22551],      
           [0.068993, 0.14217, 0.21752],      
           [0.068301, 0.13767, 0.20963],      
           [0.067772, 0.13328, 0.20186],      
           [0.067395, 0.12903, 0.19427],      
           [0.067165, 0.12499, 0.18675],      
           [0.067086, 0.1211, 0.17943],      
           [0.06716, 0.11745, 0.17227],      
           [0.06739, 0.114, 0.1653],      
           [0.067779, 0.11082, 0.1586],      
           [0.068337, 0.10781, 0.15205],      
           [0.069084, 0.1051, 0.14582],      
           [0.069909, 0.10272, 0.13976],      
           [0.070958, 0.10059, 0.13409],      
           [0.07215, 0.098812, 0.12866],      
           [0.073639, 0.097347, 0.12356],      
           [0.075176, 0.096199, 0.11887],      
           [0.076956, 0.095493, 0.11442],      
           [0.078977, 0.095119, 0.11047],      
           [0.081272, 0.095095, 0.10685],      
           [0.08373, 0.095427, 0.10358],      
           [0.086376, 0.0961, 0.10069],      
           [0.089318, 0.097212, 0.098263],      
           [0.092445, 0.098697, 0.096142],      
           [0.095823, 0.1005, 0.094539],      
           [0.099434, 0.1027, 0.093176],      
           [0.10331, 0.10518, 0.092312],      
           [0.10736, 0.10803, 0.091807],      
           [0.11165, 0.11122, 0.091623],      
           [0.11615, 0.11461, 0.091779],      
           [0.12079, 0.11839, 0.092234],      
           [0.12572, 0.1223, 0.092972],      
           [0.13079, 0.12655, 0.094115],      
           [0.13596, 0.13101, 0.09548],      
           [0.14139, 0.13561, 0.097052],      
           [0.14689, 0.14047, 0.098938],      
           [0.15255, 0.1455, 0.10101],      
           [0.15837, 0.15062, 0.10334],      
           [0.16427, 0.15594, 0.1058],      
           [0.17026, 0.16138, 0.10841],      
           [0.17633, 0.16692, 0.11128],      
           [0.18252, 0.17255, 0.11419],      
           [0.18882, 0.17834, 0.11728],      
           [0.19515, 0.18416, 0.12049],      
           [0.20155, 0.19009, 0.12381],      
           [0.20805, 0.19611, 0.12723],      
           [0.21458, 0.20216, 0.13079],      
           [0.22119, 0.20831, 0.13438],      
           [0.22783, 0.2145, 0.13805],      
           [0.23454, 0.22078, 0.14177],      
           [0.24127, 0.22707, 0.14559],      
           [0.24807, 0.23339, 0.14942],      
           [0.2549, 0.2398, 0.1533],      
           [0.26176, 0.24624, 0.15725],      
           [0.26868, 0.25273, 0.16129],      
           [0.27563, 0.25926, 0.16528],      
           [0.28262, 0.26581, 0.16941],      
           [0.28963, 0.27238, 0.17349],      
           [0.29669, 0.27902, 0.17766],      
           [0.30376, 0.28566, 0.18179],      
           [0.3109, 0.29236, 0.18603],      
           [0.31804, 0.29909, 0.19023],      
           [0.32522, 0.30585, 0.19452],      
           [0.33245, 0.31261, 0.19876],      
           [0.3397, 0.31943, 0.20308],      
           [0.34697, 0.32626, 0.20741],      
           [0.35426, 0.33314, 0.21177],      
           [0.3616, 0.34004, 0.21615],      
           [0.36896, 0.34696, 0.22055],      
           [0.37635, 0.3539, 0.22493],      
           [0.38376, 0.36087, 0.22938],      
           [0.3912, 0.36788, 0.23384],      
           [0.39866, 0.37491, 0.23833],      
           [0.40617, 0.38197, 0.24285],      
           [0.41369, 0.38907, 0.24741],      
           [0.42124, 0.39618, 0.25198],      
           [0.42882, 0.40333, 0.25657],      
           [0.43643, 0.41052, 0.26122],      
           [0.44408, 0.41772, 0.2659],      
           [0.45174, 0.42496, 0.27062],      
           [0.45943, 0.43224, 0.27538],      
           [0.46716, 0.43954, 0.28017],      
           [0.47492, 0.44688, 0.28502],      
           [0.48269, 0.45427, 0.28994],      
           [0.49051, 0.46168, 0.29492],      
           [0.49836, 0.46915, 0.29998],      
           [0.50622, 0.47664, 0.3051],      
           [0.51414, 0.48418, 0.31031],      
           [0.52207, 0.49178, 0.3156],      
           [0.53005, 0.4994, 0.32098],      
           [0.53805, 0.50709, 0.32645],      
           [0.54608, 0.51482, 0.33206],      
           [0.55413, 0.52259, 0.33776],      
           [0.56223, 0.53042, 0.34359],      
           [0.57033, 0.5383, 0.34955],      
           [0.57847, 0.54623, 0.35565],      
           [0.58663, 0.5542, 0.36188],      
           [0.59481, 0.56223, 0.36826],      
           [0.60301, 0.57029, 0.37478],      
           [0.61122, 0.57841, 0.38147],      
           [0.61944, 0.58657, 0.38831],      
           [0.62766, 0.59478, 0.39532],      
           [0.63589, 0.60302, 0.40247],      
           [0.64412, 0.6113, 0.40981],      
           [0.65234, 0.61961, 0.41731],      
           [0.66055, 0.62795, 0.42496],      
           [0.66876, 0.63632, 0.43277],      
           [0.67694, 0.6447, 0.44072],      
           [0.6851, 0.6531, 0.44885],      
           [0.69323, 0.66153, 0.45711],      
           [0.70133, 0.66997, 0.46551],      
           [0.70942, 0.67841, 0.47407],      
           [0.71746, 0.68685, 0.48274],      
           [0.72547, 0.6953, 0.49156],      
           [0.73343, 0.70375, 0.50046],      
           [0.74136, 0.7122, 0.5095],      
           [0.74926, 0.72065, 0.51864],      
           [0.75712, 0.72909, 0.52786],      
           [0.76495, 0.73752, 0.53719],      
           [0.77273, 0.74596, 0.5466],      
           [0.78049, 0.75439, 0.55608],      
           [0.78821, 0.7628, 0.56564],      
           [0.7959, 0.77122, 0.57527],      
           [0.80357, 0.77962, 0.58497],      
           [0.81121, 0.78803, 0.59472],      
           [0.81882, 0.79643, 0.60453],      
           [0.82642, 0.80483, 0.61437],      
           [0.834, 0.81323, 0.62428],      
           [0.84156, 0.82163, 0.63423],      
           [0.84911, 0.83004, 0.64421],      
           [0.85665, 0.83844, 0.65423],      
           [0.86419, 0.84685, 0.66429],      
           [0.87171, 0.85527, 0.67438],      
           [0.87923, 0.8637, 0.6845],      
           [0.88675, 0.87213, 0.69466],      
           [0.89427, 0.88056, 0.70484],      
           [0.90179, 0.88902, 0.71505],      
           [0.90931, 0.89748, 0.7253],      
           [0.91683, 0.90595, 0.73555],      
           [0.92435, 0.91443, 0.74584],      
           [0.93188, 0.92293, 0.75615],      
           [0.93942, 0.93143, 0.76649],      
           [0.94696, 0.93996, 0.77685],      
           [0.9545, 0.94849, 0.78723],      
           [0.96204, 0.95704, 0.79763],      
           [0.9696, 0.9656, 0.80806],      
           [0.97716, 0.97418, 0.81851],      
           [0.98473, 0.98277, 0.82899],      
           [0.9923, 0.99138, 0.83948],      
           [0.99987, 1, 0.84999]]      
      
lisbon_map = LinearSegmentedColormap.from_list('lisbon', cm_data)      
# For use of "viscm view"      
test_cm = lisbon_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(lisbon_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=lisbon_map)      
    plt.show()      
