# 
#         lajollaS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.99983, 0.99974, 0.79991],      
           [0.10023, 0.10091, 0.0037913],      
           [0.86973, 0.45582, 0.31068],      
           [0.94802, 0.76354, 0.37498],      
           [0.49809, 0.23315, 0.20576],      
           [0.98278, 0.91253, 0.57381],      
           [0.91381, 0.60672, 0.32439],      
           [0.28496, 0.16607, 0.1061],      
           [0.72238, 0.30998, 0.27958],      
           [0.1874, 0.13354, 0.062323],      
           [0.9931, 0.95921, 0.68789],      
           [0.96754, 0.84738, 0.4604],      
           [0.9298, 0.68157, 0.33699],      
           [0.61029, 0.26633, 0.24848],      
           [0.389, 0.1997, 0.1555],      
           [0.89674, 0.53312, 0.31778],      
           [0.81242, 0.37438, 0.29885],      
           [0.55391, 0.24948, 0.22849],      
           [0.14225, 0.11735, 0.03474],      
           [0.90574, 0.57009, 0.32091],      
           [0.95797, 0.80656, 0.41183],      
           [0.44303, 0.2166, 0.18105],      
           [0.97589, 0.88298, 0.51602],      
           [0.93853, 0.72144, 0.35096],      
           [0.88549, 0.4952, 0.31451],      
           [0.66685, 0.28556, 0.26546],      
           [0.8463, 0.41502, 0.30567],      
           [0.99693, 0.97973, 0.74399],      
           [0.98842, 0.93731, 0.63126],      
           [0.23526, 0.1497, 0.083951],      
           [0.33625, 0.18278, 0.13021],      
           [0.92169, 0.64362, 0.32917],      
           [0.77392, 0.34151, 0.29098],      
           [0.83077, 0.3945, 0.30251],      
           [0.47045, 0.2249, 0.1936],      
           [0.93407, 0.70122, 0.34297],      
           [0.89151, 0.51432, 0.3162],      
           [0.9719, 0.86595, 0.48769],      
           [0.16445, 0.12548, 0.04964],      
           [0.87836, 0.47572, 0.31269],      
           [0.85918, 0.43556, 0.30835],      
           [0.96286, 0.82747, 0.4349],      
           [0.99087, 0.94851, 0.65967],      
           [0.99512, 0.96958, 0.71599],      
           [0.31043, 0.17441, 0.11793],      
           [0.41587, 0.20818, 0.16831],      
           [0.95298, 0.7851, 0.39176],      
           [0.211, 0.14161, 0.073581],      
           [0.63859, 0.2755, 0.25734],      
           [0.69488, 0.29697, 0.27286],      
           [0.12086, 0.1092, 0.019283],      
           [0.99851, 0.98977, 0.77195],      
           [0.90983, 0.58841, 0.32257],      
           [0.90141, 0.55169, 0.31934],      
           [0.74891, 0.32481, 0.28559],      
           [0.98573, 0.92539, 0.60264],      
           [0.52592, 0.24134, 0.21742],      
           [0.97951, 0.89846, 0.54486],      
           [0.58204, 0.25775, 0.23883],      
           [0.36245, 0.19124, 0.14274],      
           [0.92569, 0.66242, 0.33255],      
           [0.94319, 0.74225, 0.36147],      
           [0.91775, 0.62509, 0.32653],      
           [0.25991, 0.15783, 0.094764],      
           [0.79686, 0.35981, 0.2957],      
           [0.95049, 0.7743, 0.38296],      
           [0.70873, 0.30323, 0.27631],      
           [0.86473, 0.44572, 0.30956],      
           [0.90781, 0.57926, 0.32172],      
           [0.96523, 0.83758, 0.44738],      
           [0.29764, 0.17023, 0.11196],      
           [0.27237, 0.16197, 0.10032],      
           [0.94083, 0.73178, 0.35587],      
           [0.7358, 0.31716, 0.28268],      
           [0.42941, 0.2124, 0.17473],      
           [0.15323, 0.12139, 0.042482],      
           [0.22307, 0.14566, 0.078687],      
           [0.91971, 0.63434, 0.32777],      
           [0.98119, 0.90566, 0.55934],      
           [0.4567, 0.22079, 0.18738],      
           [0.98967, 0.94298, 0.64549],      
           [0.97775, 0.89091, 0.53041],      
           [0.91577, 0.61589, 0.32541],      
           [0.34931, 0.18702, 0.13639],      
           [0.82195, 0.38436, 0.30075],      
           [0.78568, 0.35049, 0.29341],      
           [0.19909, 0.13759, 0.068084],      
           [0.85306, 0.42531, 0.30705],      
           [0.99921, 0.99476, 0.78593],      
           [0.48423, 0.22906, 0.1997],      
           [0.76164, 0.33295, 0.28837],      
           [0.89913, 0.54243, 0.31856],      
           [0.95548, 0.79587, 0.40139],      
           [0.94558, 0.75284, 0.36782],      
           [0.88862, 0.50481, 0.31537],      
           [0.96976, 0.85685, 0.47387],      
           [0.99606, 0.97467, 0.73],      
           [0.97394, 0.87466, 0.50176],      
           [0.93191, 0.69133, 0.33977],      
           [0.96044, 0.81711, 0.42301]]      
      
lajollaS_map = LinearSegmentedColormap.from_list('lajollaS', cm_data)      
# For use of "viscm view"      
test_cm = lajollaS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(lajollaS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=lajollaS_map)      
    plt.show()      
