# 
#         imola
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.10144, 0.20011, 0.70019],      
           [0.10328, 0.20301, 0.69881],      
           [0.10496, 0.2059, 0.69742],      
           [0.10673, 0.20873, 0.69605],      
           [0.1083, 0.21157, 0.69466],      
           [0.10998, 0.21437, 0.69329],      
           [0.11152, 0.21716, 0.69191],      
           [0.11307, 0.21994, 0.69053],      
           [0.1145, 0.2227, 0.68917],      
           [0.11603, 0.22544, 0.6878],      
           [0.11744, 0.22819, 0.68643],      
           [0.11891, 0.23089, 0.68508],      
           [0.12028, 0.23359, 0.68371],      
           [0.12166, 0.23631, 0.68236],      
           [0.12304, 0.23898, 0.68101],      
           [0.12442, 0.24167, 0.67966],      
           [0.12581, 0.24432, 0.67832],      
           [0.12711, 0.247, 0.67698],      
           [0.12847, 0.24964, 0.67564],      
           [0.12983, 0.2523, 0.67431],      
           [0.13114, 0.25495, 0.67298],      
           [0.13245, 0.25757, 0.67165],      
           [0.13376, 0.2602, 0.67033],      
           [0.13507, 0.26282, 0.669],      
           [0.13633, 0.26543, 0.66768],      
           [0.13768, 0.26803, 0.66636],      
           [0.13894, 0.27067, 0.66505],      
           [0.14023, 0.27326, 0.66374],      
           [0.14154, 0.27587, 0.66243],      
           [0.14282, 0.27845, 0.66112],      
           [0.14411, 0.28103, 0.65982],      
           [0.14542, 0.28363, 0.65851],      
           [0.14665, 0.2862, 0.65721],      
           [0.14795, 0.2888, 0.65591],      
           [0.14923, 0.29139, 0.65461],      
           [0.1505, 0.29395, 0.65331],      
           [0.15176, 0.29654, 0.65202],      
           [0.15303, 0.29912, 0.65072],      
           [0.15432, 0.30167, 0.64943],      
           [0.15561, 0.30425, 0.64813],      
           [0.15688, 0.30683, 0.64684],      
           [0.15816, 0.30941, 0.64554],      
           [0.15942, 0.31195, 0.64425],      
           [0.16069, 0.31453, 0.64296],      
           [0.162, 0.31711, 0.64166],      
           [0.16327, 0.31968, 0.64038],      
           [0.16454, 0.32224, 0.63908],      
           [0.16579, 0.3248, 0.63778],      
           [0.16711, 0.32737, 0.63649],      
           [0.16838, 0.32995, 0.63519],      
           [0.16969, 0.33252, 0.63389],      
           [0.17096, 0.33508, 0.63258],      
           [0.17225, 0.33763, 0.63128],      
           [0.17355, 0.3402, 0.62996],      
           [0.17488, 0.34276, 0.62865],      
           [0.17615, 0.34531, 0.62732],      
           [0.17752, 0.34788, 0.62599],      
           [0.17884, 0.35043, 0.62466],      
           [0.18016, 0.35298, 0.62331],      
           [0.1815, 0.35554, 0.62195],      
           [0.18287, 0.35807, 0.62059],      
           [0.18426, 0.3606, 0.61922],      
           [0.18569, 0.36314, 0.61782],      
           [0.18708, 0.36567, 0.61641],      
           [0.18851, 0.36819, 0.61498],      
           [0.18994, 0.37069, 0.61354],      
           [0.19141, 0.3732, 0.61208],      
           [0.19291, 0.37569, 0.61061],      
           [0.19445, 0.37818, 0.60911],      
           [0.19597, 0.38066, 0.60758],      
           [0.19753, 0.38312, 0.60602],      
           [0.1991, 0.38556, 0.60446],      
           [0.20072, 0.388, 0.60285],      
           [0.20237, 0.39043, 0.60122],      
           [0.20408, 0.39284, 0.59957],      
           [0.20577, 0.39524, 0.59788],      
           [0.2075, 0.39762, 0.59617],      
           [0.20925, 0.39999, 0.59443],      
           [0.21105, 0.40234, 0.59266],      
           [0.21285, 0.40469, 0.59085],      
           [0.2147, 0.40702, 0.58902],      
           [0.21659, 0.40934, 0.58717],      
           [0.21847, 0.41164, 0.5853],      
           [0.22041, 0.41394, 0.58339],      
           [0.22233, 0.41622, 0.58145],      
           [0.22427, 0.41849, 0.57951],      
           [0.22629, 0.42075, 0.57752],      
           [0.2283, 0.423, 0.57553],      
           [0.23029, 0.42526, 0.57351],      
           [0.23235, 0.42751, 0.57147],      
           [0.23442, 0.42974, 0.56941],      
           [0.23649, 0.43198, 0.56735],      
           [0.23856, 0.43419, 0.56526],      
           [0.24066, 0.43643, 0.56318],      
           [0.24278, 0.43865, 0.56106],      
           [0.24491, 0.44088, 0.55895],      
           [0.24707, 0.44313, 0.55684],      
           [0.24923, 0.44536, 0.55471],      
           [0.25141, 0.44759, 0.55258],      
           [0.25359, 0.44985, 0.55045],      
           [0.25578, 0.45212, 0.54832],      
           [0.25799, 0.45438, 0.54619],      
           [0.26024, 0.45666, 0.54406],      
           [0.26249, 0.45896, 0.54194],      
           [0.26475, 0.46126, 0.53983],      
           [0.26703, 0.46359, 0.53775],      
           [0.26936, 0.46593, 0.53565],      
           [0.27167, 0.4683, 0.53358],      
           [0.27404, 0.4707, 0.53154],      
           [0.27644, 0.47311, 0.52952],      
           [0.27885, 0.47557, 0.52751],      
           [0.28127, 0.47804, 0.52553],      
           [0.28375, 0.48054, 0.52358],      
           [0.28625, 0.48309, 0.52165],      
           [0.28882, 0.48567, 0.51977],      
           [0.29141, 0.48829, 0.51792],      
           [0.29401, 0.49095, 0.5161],      
           [0.29669, 0.49364, 0.51433],      
           [0.2994, 0.49638, 0.51259],      
           [0.30213, 0.49917, 0.5109],      
           [0.30494, 0.502, 0.50925],      
           [0.30776, 0.50487, 0.50764],      
           [0.31067, 0.5078, 0.50607],      
           [0.31359, 0.51076, 0.50456],      
           [0.31656, 0.51377, 0.50307],      
           [0.31958, 0.51683, 0.50165],      
           [0.32265, 0.51992, 0.50025],      
           [0.32573, 0.52308, 0.4989],      
           [0.3289, 0.52626, 0.4976],      
           [0.33208, 0.52949, 0.49631],      
           [0.33532, 0.53276, 0.49508],      
           [0.33856, 0.53606, 0.49387],      
           [0.34187, 0.5394, 0.49269],      
           [0.34521, 0.54278, 0.49157],      
           [0.34858, 0.54619, 0.49045],      
           [0.35197, 0.54963, 0.48934],      
           [0.35542, 0.55309, 0.48829],      
           [0.35885, 0.5566, 0.48724],      
           [0.36235, 0.56012, 0.4862],      
           [0.36585, 0.56367, 0.48519],      
           [0.36938, 0.56724, 0.48419],      
           [0.37293, 0.57082, 0.4832],      
           [0.37652, 0.57443, 0.48223],      
           [0.3801, 0.57806, 0.48125],      
           [0.38371, 0.58171, 0.4803],      
           [0.38733, 0.58538, 0.47934],      
           [0.39098, 0.58905, 0.47839],      
           [0.39463, 0.59275, 0.47744],      
           [0.39831, 0.59645, 0.4765],      
           [0.40198, 0.60017, 0.47556],      
           [0.40569, 0.60391, 0.47462],      
           [0.4094, 0.60765, 0.47366],      
           [0.41313, 0.6114, 0.47272],      
           [0.41686, 0.61516, 0.47179],      
           [0.4206, 0.61895, 0.47084],      
           [0.42436, 0.62273, 0.4699],      
           [0.42813, 0.62653, 0.46895],      
           [0.43192, 0.63035, 0.468],      
           [0.43571, 0.63417, 0.46706],      
           [0.43951, 0.638, 0.46609],      
           [0.44332, 0.64184, 0.46514],      
           [0.44714, 0.64569, 0.4642],      
           [0.45098, 0.64956, 0.46322],      
           [0.45484, 0.65343, 0.46226],      
           [0.45869, 0.65732, 0.46131],      
           [0.46255, 0.66121, 0.46033],      
           [0.46643, 0.66511, 0.45937],      
           [0.47033, 0.66903, 0.4584],      
           [0.47423, 0.67296, 0.45742],      
           [0.47814, 0.67689, 0.45645],      
           [0.48206, 0.68083, 0.45547],      
           [0.48599, 0.68479, 0.4545],      
           [0.48994, 0.68877, 0.4535],      
           [0.4939, 0.69275, 0.45253],      
           [0.49787, 0.69673, 0.45153],      
           [0.50185, 0.70073, 0.45054],      
           [0.50583, 0.70474, 0.44955],      
           [0.50983, 0.70877, 0.44855],      
           [0.51385, 0.71279, 0.44754],      
           [0.51788, 0.71685, 0.44654],      
           [0.5219, 0.72089, 0.44553],      
           [0.52596, 0.72497, 0.44454],      
           [0.53002, 0.72904, 0.44352],      
           [0.53409, 0.73313, 0.44251],      
           [0.53819, 0.73723, 0.44149],      
           [0.54228, 0.74134, 0.44047],      
           [0.5464, 0.74546, 0.43945],      
           [0.55052, 0.74959, 0.43843],      
           [0.55466, 0.75374, 0.43741],      
           [0.55881, 0.7579, 0.43638],      
           [0.563, 0.76207, 0.43535],      
           [0.5672, 0.76625, 0.43431],      
           [0.57141, 0.77044, 0.43327],      
           [0.57565, 0.77464, 0.43225],      
           [0.57992, 0.77886, 0.43121],      
           [0.5842, 0.78309, 0.43016],      
           [0.58853, 0.78733, 0.42912],      
           [0.5929, 0.79158, 0.42808],      
           [0.5973, 0.79584, 0.42705],      
           [0.60174, 0.80012, 0.426],      
           [0.60624, 0.8044, 0.42497],      
           [0.6108, 0.80869, 0.42393],      
           [0.61541, 0.81299, 0.42289],      
           [0.62011, 0.81731, 0.42187],      
           [0.62487, 0.82163, 0.42085],      
           [0.62973, 0.82595, 0.41984],      
           [0.63468, 0.83028, 0.41883],      
           [0.63974, 0.83461, 0.41784],      
           [0.6449, 0.83894, 0.41687],      
           [0.65019, 0.84326, 0.41589],      
           [0.6556, 0.84759, 0.41494],      
           [0.66115, 0.8519, 0.41401],      
           [0.66684, 0.8562, 0.4131],      
           [0.67269, 0.86048, 0.41221],      
           [0.67868, 0.86474, 0.41134],      
           [0.68483, 0.86898, 0.41052],      
           [0.69114, 0.87318, 0.4097],      
           [0.69761, 0.87735, 0.40892],      
           [0.70424, 0.88148, 0.40818],      
           [0.71102, 0.88557, 0.40747],      
           [0.71795, 0.8896, 0.4068],      
           [0.72504, 0.89358, 0.40617],      
           [0.73226, 0.89751, 0.40557],      
           [0.73962, 0.90138, 0.40501],      
           [0.74709, 0.90518, 0.40448],      
           [0.75469, 0.90892, 0.40401],      
           [0.76238, 0.9126, 0.40357],      
           [0.77017, 0.9162, 0.40317],      
           [0.77806, 0.91975, 0.4028],      
           [0.78601, 0.92323, 0.40246],      
           [0.79403, 0.92664, 0.40216],      
           [0.80211, 0.92999, 0.40189],      
           [0.81023, 0.93328, 0.40166],      
           [0.8184, 0.93653, 0.40145],      
           [0.8266, 0.93971, 0.40127],      
           [0.83482, 0.94285, 0.40112],      
           [0.84307, 0.94593, 0.40098],      
           [0.85132, 0.94898, 0.40086],      
           [0.8596, 0.95199, 0.40075],      
           [0.86788, 0.95497, 0.40067],      
           [0.87616, 0.95791, 0.40059],      
           [0.88445, 0.96083, 0.40052],      
           [0.89274, 0.96371, 0.40047],      
           [0.90102, 0.96658, 0.40042],      
           [0.9093, 0.96943, 0.40038],      
           [0.91758, 0.97226, 0.40034],      
           [0.92584, 0.97507, 0.40031],      
           [0.93411, 0.97788, 0.40028],      
           [0.94237, 0.98067, 0.40026],      
           [0.95062, 0.98345, 0.40023],      
           [0.95887, 0.98623, 0.40021],      
           [0.96711, 0.98899, 0.40019],      
           [0.97534, 0.99175, 0.40017],      
           [0.98357, 0.9945, 0.40014],      
           [0.9918, 0.99724, 0.40012],      
           [1, 0.99999, 0.40009]]      
      
imola_map = LinearSegmentedColormap.from_list('imola', cm_data)      
# For use of "viscm view"      
test_cm = imola_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(imola_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=imola_map)      
    plt.show()      
