# 
#         imolaS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.10144, 0.20011, 0.70019],      
           [1, 0.99999, 0.40009],      
           [0.32573, 0.52308, 0.4989],      
           [0.5672, 0.76625, 0.43431],      
           [0.18851, 0.36819, 0.61498],      
           [0.73962, 0.90138, 0.40501],      
           [0.43951, 0.638, 0.46609],      
           [0.14665, 0.2862, 0.65721],      
           [0.24707, 0.44313, 0.55684],      
           [0.3801, 0.57806, 0.48125],      
           [0.63974, 0.83461, 0.41784],      
           [0.2147, 0.40702, 0.58902],      
           [0.86788, 0.95497, 0.40067],      
           [0.50185, 0.70073, 0.45054],      
           [0.12581, 0.24432, 0.67832],      
           [0.16711, 0.32737, 0.63649],      
           [0.28375, 0.48054, 0.52358],      
           [0.20072, 0.388, 0.60285],      
           [0.68483, 0.86898, 0.41052],      
           [0.35197, 0.54963, 0.48934],      
           [0.26475, 0.46126, 0.53983],      
           [0.80211, 0.92999, 0.40189],      
           [0.93411, 0.97788, 0.40028],      
           [0.1145, 0.2227, 0.68917],      
           [0.47033, 0.66903, 0.4584],      
           [0.15688, 0.30683, 0.64684],      
           [0.23029, 0.42526, 0.57351],      
           [0.17752, 0.34788, 0.62599],      
           [0.60174, 0.80012, 0.426],      
           [0.4094, 0.60765, 0.47366],      
           [0.53409, 0.73313, 0.44251],      
           [0.13633, 0.26543, 0.66768],      
           [0.30494, 0.502, 0.50925],      
           [0.45484, 0.65343, 0.46226],      
           [0.22233, 0.41622, 0.58145],      
           [0.25578, 0.45212, 0.54832],      
           [0.23856, 0.43419, 0.56526],      
           [0.33856, 0.53606, 0.49387],      
           [0.39463, 0.59275, 0.47744],      
           [0.83482, 0.94285, 0.40112],      
           [0.15176, 0.29654, 0.65202],      
           [0.19445, 0.37818, 0.60911],      
           [0.48599, 0.68479, 0.4545],      
           [0.36585, 0.56367, 0.48519],      
           [0.17225, 0.33763, 0.63128],      
           [0.55052, 0.74959, 0.43843],      
           [0.77017, 0.9162, 0.40317],      
           [0.12028, 0.23359, 0.68371],      
           [0.29401, 0.49095, 0.5161],      
           [0.13114, 0.25495, 0.67298],      
           [0.51788, 0.71685, 0.44654],      
           [0.5842, 0.78309, 0.43016],      
           [0.71102, 0.88557, 0.40747],      
           [0.162, 0.31711, 0.64166],      
           [0.42436, 0.62273, 0.4699],      
           [0.27404, 0.4707, 0.53154],      
           [0.90102, 0.96658, 0.40042],      
           [0.62011, 0.81731, 0.42187],      
           [0.18287, 0.35807, 0.62059],      
           [0.14154, 0.27587, 0.66243],      
           [0.2075, 0.39762, 0.59617],      
           [0.1083, 0.21157, 0.69466],      
           [0.66115, 0.8519, 0.41401],      
           [0.96711, 0.98899, 0.40019],      
           [0.31656, 0.51377, 0.50307],      
           [0.10496, 0.2059, 0.69742],      
           [0.25141, 0.44759, 0.55258],      
           [0.78601, 0.92323, 0.40246],      
           [0.21847, 0.41164, 0.5853],      
           [0.43192, 0.63035, 0.468],      
           [0.20408, 0.39284, 0.59957],      
           [0.14923, 0.29139, 0.65461],      
           [0.26936, 0.46593, 0.53565],      
           [0.65019, 0.84326, 0.41589],      
           [0.95062, 0.98345, 0.40023],      
           [0.69761, 0.87735, 0.40892],      
           [0.13376, 0.2602, 0.67033],      
           [0.23442, 0.42974, 0.56941],      
           [0.18016, 0.35298, 0.62331],      
           [0.22629, 0.42075, 0.57752],      
           [0.98357, 0.9945, 0.40014],      
           [0.38733, 0.58538, 0.47934],      
           [0.55881, 0.7579, 0.43638],      
           [0.62973, 0.82595, 0.41984],      
           [0.15942, 0.31195, 0.64425],      
           [0.75469, 0.90892, 0.40401],      
           [0.13894, 0.27067, 0.66505],      
           [0.52596, 0.72497, 0.44454],      
           [0.50983, 0.70877, 0.44855],      
           [0.47814, 0.67689, 0.45645],      
           [0.15432, 0.30167, 0.64943],      
           [0.2994, 0.49638, 0.51259],      
           [0.34521, 0.54278, 0.49157],      
           [0.35885, 0.5566, 0.48724],      
           [0.72504, 0.89358, 0.40617],      
           [0.46255, 0.66121, 0.46033],      
           [0.5929, 0.79158, 0.42808],      
           [0.31067, 0.5078, 0.50607],      
           [0.88445, 0.96083, 0.40052],      
           [0.11744, 0.22819, 0.68643]]      
      
imolaS_map = LinearSegmentedColormap.from_list('imolaS', cm_data)      
# For use of "viscm view"      
test_cm = imolaS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(imolaS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=imolaS_map)      
    plt.show()      
