# 
#         grayCS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.97775, 0.97775, 0.97775],      
           [0.022447, 0.022447, 0.022447],      
           [0.4644, 0.4644, 0.4644],      
           [0.71029, 0.71029, 0.71029],      
           [0.24026, 0.24026, 0.24026],      
           [0.13737, 0.13737, 0.13737],      
           [0.84203, 0.84203, 0.84203],      
           [0.58295, 0.58295, 0.58295],      
           [0.34737, 0.34737, 0.34737],      
           [0.77351, 0.77351, 0.77351],      
           [0.087931, 0.087933, 0.087932],      
           [0.90723, 0.90723, 0.90723],      
           [0.18938, 0.18938, 0.18938],      
           [0.64809, 0.64809, 0.64809],      
           [0.40702, 0.40702, 0.40702],      
           [0.29298, 0.29298, 0.29298],      
           [0.52307, 0.52307, 0.52307],      
           [0.11234, 0.11234, 0.11234],      
           [0.61536, 0.61536, 0.61536],      
           [0.80763, 0.80763, 0.80763],      
           [0.16307, 0.16307, 0.16307],      
           [0.94237, 0.94237, 0.94237],      
           [0.37699, 0.37699, 0.37699],      
           [0.55486, 0.55486, 0.55486],      
           [0.87668, 0.87668, 0.87668],      
           [0.2163, 0.2163, 0.2163],      
           [0.73967, 0.73967, 0.73967],      
           [0.43746, 0.43746, 0.43746],      
           [0.49162, 0.49162, 0.49162],      
           [0.058816, 0.058816, 0.058816],      
           [0.68113, 0.68113, 0.68113],      
           [0.26465, 0.26465, 0.26465],      
           [0.32179, 0.32179, 0.32179],      
           [0.20275, 0.20275, 0.20275],      
           [0.79053, 0.79053, 0.79053],      
           [0.75655, 0.75655, 0.75655],      
           [0.074504, 0.074505, 0.074505],      
           [0.39195, 0.39195, 0.39195],      
           [0.63169, 0.63169, 0.63169],      
           [0.10006, 0.10006, 0.10006],      
           [0.15014, 0.15014, 0.15014],      
           [0.85932, 0.85932, 0.85932],      
           [0.96003, 0.96003, 0.96003],      
           [0.30732, 0.30732, 0.30732],      
           [0.17611, 0.17611, 0.17611],      
           [0.82479, 0.82479, 0.82479],      
           [0.92476, 0.92476, 0.92476],      
           [0.42218, 0.42218, 0.42218],      
           [0.36212, 0.36212, 0.36212],      
           [0.5073, 0.5073, 0.5073],      
           [0.66457, 0.66457, 0.66457],      
           [0.27877, 0.27877, 0.27877],      
           [0.12473, 0.12473, 0.12473],      
           [0.59912, 0.59912, 0.59912],      
           [0.53892, 0.53892, 0.53892],      
           [0.44897, 0.44897, 0.44897],      
           [0.33272, 0.33272, 0.33272],      
           [0.69776, 0.69776, 0.69776],      
           [0.22652, 0.22652, 0.22652],      
           [0.25067, 0.25067, 0.25067],      
           [0.47603, 0.47603, 0.47603],      
           [0.72705, 0.72705, 0.72705],      
           [0.89411, 0.89411, 0.89411],      
           [0.044716, 0.044716, 0.044716],      
           [0.57088, 0.57088, 0.57088],      
           [0.1062, 0.1062, 0.1062],      
           [0.49944, 0.49944, 0.49944],      
           [0.15658, 0.15658, 0.15658],      
           [0.19606, 0.19606, 0.19606],      
           [0.79908, 0.79908, 0.79908],      
           [0.71866, 0.71866, 0.71866],      
           [0.93355, 0.93355, 0.93355],      
           [0.36953, 0.36953, 0.36953],      
           [0.23336, 0.23336, 0.23336],      
           [0.4838, 0.4838, 0.4838],      
           [0.95119, 0.95119, 0.95119],      
           [0.033552, 0.033552, 0.033552],      
           [0.45666, 0.45666, 0.45666],      
           [0.63989, 0.63989, 0.63989],      
           [0.81621, 0.81621, 0.81621],      
           [0.34003, 0.34003, 0.34003],      
           [0.39946, 0.39946, 0.39946],      
           [0.25764, 0.25764, 0.25764],      
           [0.8334, 0.8334, 0.8334],      
           [0.60724, 0.60724, 0.60724],      
           [0.85066, 0.85066, 0.85066],      
           [0.13105, 0.13105, 0.13105],      
           [0.62352, 0.62352, 0.62352],      
           [0.67285, 0.67285, 0.67285],      
           [0.96888, 0.96888, 0.96888],      
           [0.1696, 0.1696, 0.1696],      
           [0.42981, 0.42981, 0.42981],      
           [0.38445, 0.38445, 0.38445],      
           [0.11854, 0.11854, 0.11854],      
           [0.27168, 0.27168, 0.27168],      
           [0.30014, 0.30014, 0.30014],      
           [0.76503, 0.76503, 0.76503],      
           [0.41459, 0.41459, 0.41459],      
           [0.067013, 0.067014, 0.067014],      
           [0.51517, 0.51517, 0.51517]]      
      
grayCS_map = LinearSegmentedColormap.from_list('grayCS', cm_data)      
# For use of "viscm view"      
test_cm = grayCS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(grayCS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=grayCS_map)      
    plt.show()      
