# 
#         devonS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.17103, 0.1004, 0.29978],      
           [0.97357, 0.97102, 0.9946],      
           [0.46541, 0.54531, 0.85481],      
           [0.15721, 0.33688, 0.55],      
           [0.77788, 0.75776, 0.95431],      
           [0.15947, 0.21408, 0.41376],      
           [0.67022, 0.65223, 0.9289],      
           [0.24355, 0.43562, 0.72126],      
           [0.87255, 0.86088, 0.97382],      
           [0.57576, 0.59599, 0.89689],      
           [0.16605, 0.15887, 0.35797],      
           [0.153, 0.27597, 0.47721],      
           [0.18662, 0.38871, 0.63374],      
           [0.72769, 0.70392, 0.94373],      
           [0.82482, 0.80889, 0.96398],      
           [0.34009, 0.48804, 0.7967],      
           [0.92107, 0.91374, 0.98382],      
           [0.94725, 0.94227, 0.98921],      
           [0.75303, 0.7308, 0.94915],      
           [0.16908, 0.12989, 0.32874],      
           [0.21086, 0.41176, 0.67765],      
           [0.15595, 0.24449, 0.44456],      
           [0.62749, 0.62385, 0.91521],      
           [0.40285, 0.51731, 0.8284],      
           [0.16308, 0.1844, 0.3838],      
           [0.51834, 0.56896, 0.87542],      
           [0.8951, 0.88544, 0.97847],      
           [0.79969, 0.78151, 0.95881],      
           [0.16993, 0.36646, 0.59458],      
           [0.70354, 0.68012, 0.93806],      
           [0.15267, 0.30853, 0.51375],      
           [0.84699, 0.83304, 0.96856],      
           [0.28962, 0.4625, 0.76352],      
           [0.68789, 0.66628, 0.93396],      
           [0.19798, 0.40036, 0.65577],      
           [0.9604, 0.95662, 0.99191],      
           [0.16765, 0.14438, 0.34332],      
           [0.15232, 0.29214, 0.49486],      
           [0.81222, 0.79517, 0.96139],      
           [0.16131, 0.19914, 0.3987],      
           [0.54755, 0.58241, 0.88646],      
           [0.85974, 0.84693, 0.97118],      
           [0.74051, 0.71738, 0.94651],      
           [0.15768, 0.22918, 0.42901],      
           [0.37122, 0.50278, 0.81336],      
           [0.22582, 0.42338, 0.69948],      
           [0.43435, 0.53148, 0.84211],      
           [0.65011, 0.63804, 0.92269],      
           [0.15431, 0.26008, 0.46054],      
           [0.93413, 0.92797, 0.98652],      
           [0.60256, 0.6098, 0.90655],      
           [0.17023, 0.11524, 0.31422],      
           [0.76546, 0.74426, 0.95174],      
           [0.90806, 0.89956, 0.98114],      
           [0.16259, 0.3522, 0.57209],      
           [0.26478, 0.44865, 0.74275],      
           [0.71427, 0.69038, 0.94067],      
           [0.15456, 0.32486, 0.53399],      
           [0.31037, 0.47331, 0.77832],      
           [0.88219, 0.87138, 0.97581],      
           [0.8343, 0.81921, 0.96594],      
           [0.78721, 0.76791, 0.95623],      
           [0.49589, 0.55887, 0.8668],      
           [0.1648, 0.16979, 0.369],      
           [0.17895, 0.37954, 0.61705],      
           [0.69594, 0.67324, 0.93611],      
           [0.25373, 0.44203, 0.73207],      
           [0.77167, 0.75101, 0.95302],      
           [0.84064, 0.82612, 0.96725],      
           [0.58935, 0.60286, 0.90183],      
           [0.16397, 0.17708, 0.37639],      
           [0.92759, 0.92084, 0.98517],      
           [0.16837, 0.13713, 0.33601],      
           [0.44995, 0.53844, 0.84856],      
           [0.1586, 0.2216, 0.42135],      
           [0.23429, 0.42941, 0.71039],      
           [0.81851, 0.80202, 0.96269],      
           [0.15339, 0.31673, 0.52371],      
           [0.90157, 0.89249, 0.97981],      
           [0.73416, 0.71065, 0.94515],      
           [0.21803, 0.41753, 0.68857],      
           [0.15234, 0.30031, 0.50414],      
           [0.15962, 0.34465, 0.56096],      
           [0.79344, 0.7747, 0.95752],      
           [0.1697, 0.12254, 0.32146],      
           [0.67933, 0.65928, 0.93157],      
           [0.63911, 0.63094, 0.9191],      
           [0.75925, 0.73752, 0.95045],      
           [0.96698, 0.96382, 0.99326],      
           [0.20423, 0.40606, 0.66671],      
           [0.15256, 0.28401, 0.48589],      
           [0.88864, 0.8784, 0.97714],      
           [0.80595, 0.78833, 0.9601],      
           [0.35555, 0.49542, 0.80525],      
           [0.1622, 0.19175, 0.39124],      
           [0.53305, 0.57568, 0.88101],      
           [0.1551, 0.25226, 0.45249],      
           [0.48073, 0.55212, 0.86088],      
           [0.19213, 0.39459, 0.64477],      
           [0.17425, 0.37313, 0.60583]]      
      
devonS_map = LinearSegmentedColormap.from_list('devonS', cm_data)      
# For use of "viscm view"      
test_cm = devonS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(devonS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=devonS_map)      
    plt.show()      
