# 
#         davos
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0, 0.019685, 0.29201],      
           [0, 0.027123, 0.29748],      
           [0, 0.034324, 0.30295],      
           [0.00076962, 0.041437, 0.30847],      
           [0.0023129, 0.047559, 0.314],      
           [0.0043894, 0.053102, 0.31954],      
           [0.0066067, 0.058541, 0.32508],      
           [0.0088746, 0.063928, 0.33063],      
           [0.011304, 0.069327, 0.33618],      
           [0.013761, 0.074551, 0.34174],      
           [0.01619, 0.079806, 0.3473],      
           [0.01868, 0.085081, 0.35284],      
           [0.021233, 0.090352, 0.35838],      
           [0.023852, 0.095588, 0.36391],      
           [0.02654, 0.10079, 0.36945],      
           [0.029301, 0.10606, 0.37496],      
           [0.032137, 0.11127, 0.38047],      
           [0.035259, 0.11648, 0.38595],      
           [0.03825, 0.12165, 0.39144],      
           [0.041347, 0.12687, 0.39688],      
           [0.044338, 0.13212, 0.40232],      
           [0.047327, 0.13734, 0.40774],      
           [0.050291, 0.14254, 0.41314],      
           [0.053198, 0.14777, 0.4185],      
           [0.056204, 0.15296, 0.42383],      
           [0.05913, 0.15821, 0.42915],      
           [0.06198, 0.16344, 0.43442],      
           [0.06489, 0.16864, 0.43966],      
           [0.067805, 0.17386, 0.44487],      
           [0.070681, 0.17908, 0.45002],      
           [0.073639, 0.1843, 0.45515],      
           [0.076446, 0.18952, 0.46021],      
           [0.07937, 0.19476, 0.46524],      
           [0.082366, 0.19994, 0.47023],      
           [0.085246, 0.20517, 0.47517],      
           [0.088241, 0.21038, 0.48004],      
           [0.091235, 0.21558, 0.48485],      
           [0.094218, 0.2208, 0.48961],      
           [0.097192, 0.22598, 0.49432],      
           [0.10023, 0.23115, 0.49896],      
           [0.10333, 0.23632, 0.50353],      
           [0.10643, 0.24147, 0.50804],      
           [0.10953, 0.2466, 0.51247],      
           [0.11265, 0.25175, 0.51684],      
           [0.1158, 0.25686, 0.52112],      
           [0.11898, 0.26195, 0.52533],      
           [0.12214, 0.26702, 0.52947],      
           [0.12542, 0.27208, 0.53351],      
           [0.12867, 0.27714, 0.53749],      
           [0.13198, 0.28216, 0.54136],      
           [0.1353, 0.28713, 0.54517],      
           [0.13865, 0.29211, 0.54888],      
           [0.14202, 0.29706, 0.5525],      
           [0.14545, 0.30195, 0.55601],      
           [0.14883, 0.30685, 0.55945],      
           [0.15228, 0.31168, 0.56279],      
           [0.15579, 0.31652, 0.56602],      
           [0.15927, 0.3213, 0.56916],      
           [0.16281, 0.32604, 0.57221],      
           [0.16635, 0.33076, 0.57515],      
           [0.16993, 0.33545, 0.57799],      
           [0.17351, 0.34008, 0.58073],      
           [0.17713, 0.34467, 0.58337],      
           [0.18074, 0.34923, 0.58591],      
           [0.18441, 0.35374, 0.58833],      
           [0.1881, 0.35821, 0.59066],      
           [0.19176, 0.36264, 0.59289],      
           [0.19546, 0.36702, 0.595],      
           [0.19916, 0.37135, 0.59702],      
           [0.20291, 0.37564, 0.59892],      
           [0.20668, 0.37989, 0.60073],      
           [0.21041, 0.38408, 0.60243],      
           [0.21418, 0.38823, 0.60403],      
           [0.21795, 0.39233, 0.60552],      
           [0.22173, 0.39638, 0.60692],      
           [0.22553, 0.40038, 0.60821],      
           [0.22931, 0.40432, 0.6094],      
           [0.23311, 0.40823, 0.61049],      
           [0.23695, 0.41208, 0.61149],      
           [0.24073, 0.41588, 0.61238],      
           [0.24454, 0.41964, 0.61318],      
           [0.24839, 0.42333, 0.61388],      
           [0.2522, 0.42699, 0.6145],      
           [0.256, 0.43059, 0.61502],      
           [0.25984, 0.43414, 0.61546],      
           [0.26367, 0.43766, 0.61581],      
           [0.26745, 0.44111, 0.61607],      
           [0.27128, 0.44454, 0.61624],      
           [0.2751, 0.44789, 0.61633],      
           [0.27892, 0.45122, 0.61635],      
           [0.28273, 0.4545, 0.61628],      
           [0.2865, 0.45772, 0.61613],      
           [0.29031, 0.46091, 0.61591],      
           [0.2941, 0.46407, 0.61562],      
           [0.29789, 0.46717, 0.61525],      
           [0.30167, 0.47023, 0.61482],      
           [0.30547, 0.47324, 0.61432],      
           [0.30924, 0.47623, 0.61375],      
           [0.31299, 0.47918, 0.61312],      
           [0.31676, 0.48209, 0.61244],      
           [0.32052, 0.48496, 0.6117],      
           [0.32425, 0.48781, 0.6109],      
           [0.32799, 0.49062, 0.61003],      
           [0.33172, 0.49338, 0.60913],      
           [0.33546, 0.49612, 0.60817],      
           [0.33918, 0.49885, 0.60716],      
           [0.3429, 0.50154, 0.6061],      
           [0.34659, 0.5042, 0.605],      
           [0.3503, 0.50682, 0.60387],      
           [0.35399, 0.50943, 0.60268],      
           [0.3577, 0.51201, 0.60146],      
           [0.36137, 0.51458, 0.60021],      
           [0.36505, 0.51712, 0.59892],      
           [0.36873, 0.51964, 0.5976],      
           [0.37239, 0.52214, 0.59624],      
           [0.37607, 0.52463, 0.59486],      
           [0.37973, 0.5271, 0.59346],      
           [0.38339, 0.52956, 0.59203],      
           [0.38704, 0.532, 0.59056],      
           [0.3907, 0.53443, 0.58908],      
           [0.39435, 0.53685, 0.58759],      
           [0.39801, 0.53925, 0.58608],      
           [0.40165, 0.54165, 0.58455],      
           [0.40531, 0.54405, 0.583],      
           [0.40896, 0.54645, 0.58144],      
           [0.41262, 0.54884, 0.57988],      
           [0.41627, 0.55121, 0.5783],      
           [0.41992, 0.55359, 0.57672],      
           [0.42358, 0.55597, 0.57512],      
           [0.42725, 0.55835, 0.57353],      
           [0.43092, 0.56074, 0.57194],      
           [0.43459, 0.56313, 0.57033],      
           [0.43828, 0.56552, 0.56874],      
           [0.44197, 0.56792, 0.56715],      
           [0.44565, 0.57032, 0.56556],      
           [0.44937, 0.57275, 0.56398],      
           [0.45309, 0.57517, 0.56241],      
           [0.45681, 0.57761, 0.56084],      
           [0.46055, 0.58007, 0.55929],      
           [0.46433, 0.58253, 0.55775],      
           [0.46809, 0.58503, 0.55622],      
           [0.47189, 0.58752, 0.55473],      
           [0.4757, 0.59004, 0.55324],      
           [0.47953, 0.5926, 0.55178],      
           [0.48338, 0.59516, 0.55034],      
           [0.48726, 0.59776, 0.54894],      
           [0.49117, 0.60038, 0.54755],      
           [0.49509, 0.60303, 0.5462],      
           [0.49905, 0.60571, 0.54488],      
           [0.50303, 0.60843, 0.5436],      
           [0.50706, 0.61118, 0.54236],      
           [0.51112, 0.61395, 0.54116],      
           [0.51522, 0.61678, 0.54],      
           [0.51937, 0.61965, 0.53891],      
           [0.52355, 0.62255, 0.53786],      
           [0.52777, 0.62551, 0.53686],      
           [0.53206, 0.62851, 0.53591],      
           [0.53639, 0.63156, 0.53503],      
           [0.54077, 0.63467, 0.53422],      
           [0.54521, 0.63783, 0.53348],      
           [0.54971, 0.64104, 0.53282],      
           [0.55428, 0.64432, 0.53224],      
           [0.55891, 0.64767, 0.53174],      
           [0.56362, 0.65108, 0.53132],      
           [0.56839, 0.65456, 0.531],      
           [0.57326, 0.65811, 0.53079],      
           [0.57819, 0.66174, 0.53067],      
           [0.58321, 0.66544, 0.53067],      
           [0.58832, 0.66922, 0.53078],      
           [0.59353, 0.67309, 0.53102],      
           [0.59882, 0.67705, 0.53139],      
           [0.60422, 0.68107, 0.53189],      
           [0.60972, 0.68521, 0.53254],      
           [0.61531, 0.68944, 0.53332],      
           [0.62103, 0.69375, 0.53427],      
           [0.62684, 0.69816, 0.53539],      
           [0.63277, 0.70268, 0.53668],      
           [0.63881, 0.70728, 0.53814],      
           [0.64497, 0.71199, 0.53977],      
           [0.65125, 0.71681, 0.5416],      
           [0.65764, 0.72171, 0.54364],      
           [0.66413, 0.72672, 0.54587],      
           [0.67075, 0.73183, 0.54832],      
           [0.67748, 0.73703, 0.55097],      
           [0.68431, 0.74232, 0.55384],      
           [0.69125, 0.74771, 0.55694],      
           [0.6983, 0.75318, 0.56026],      
           [0.70544, 0.75873, 0.56382],      
           [0.71266, 0.76436, 0.5676],      
           [0.71998, 0.77006, 0.57162],      
           [0.72736, 0.77583, 0.57587],      
           [0.73481, 0.78165, 0.58035],      
           [0.74231, 0.78751, 0.58506],      
           [0.74985, 0.79342, 0.58999],      
           [0.75743, 0.79936, 0.59516],      
           [0.76503, 0.80531, 0.60053],      
           [0.77263, 0.81128, 0.60612],      
           [0.78022, 0.81724, 0.61191],      
           [0.7878, 0.82319, 0.61789],      
           [0.79534, 0.82912, 0.62406],      
           [0.80283, 0.83501, 0.6304],      
           [0.81025, 0.84085, 0.63691],      
           [0.81761, 0.84664, 0.64355],      
           [0.82487, 0.85237, 0.65035],      
           [0.83203, 0.85801, 0.65727],      
           [0.83907, 0.86357, 0.66429],      
           [0.84598, 0.86903, 0.67142],      
           [0.85276, 0.87439, 0.67863],      
           [0.85938, 0.87963, 0.68592],      
           [0.86585, 0.88476, 0.69326],      
           [0.87216, 0.88977, 0.70066],      
           [0.87829, 0.89464, 0.70808],      
           [0.88424, 0.89938, 0.71554],      
           [0.89001, 0.90397, 0.72299],      
           [0.89559, 0.90844, 0.73047],      
           [0.90099, 0.91275, 0.73792],      
           [0.90619, 0.91692, 0.74537],      
           [0.9112, 0.92095, 0.75278],      
           [0.91602, 0.92483, 0.76018],      
           [0.92065, 0.92857, 0.76753],      
           [0.92509, 0.93217, 0.77484],      
           [0.92935, 0.93564, 0.78211],      
           [0.93342, 0.93896, 0.78932],      
           [0.93732, 0.94215, 0.79647],      
           [0.94103, 0.94521, 0.80357],      
           [0.94458, 0.94814, 0.81061],      
           [0.94796, 0.95096, 0.81759],      
           [0.95118, 0.95365, 0.82451],      
           [0.95425, 0.95622, 0.83137],      
           [0.95716, 0.95869, 0.83816],      
           [0.95993, 0.96104, 0.84489],      
           [0.96256, 0.9633, 0.85156],      
           [0.96506, 0.96546, 0.85817],      
           [0.96743, 0.96753, 0.86472],      
           [0.96967, 0.9695, 0.87121],      
           [0.97181, 0.9714, 0.87765],      
           [0.97382, 0.97321, 0.88403],      
           [0.97573, 0.97495, 0.89036],      
           [0.97755, 0.97662, 0.89664],      
           [0.97927, 0.97822, 0.90287],      
           [0.98089, 0.97976, 0.90905],      
           [0.98244, 0.98124, 0.91519],      
           [0.9839, 0.98267, 0.9213],      
           [0.98528, 0.98404, 0.92736],      
           [0.9866, 0.98537, 0.93338],      
           [0.98784, 0.98665, 0.93938],      
           [0.98903, 0.98789, 0.94534],      
           [0.99015, 0.9891, 0.95127],      
           [0.99123, 0.99027, 0.95718],      
           [0.99225, 0.99141, 0.96306],      
           [0.99323, 0.99252, 0.96892],      
           [0.99415, 0.99361, 0.97476],      
           [0.99505, 0.99467, 0.98059],      
           [0.9959, 0.99572, 0.98641],      
           [0.99673, 0.99675, 0.9922],      
           [0.99752, 0.99776, 0.99799]]      
      
davos_map = LinearSegmentedColormap.from_list('davos', cm_data)      
# For use of "viscm view"      
test_cm = davos_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(davos_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=davos_map)      
    plt.show()      
