# 
#         davosS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0, 0.019685, 0.29201],      
           [0.99123, 0.99027, 0.95718],      
           [0.40896, 0.54645, 0.58144],      
           [0.6983, 0.75318, 0.56026],      
           [0.17713, 0.34467, 0.58337],      
           [0.9112, 0.92095, 0.75278],      
           [0.52777, 0.62551, 0.53686],      
           [0.076446, 0.18952, 0.46021],      
           [0.2941, 0.46407, 0.61562],      
           [0.029301, 0.10606, 0.37496],      
           [0.81761, 0.84664, 0.64355],      
           [0.46433, 0.58253, 0.55775],      
           [0.23695, 0.41208, 0.61149],      
           [0.12542, 0.27208, 0.53351],      
           [0.60422, 0.68107, 0.53189],      
           [0.35399, 0.50943, 0.60268],      
           [0.96506, 0.96546, 0.85817],      
           [0.32425, 0.48781, 0.6109],      
           [0.053198, 0.14777, 0.4185],      
           [0.49509, 0.60303, 0.5462],      
           [0.98089, 0.97976, 0.90905],      
           [0.20668, 0.37989, 0.60073],      
           [0.56362, 0.65108, 0.53132],      
           [0.10023, 0.23115, 0.49896],      
           [0.75743, 0.79936, 0.59516],      
           [0.14883, 0.30685, 0.55945],      
           [0.011304, 0.069327, 0.33618],      
           [0.86585, 0.88476, 0.69326],      
           [0.43459, 0.56313, 0.57033],      
           [0.65125, 0.71681, 0.5416],      
           [0.94103, 0.94521, 0.80357],      
           [0.37973, 0.5271, 0.59346],      
           [0.26745, 0.44111, 0.61607],      
           [0.95425, 0.95622, 0.83137],      
           [0.33918, 0.49885, 0.60716],      
           [0.088241, 0.21038, 0.48004],      
           [0.041347, 0.12687, 0.39688],      
           [0.62684, 0.69816, 0.53539],      
           [0.22173, 0.39638, 0.60692],      
           [0.58321, 0.66544, 0.53067],      
           [0.54521, 0.63783, 0.53348],      
           [0.44937, 0.57275, 0.56398],      
           [0.72736, 0.77583, 0.57587],      
           [0.39435, 0.53685, 0.58759],      
           [0.30924, 0.47623, 0.61375],      
           [0.2522, 0.42699, 0.6145],      
           [0.9866, 0.98537, 0.93338],      
           [0.16281, 0.32604, 0.57221],      
           [0.06489, 0.16864, 0.43966],      
           [0.11265, 0.25175, 0.51684],      
           [0.7878, 0.82319, 0.61789],      
           [0.97382, 0.97321, 0.88403],      
           [0.89001, 0.90397, 0.72299],      
           [0.0023129, 0.047559, 0.314],      
           [0.47953, 0.5926, 0.55178],      
           [0.51112, 0.61395, 0.54116],      
           [0.19176, 0.36264, 0.59289],      
           [0.67075, 0.73183, 0.54832],      
           [0.83907, 0.86357, 0.66429],      
           [0.13865, 0.29211, 0.54888],      
           [0.01868, 0.085081, 0.35284],      
           [0.92509, 0.93217, 0.77484],      
           [0.36505, 0.51712, 0.59892],      
           [0.42358, 0.55597, 0.57512],      
           [0.27892, 0.45122, 0.61635],      
           [0.93342, 0.93896, 0.78932],      
           [0.98903, 0.98789, 0.94534],      
           [0.85276, 0.87439, 0.67863],      
           [0.0066067, 0.058541, 0.32508],      
           [0.44197, 0.56792, 0.56715],      
           [0.9839, 0.98267, 0.9213],      
           [0.38704, 0.532, 0.59056],      
           [0.80283, 0.83501, 0.6304],      
           [0.047327, 0.13734, 0.40774],      
           [0.97755, 0.97662, 0.89664],      
           [0.90099, 0.91275, 0.73792],      
           [0.41627, 0.55121, 0.5783],      
           [0.2865, 0.45772, 0.61613],      
           [0.21418, 0.38823, 0.60403],      
           [0.57326, 0.65811, 0.53079],      
           [0, 0.034324, 0.30295],      
           [0.24454, 0.41964, 0.61318],      
           [0.87829, 0.89464, 0.70808],      
           [0.40165, 0.54165, 0.58455],      
           [0.33172, 0.49338, 0.60913],      
           [0.34659, 0.5042, 0.605],      
           [0.16993, 0.33545, 0.57799],      
           [0.95993, 0.96104, 0.84489],      
           [0.96967, 0.9695, 0.87121],      
           [0.37239, 0.52214, 0.59624],      
           [0.94796, 0.95096, 0.81759],      
           [0.25984, 0.43414, 0.61546],      
           [0.22931, 0.40432, 0.6094],      
           [0.094218, 0.2208, 0.48961],      
           [0.10643, 0.24147, 0.50804],      
           [0.63881, 0.70728, 0.53814],      
           [0.55428, 0.64432, 0.53224],      
           [0.45681, 0.57761, 0.56084],      
           [0.68431, 0.74232, 0.55384],      
           [0.31676, 0.48209, 0.61244]]      
      
davosS_map = LinearSegmentedColormap.from_list('davosS', cm_data)      
# For use of "viscm view"      
test_cm = davosS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(davosS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=davosS_map)      
    plt.show()      
