# 
#         corkO
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.24651, 0.24352, 0.2292],      
           [0.24607, 0.24243, 0.23232],      
           [0.24564, 0.24145, 0.23554],      
           [0.24522, 0.24052, 0.23883],      
           [0.24481, 0.23974, 0.24225],      
           [0.24441, 0.23905, 0.24576],      
           [0.24402, 0.23847, 0.2494],      
           [0.24365, 0.23802, 0.25316],      
           [0.24329, 0.23769, 0.25703],      
           [0.24295, 0.23749, 0.26102],      
           [0.24264, 0.23741, 0.26513],      
           [0.24235, 0.23747, 0.2694],      
           [0.24209, 0.23767, 0.27379],      
           [0.24185, 0.23802, 0.27831],      
           [0.24164, 0.23852, 0.28299],      
           [0.24147, 0.23921, 0.2878],      
           [0.24133, 0.24005, 0.29278],      
           [0.24123, 0.24109, 0.29791],      
           [0.24118, 0.24229, 0.30319],      
           [0.24118, 0.24368, 0.30866],      
           [0.24123, 0.24527, 0.31425],      
           [0.24135, 0.24707, 0.32003],      
           [0.24152, 0.24906, 0.32594],      
           [0.24176, 0.25127, 0.33205],      
           [0.24207, 0.25367, 0.33828],      
           [0.24246, 0.25627, 0.34469],      
           [0.24293, 0.25913, 0.35124],      
           [0.2435, 0.26218, 0.35795],      
           [0.24417, 0.26544, 0.36478],      
           [0.24494, 0.26895, 0.37175],      
           [0.24582, 0.27263, 0.37886],      
           [0.24683, 0.27657, 0.38607],      
           [0.24797, 0.28067, 0.39341],      
           [0.24921, 0.28501, 0.40086],      
           [0.25059, 0.28956, 0.40836],      
           [0.25214, 0.29428, 0.41596],      
           [0.25383, 0.29922, 0.42362],      
           [0.25567, 0.30432, 0.43135],      
           [0.25767, 0.30961, 0.43909],      
           [0.25986, 0.31504, 0.44689],      
           [0.26221, 0.32066, 0.4547],      
           [0.26473, 0.32639, 0.46249],      
           [0.26743, 0.3323, 0.47031],      
           [0.27036, 0.33831, 0.47809],      
           [0.27343, 0.34444, 0.48584],      
           [0.2767, 0.35071, 0.49355],      
           [0.28015, 0.35705, 0.50123],      
           [0.2838, 0.36348, 0.50884],      
           [0.28763, 0.36999, 0.51637],      
           [0.29167, 0.37659, 0.52384],      
           [0.29586, 0.38324, 0.53123],      
           [0.30024, 0.38994, 0.53854],      
           [0.3048, 0.39669, 0.54575],      
           [0.30955, 0.40349, 0.55287],      
           [0.31442, 0.41032, 0.55989],      
           [0.31949, 0.41717, 0.56681],      
           [0.32469, 0.42404, 0.57363],      
           [0.33007, 0.43093, 0.58034],      
           [0.33558, 0.43784, 0.58695],      
           [0.34122, 0.44474, 0.59345],      
           [0.347, 0.45164, 0.59985],      
           [0.3529, 0.45854, 0.60614],      
           [0.35891, 0.46544, 0.61233],      
           [0.36505, 0.47234, 0.61843],      
           [0.37128, 0.47923, 0.62442],      
           [0.37763, 0.48609, 0.63031],      
           [0.38406, 0.49295, 0.6361],      
           [0.39058, 0.49979, 0.64179],      
           [0.39718, 0.50662, 0.64739],      
           [0.40387, 0.51343, 0.65289],      
           [0.41063, 0.52021, 0.65831],      
           [0.41745, 0.52699, 0.66363],      
           [0.42432, 0.53373, 0.66887],      
           [0.43126, 0.54046, 0.67401],      
           [0.43824, 0.54716, 0.67907],      
           [0.44526, 0.55384, 0.68404],      
           [0.45234, 0.5605, 0.68893],      
           [0.45943, 0.56714, 0.69372],      
           [0.46656, 0.57374, 0.69844],      
           [0.4737, 0.58032, 0.70307],      
           [0.48087, 0.58686, 0.70761],      
           [0.48806, 0.59339, 0.71206],      
           [0.49525, 0.59988, 0.71643],      
           [0.50243, 0.60634, 0.72069],      
           [0.50961, 0.61277, 0.72487],      
           [0.51679, 0.61917, 0.72895],      
           [0.52394, 0.62553, 0.73294],      
           [0.53106, 0.63185, 0.73681],      
           [0.53817, 0.63813, 0.74059],      
           [0.54522, 0.64436, 0.74425],      
           [0.55224, 0.65056, 0.74781],      
           [0.55919, 0.65671, 0.75124],      
           [0.56609, 0.6628, 0.75455],      
           [0.57292, 0.66883, 0.75772],      
           [0.57967, 0.6748, 0.76076],      
           [0.58632, 0.68071, 0.76366],      
           [0.59289, 0.68655, 0.76641],      
           [0.59934, 0.69232, 0.769],      
           [0.60566, 0.698, 0.77143],      
           [0.61187, 0.7036, 0.77368],      
           [0.61793, 0.70911, 0.77576],      
           [0.62384, 0.7145, 0.77766],      
           [0.62958, 0.7198, 0.77935],      
           [0.63514, 0.72498, 0.78084],      
           [0.64052, 0.73004, 0.78213],      
           [0.64568, 0.73497, 0.78319],      
           [0.65064, 0.73976, 0.78403],      
           [0.65536, 0.74439, 0.78463],      
           [0.65985, 0.74887, 0.78499],      
           [0.66407, 0.75319, 0.78511],      
           [0.66804, 0.75733, 0.78497],      
           [0.67172, 0.76129, 0.78457],      
           [0.67512, 0.76506, 0.7839],      
           [0.67822, 0.76862, 0.78296],      
           [0.681, 0.77199, 0.78176],      
           [0.68348, 0.77513, 0.78028],      
           [0.68563, 0.77806, 0.77853],      
           [0.68744, 0.78075, 0.7765],      
           [0.68892, 0.78321, 0.77419],      
           [0.69005, 0.78543, 0.77162],      
           [0.69084, 0.7874, 0.76877],      
           [0.69128, 0.78913, 0.76566],      
           [0.69138, 0.79061, 0.76228],      
           [0.69113, 0.79184, 0.75865],      
           [0.69054, 0.79281, 0.75476],      
           [0.68962, 0.79354, 0.75063],      
           [0.68836, 0.79401, 0.74626],      
           [0.68676, 0.79423, 0.74166],      
           [0.68485, 0.7942, 0.73685],      
           [0.68262, 0.79393, 0.73183],      
           [0.68008, 0.79342, 0.7266],      
           [0.67727, 0.79267, 0.72118],      
           [0.67415, 0.79169, 0.71559],      
           [0.67077, 0.79049, 0.70981],      
           [0.66712, 0.78907, 0.70387],      
           [0.66324, 0.78743, 0.69778],      
           [0.6591, 0.78559, 0.69154],      
           [0.65474, 0.78355, 0.68517],      
           [0.65017, 0.78131, 0.67867],      
           [0.64539, 0.77888, 0.67205],      
           [0.64043, 0.77628, 0.66532],      
           [0.63528, 0.7735, 0.65848],      
           [0.62998, 0.77056, 0.65155],      
           [0.62451, 0.76745, 0.64451],      
           [0.61891, 0.76419, 0.6374],      
           [0.61315, 0.76078, 0.6302],      
           [0.6073, 0.75722, 0.62293],      
           [0.60131, 0.75352, 0.61558],      
           [0.59523, 0.74969, 0.60817],      
           [0.58904, 0.74573, 0.60069],      
           [0.58278, 0.74164, 0.59315],      
           [0.57645, 0.73743, 0.58556],      
           [0.57002, 0.73311, 0.5779],      
           [0.56356, 0.72866, 0.5702],      
           [0.55703, 0.72411, 0.56246],      
           [0.55045, 0.71944, 0.55465],      
           [0.54383, 0.71466, 0.54681],      
           [0.53719, 0.70979, 0.53892],      
           [0.53051, 0.7048, 0.53099],      
           [0.52381, 0.69972, 0.52302],      
           [0.5171, 0.69453, 0.51501],      
           [0.51038, 0.68926, 0.50697],      
           [0.50366, 0.68387, 0.4989],      
           [0.49694, 0.6784, 0.4908],      
           [0.49024, 0.67284, 0.48266],      
           [0.48354, 0.66717, 0.47451],      
           [0.47688, 0.66142, 0.46632],      
           [0.47024, 0.65557, 0.45813],      
           [0.46363, 0.64965, 0.44992],      
           [0.45706, 0.64362, 0.4417],      
           [0.45054, 0.63752, 0.43346],      
           [0.44407, 0.63134, 0.42525],      
           [0.43766, 0.62507, 0.41702],      
           [0.4313, 0.61874, 0.40881],      
           [0.42502, 0.61231, 0.40062],      
           [0.4188, 0.60582, 0.39243],      
           [0.41269, 0.59928, 0.38429],      
           [0.40664, 0.59266, 0.3762],      
           [0.4007, 0.58599, 0.36814],      
           [0.39484, 0.57926, 0.36013],      
           [0.3891, 0.57248, 0.35219],      
           [0.38347, 0.56565, 0.34432],      
           [0.37794, 0.55879, 0.33653],      
           [0.37254, 0.55192, 0.32885],      
           [0.36726, 0.545, 0.32125],      
           [0.36212, 0.53808, 0.31377],      
           [0.35711, 0.53113, 0.30642],      
           [0.35222, 0.52419, 0.29918],      
           [0.3475, 0.51725, 0.29209],      
           [0.3429, 0.51032, 0.28513],      
           [0.33844, 0.50341, 0.27837],      
           [0.33415, 0.49653, 0.27174],      
           [0.33, 0.48969, 0.26533],      
           [0.32598, 0.48289, 0.2591],      
           [0.32214, 0.47614, 0.25304],      
           [0.31843, 0.46946, 0.24719],      
           [0.31487, 0.46281, 0.24156],      
           [0.31147, 0.45626, 0.23614],      
           [0.30822, 0.44978, 0.23093],      
           [0.30511, 0.44338, 0.22597],      
           [0.30213, 0.43708, 0.22122],      
           [0.29932, 0.43086, 0.21671],      
           [0.29663, 0.42474, 0.21242],      
           [0.29405, 0.41872, 0.20837],      
           [0.29164, 0.41283, 0.20457],      
           [0.28934, 0.40702, 0.20097],      
           [0.28714, 0.40134, 0.19765],      
           [0.28507, 0.39577, 0.19457],      
           [0.28314, 0.3903, 0.19167],      
           [0.28128, 0.38496, 0.18903],      
           [0.27955, 0.37974, 0.18661],      
           [0.2779, 0.37465, 0.18441],      
           [0.27636, 0.36966, 0.18241],      
           [0.27487, 0.36479, 0.18063],      
           [0.27351, 0.36004, 0.17908],      
           [0.27218, 0.35543, 0.17773],      
           [0.27097, 0.35091, 0.17651],      
           [0.26982, 0.34649, 0.17553],      
           [0.26872, 0.34221, 0.17474],      
           [0.26766, 0.33802, 0.17409],      
           [0.2667, 0.33396, 0.17361],      
           [0.26578, 0.32999, 0.1733],      
           [0.26489, 0.32611, 0.17314],      
           [0.26408, 0.32237, 0.17313],      
           [0.26329, 0.3187, 0.17327],      
           [0.26252, 0.31513, 0.17354],      
           [0.2618, 0.31165, 0.17394],      
           [0.26111, 0.30827, 0.17448],      
           [0.26046, 0.30499, 0.17512],      
           [0.25983, 0.30177, 0.17584],      
           [0.25922, 0.29866, 0.17672],      
           [0.25862, 0.29562, 0.17773],      
           [0.25804, 0.29267, 0.17879],      
           [0.25749, 0.28979, 0.17994],      
           [0.25696, 0.28698, 0.18119],      
           [0.25642, 0.28427, 0.18254],      
           [0.2559, 0.28162, 0.184],      
           [0.25541, 0.27906, 0.18555],      
           [0.25492, 0.27655, 0.18714],      
           [0.25442, 0.27411, 0.18883],      
           [0.25393, 0.27173, 0.19058],      
           [0.25345, 0.26946, 0.19242],      
           [0.25297, 0.2672, 0.19437],      
           [0.2525, 0.26505, 0.19635],      
           [0.25203, 0.26297, 0.19839],      
           [0.25156, 0.26095, 0.20052],      
           [0.25109, 0.259, 0.20275],      
           [0.25061, 0.25711, 0.20504],      
           [0.25014, 0.25531, 0.20742],      
           [0.24968, 0.25356, 0.20985],      
           [0.24923, 0.2519, 0.21238],      
           [0.24878, 0.25028, 0.21495],      
           [0.24833, 0.24879, 0.21765],      
           [0.24787, 0.24734, 0.22042],      
           [0.24741, 0.24598, 0.22326],      
           [0.24696, 0.2447, 0.2262]]      
      
corkO_map = LinearSegmentedColormap.from_list('corkO', cm_data)      
# For use of "viscm view"      
test_cm = corkO_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(corkO_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=corkO_map)      
    plt.show()      
